%define _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel

%define _pseudouser_user     _uwsgi
%define _pseudouser_group    _uwsgi
%define _pseudouser_home     /var/empty

%define gemname uwsgi
%define pypi_name uWSGI
%define mod_name uwsgidecorators
%define distinfo_name uWSGI

%def_without check

Name: uwsgi
Version: 2.0.23
Release: alt3

Summary: fast (pure C), self-healing, developer-friendly WSGI server
License: GPLv2
Group: System/Servers
Url: http://projects.unbit.it/uwsgi/
Vcs: https://github.com/unbit/uwsgi.git

Source: %name-%version.tar
Source1: %name.init
Source2: %name.logrotate
Source3: %name.sysconfig
Patch1: %name-2.0.15-alt-no-rpath.patch
Patch2000: %name-e2k.patch

BuildRequires(pre): rpm-build-ruby
BuildRequires(pre): rpm-build-python3
BuildRequires: libxml2-devel
BuildRequires: python3-module-wheel
%if_enabled check
BuildRequires: gem(rack) >= 0
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*

%description
uWSGI is a fast (pure C), self-healing, developer-friendly WSGI server,
aimed for professional python webapps deployment and development. Over
time it has evolved in a complete stack for networked/clustered python
applications, implementing message/object passing, RPC and process
management. It uses the uwsgi (all lowercase) protocol for all the
networking/interprocess communications. From the 0.9.5 release it
includes a plugin loading technology that can be used to add support for
other languages or platform. A Lua wsapi adaptor, a PSGI handler and an
Erlang message exchanger are already available.


%package       -n python3-module-%name
Summary:       fast (pure C), self-healing, developer-friendly WSGI server python3 module
Group:         Development/Python3
BuildArch:     noarch

%py3_provides  %name
Requires:      %name = %EVR

%description -n python3-module-%name
uWSGI is a fast (pure C), self-healing, developer-friendly WSGI server,
aimed for professional python webapps deployment and development. Over
time it has evolved in a complete stack for networked/clustered python
applications, implementing message/object passing, RPC and process
management. It uses the uwsgi (all lowercase) protocol for all the
networking/interprocess communications. From the 0.9.5 release it
includes a plugin loading technology that can be used to add support for
other languages or platform. A Lua wsapi adaptor, a PSGI handler and an
Erlang message exchanger are already available.


%package       -n gem-uwsgi
Summary:       The uWSGI server for Ruby/Rack
Group:         Development/Ruby

Requires:      gem(rack) >= 0
Provides:      gem(uwsgi) = %version

%description   -n gem-uwsgi
The uWSGI server for Ruby/Rack library.

uWSGI is a fast (pure C), self-healing, developer-friendly WSGI server,
aimed for professional python webapps deployment and development. Over
time it has evolved in a complete stack for networked/clustered python
applications, implementing message/object passing, RPC and process
management. It uses the uwsgi (all lowercase) protocol for all the
networking/interprocess communications. From the 0.9.5 release it
includes a plugin loading technology that can be used to add support for
other languages or platform. A Lua wsapi adaptor, a PSGI handler and an
Erlang message exchanger are already available.

%description   -n gem-uwsgi -l ru_RU.UTF-8
Самоцвет uwsgi.


%if_enabled    doc
%package       -n gem-uwsgi-doc
Summary:       The uWSGI server for Ruby/Rack documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета uwsgi
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(uwsgi) = %version

%description   -n gem-uwsgi-doc
The uWSGI server for Ruby/Rack documentation files.

uWSGI is a fast (pure C), self-healing, developer-friendly WSGI server,
aimed for professional python webapps deployment and development. Over
time it has evolved in a complete stack for networked/clustered python
applications, implementing message/object passing, RPC and process
management. It uses the uwsgi (all lowercase) protocol for all the
networking/interprocess communications. From the 0.9.5 release it
includes a plugin loading technology that can be used to add support for
other languages or platform. A Lua wsapi adaptor, a PSGI handler and an
Erlang message exchanger are already available.

%description   -n gem-uwsgi-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета uwsgi.
%endif


%if_enabled    devel
%package       -n gem-uwsgi-devel
Summary:       The uWSGI server for Ruby/Rack development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета uwsgi
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(uwsgi) = %version

%description   -n gem-uwsgi-devel
The uWSGI server for Ruby/Rack development package.

uWSGI is a fast (pure C), self-healing, developer-friendly WSGI server,
aimed for professional python webapps deployment and development. Over
time it has evolved in a complete stack for networked/clustered python
applications, implementing message/object passing, RPC and process
management. It uses the uwsgi (all lowercase) protocol for all the
networking/interprocess communications. From the 0.9.5 release it
includes a plugin loading technology that can be used to add support for
other languages or platform. A Lua wsapi adaptor, a PSGI handler and an
Erlang message exchanger are already available.

%description   -n gem-uwsgi-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета uwsgi.
%endif


%pre
/usr/sbin/groupadd -r -f %_pseudouser_group ||:
/usr/sbin/useradd -g %_pseudouser_group -c 'The uwsgi daemon' \
	-d %_pseudouser_home -s /dev/null -r %_pseudouser_user >/dev/null 2>&1 ||:

%prep
%setup
%autopatch -p1

%build
%make
%ruby_build
%python3_build_debug

%install
%python3_install
%ruby_install
install -dm0775 %buildroot%_logdir/%name

install -pDm0755 %name %buildroot%_bindir/%name
install -pDm0755 %SOURCE1 %buildroot%_initdir/%name
install -pDm0644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/%name
install -pDm0644 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/%name

%check
%ruby_test

%post
%post_service %name

%preun
%preun_service %name

%files
%_bindir/%name
%dir %attr(0775,root,%_pseudouser_group) %_logdir/%name
%config %_initdir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%config(noreplace) %_sysconfdir/logrotate.d/%name
%doc README contrib

%files -n python3-module-%name
%doc CONTRIBUTORS LICENSE README contrib
%python3_sitelibdir_noarch/%mod_name.py
%python3_sitelibdir_noarch/%{distinfo_name}*
%python3_sitelibdir_noarch/__pycache__/%{mod_name}*

%files         -n gem-uwsgi
%doc CONTRIBUTORS LICENSE README contrib
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%if_enabled    doc
%files         -n gem-uwsgi-doc
%doc CONTRIBUTORS LICENSE README contrib
#%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-uwsgi-devel
%doc CONTRIBUTORS LICENSE README contrib
%endif


%changelog
