%def_disable snapshot

%define ver_major 2025.1
%define rdn_name io.github.giantpinkrobots.varia

%def_enable check

Name: varia
Version: %ver_major.24
Release: alt1

Summary: Quick and efficient download manager
License: MPL-2.0
Group: Networking/WWW
Url: https://github.com/giantpinkrobots/varia

Vcs: https://github.com/giantpinkrobots/varia.git

%if_disabled snapshot
Source: %url/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

%define adw_ver 1.6

Requires: /usr/bin/aria2p /usr/bin/aria2c
Requires: typelib(Adw) = 1 libadwaita >= %adw_ver
Requires: yt-dlp
Requires: dconf yelp

BuildArch: noarch

%add_python3_path %_datadir/%name

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir rpm-build-xdg
BuildRequires: meson yelp-tools
BuildRequires: pkgconfig(libadwaita-1)
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils /usr/bin/glib-compile-schemas}

%description
Varia is a simple download manager that conforms to the latest
Libadwaita design guidelines, integrating nicely with GNOME. It utilizes
aria2 and yt-dlp to handle regular files, torrents and video/audio
stream downloads.


%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name

%check
%__meson_test

%files -f %name.lang
%attr(0755,root,root) %_bindir/%name
%_bindir/%name-py.py
%_datadir/%name/
%_desktopdir/%rdn_name.desktop
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*/*/%{rdn_name}*.svg
%_iconsdir/hicolor/symbolic/apps/network-computer-symbolic.svg
%_xdgmimedir/packages/io.github.giantpinkrobots.varia.mime.xml
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README*

%changelog
