Name: weechat
Version: 4.0.5
Release: alt1

Summary: fast, light & extensible IRC client
License: GPL-3.0
Group: Networking/IRC

URL: http://www.weechat.org/

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define _localstatedir /var

%set_verify_elf_method strict

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: asciidoctor
BuildRequires: libaspell-devel
BuildRequires: lua-devel
BuildRequires: perl-devel
BuildRequires: python3-devel

BuildRequires: pkgconfig(gnutls)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libgcrypt)
BuildRequires: pkgconfig(libzstd)
BuildRequires: pkgconfig(ncursesw)
BuildRequires: pkgconfig(tcl)
BuildRequires: pkgconfig(zlib)

Obsoletes: weechat-plugin-ruby <= 2.6-alt1

%description
WeeChat is a fast, light and extensible chat client. It runs on many
platforms (including Linux, BSD and Mac OS).
WeeChat is:
- modular: a lightweight core with plugins around
- multi-protocols: IRC and Jabber (other soon)
- extensible: C plugins and scripts (Perl, Python, Ruby, Lua and Tcl)
- free software: released under GPLv3 license
- fully documented: user's guide, API, FAQ,.. translated in many languages
Development is very active, and bug fixes are very fast!

%package plugin-aspell
Summary: Aspell plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-aspell
This package contains aspell plugin for weechat.

%package plugin-lua
Summary: Lua plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-lua
This package contains lua plugin for weechat.

%package plugin-perl
Summary: Perl plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-perl
This package contains perl plugin for weechat.

%package plugin-python
Summary: Python plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-python
This package contains python plugin for weechat.

%package plugin-tcl
Summary: Tcl plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-tcl
This package contains tcl plugin for weechat.

%prep
%setup

# build plugins as plugins, not libs
find ./src/plugins -name "Makefile*" -print0 | xargs -r0 subst 's,\(\-module\),\1 -avoid-version,' --

%build
%cmake \
	-DENABLE_GUILE=OFF \
	-DENABLE_PHP=OFF \
	-DENABLE_RUBY=OFF \
	-DLIBDIR=%_libdir \
	-DENABLE_MAN=ON
%cmake_build

%install
%cmake_install

rm -rf -- \
	%buildroot/%_includedir \
	%buildroot/%_pkgconfigdir \
#

find %buildroot -name '*.la' -delete
find %buildroot -name '*.a' -delete

%find_lang --output=%name.lang --with-man          %name
%find_lang --output=%name.lang --with-man --append %name-headless

%files -f %name.lang
%_bindir/*
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/%name.png
%_libdir/%name/plugins/alias.so
%_libdir/%name/plugins/buflist.so
%_libdir/%name/plugins/charset.so
%_libdir/%name/plugins/exec.so
%_libdir/%name/plugins/fifo.so
%_libdir/%name/plugins/fset.so
%_libdir/%name/plugins/irc.so
%_libdir/%name/plugins/logger.so
%_libdir/%name/plugins/relay.so
%_libdir/%name/plugins/script.so
%_libdir/%name/plugins/trigger.so
%_libdir/%name/plugins/typing.so
%_libdir/%name/plugins/xfer.so
%_mandir/man*/*

%files plugin-aspell
%_libdir/%name/plugins/spell.so

%files plugin-lua
%_libdir/%name/plugins/lua.so

%files plugin-perl
%_libdir/%name/plugins/perl.so

%files plugin-python
%_libdir/%name/plugins/python.so

%files plugin-tcl
%_libdir/%name/plugins/tcl.so

%changelog
