%define _unpackaged_files_terminate_build 1

Name: winehelper
Version: 0.8.0
Release: alt1

Summary: Program for easy installation of Windows applications.

License: LGPLv2+
Group: Emulators
Url: https://git.linux-gaming.ru/CastroFidel/winehelper

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

Requires: wine
Requires: ca-certificates
Requires: p7zip

%add_findreq_skiplist %_datadir/%name/winetricks_*
%add_findreq_skiplist %_datadir/%name/autoinstall/*
%add_findreq_skiplist %_datadir/%name/manualinstall/*
%add_findreq_skiplist %_datadir/%name/testinstall/*
%add_findreq_skiplist %_datadir/%name/database/*

ExclusiveArch: x86_64

%description
Program for easy installation of Windows applications with the possibility
of automatic prefix tuning.

%package qt
Group: Emulators
Summary: Graphical interface for WineHelper
Requires: %name = %EVR
%description qt
%summary

%prep
%setup

%build
%install
# base files:
install -Dm755 %name %buildroot%_bindir/%name

mkdir -p %buildroot%_datadir/%name/{autoinstall,manualinstall,testinstall,database,image}
install -m755 dependencies.sh %buildroot%_datadir/%name/
install -m755 winetricks_* %buildroot%_datadir/%name/
install -m644 sha256sum.list %buildroot%_datadir/%name/
install -m644 manualinstall/* %buildroot%_datadir/%name/manualinstall/
install -m644 autoinstall/*  %buildroot%_datadir/%name/autoinstall/
install -m644 testinstall/*  %buildroot%_datadir/%name/testinstall/
install -m644 database/* %buildroot%_datadir/%name/database/
install -m644 image/*.png %buildroot%_datadir/%name/image/

install -Dm644 auto_completion/bash_completion/%name %buildroot%_sysconfdir/bash_completion.d/%name
install -Dm644 auto_completion/zsh_completion/_%name %buildroot%_datadir/zsh/Completion/Linux/_%name

# GUI files:
install -Dm644 %name.desktop %buildroot%_desktopdir/%name.desktop
install -Dm644 image/gui/%name.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg
install -Dm644 image/gui/%name-symbolic.svg %buildroot%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
install -m755 %{name}_gui.py %buildroot%_datadir/%name/%{name}_gui.py

%files
%doc LICENSE LICENSE_AGREEMENT CHANGELOG COPYING THIRD-PARTY GENERAL README.md
%_bindir/%name
%_datadir/%name/
%exclude %_datadir/%name/%{name}_gui.py
%_sysconfdir/bash_completion.d/%name
%_datadir/zsh/Completion/Linux/_%name

%files qt
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
%_datadir/%name/%{name}_gui.py

%changelog
