%define _unpackaged_files_terminate_build 1

%def_enable doc
%def_enable introspection
%def_enable systemd

# These come from meson.build.
%define apiversion 0.5
%define soversion 0

# This is used as the pkgconfig ID and as the library name
# to pass after `cc -l`.
%define libname %name-%apiversion

Name: wireplumber
Version: 0.5.11.1.git1bde4f2c
Release: alt1

Summary: a modular session/policy manager for PipeWire

License: MIT
Group: Sound
URL: https://pipewire.pages.freedesktop.org/wireplumber/

BuildRequires(pre): meson >= 0.59
BuildRequires: pkgconfig(gobject-2.0) >= 2.68
BuildRequires: pkgconfig(gmodule-2.0) >= 2.68
BuildRequires: pkgconfig(gio-2.0) >= 2.68
BuildRequires: pkgconfig(gio-unix-2.0) >= 2.68
BuildRequires: pkgconfig(libpipewire-0.3) >= 1.0.2
BuildRequires: liblua5.3-devel
%if_enabled introspection
BuildRequires(pre): gobject-introspection-devel
%endif
%if_enabled doc
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-breathe
BuildRequires: python3(sphinx_rtd_theme)
BuildRequires: python3-module-setuptools
BuildRequires: python3(lxml)
BuildRequires: doxygen >= 1.8.0
BuildRequires: graphviz
%endif
%if_enabled systemd
# Like so many other programs, WirePlumber implements logind integration via
# libsystemd for no reason. :(
BuildRequires: pkgconfig(systemd)
%endif

AutoReq: nolua

Source: %name-%version.tar
Patch0001: 0001-scripts-device-Migrate-stored-route-props-over-from-.patch

%package doc
Summary: docs for the client library for WirePlumber
Group: Documentation

%package -n lib%libname
Summary: the client library for WirePlumber
Group: System/Libraries

%package -n lib%libname-devel
Summary: development files of the client library for WirePlumber
Group: Development/C

%if_enabled introspection
%package -n lib%libname-gir
Summary: GObject introspection data for lib%libname
Group: System/Libraries
Requires: lib%libname = %EVR

%package -n lib%libname-gir-devel
Summary: GObject introspection development data for lib%libname
Group: Development/Other
BuildArch: noarch
Requires: lib%libname-gir = %EVR
Requires: lib%libname-devel = %EVR

%endif

%description
WirePlumber is a modular session / policy manager for PipeWire and a
GObject-based high-level library that wraps PipeWire's API, providing
convenience for writing the daemon's modules as well as external tools
for managing PipeWire.

%description doc
WirePlumber is a modular session / policy manager for PipeWire and a
GObject-based high-level library that wraps PipeWire's API, providing
convenience for writing the daemon's modules as well as external tools
for managing PipeWire.

This package contains documentation for WirePlumber.

%description -n lib%libname
WirePlumber is a modular session / policy manager for PipeWire and a
GObject-based high-level library that wraps PipeWire's API, providing
convenience for writing the daemon's modules as well as external tools
for managing PipeWire.

This package contains the client library.

%description -n lib%libname-devel
WirePlumber is a modular session / policy manager for PipeWire and a
GObject-based high-level library that wraps PipeWire's API, providing
convenience for writing the daemon's modules as well as external tools
for managing PipeWire.

This package contains the development files for the client library.

%if_enabled introspection
%description -n lib%libname-gir
WirePlumber is a modular session / policy manager for PipeWire and a
GObject-based high-level library that wraps PipeWire's API, providing
convenience for writing the daemon's modules as well as external tools
for managing PipeWire.

This package contains GObject introspection data for lib%libname.

%description -n lib%libname-gir-devel
WirePlumber is a modular session / policy manager for PipeWire and a
GObject-based high-level library that wraps PipeWire's API, providing
convenience for writing the daemon's modules as well as external tools
for managing PipeWire.

This package contains GObject introspection development data for lib%libname.

%endif

%prep
%setup
%patch0001 -p1
mkdir -p "$HOME/bin"
printf '%%s\n' '#!/bin/sh -eu' 'exec sphinx-build-3 "$@"' > "$HOME/bin/sphinx-build"
chmod +x "$HOME/bin/sphinx-build"

%build
%meson \
    -Dsystem-lua=true \
%if_enabled doc
    -Ddoc=enabled \
%endif
%if_enabled systemd
    -Dsystemd=enabled \
%endif
%if_enabled introspection
    -Dintrospection=enabled \
%endif
    #

%meson_build

%install
%meson_install

# %%doc does not work for multiple subpackages as of 2021 Oct 18.
# We implement its functionality by hand as closely as possible.
%define docdir() %_defaultdocdir/%1-%version
mkdir -p %buildroot%{docdir %name}/
cp -v NEWS.rst README.rst %buildroot%{docdir %name}/
mkdir -p %buildroot%{docdir %name-doc}/
mv -v %buildroot%_datadir/doc/%name %buildroot%{docdir %name-doc}

%find_lang %name

%files -f %name.lang
%define docdir() %_defaultdocdir/%1-%version
%{docdir %name}
%_bindir/wireplumber
%_bindir/wpctl
%_bindir/wpexec
%_datadir/wireplumber
%_datadir/zsh/site-functions/_wpctl
%if_enabled systemd
%_user_unitdir/wireplumber.service
%_user_unitdir/wireplumber@.service
%endif

%files doc
%define docdir() %_defaultdocdir/%1-%version
# Quoting docs/meson.build.
%{docdir %name-doc}

%files -n lib%libname
%_libdir/lib%libname.so.%soversion.*
%_libdir/lib%libname.so.%soversion
# plugins
%_libdir/%libname

%files -n lib%libname-devel
%_pkgconfigdir/%libname.pc
%_libdir/lib%libname.so
%_includedir/%libname

%if_enabled introspection
%files -n lib%libname-gir
%_typelibdir/Wp-%apiversion.typelib

%files -n lib%libname-gir-devel
%_girdir/Wp-%apiversion.gir
%endif

%changelog
