Name: x11vnc
Version: 0.9.16
Release: alt4.1

%def_with avahi

Summary: VNC server for real X displays
License: GPL
Group: Networking/Remote access
Url: https://github.com/LibVNC/x11vnc

Source: %version.tar.gz

Patch1: x11vnc-upstream-fno-common.patch
Patch2: x11vnc-upstream-CVE-2020-29074.patch

# Automatically added by buildreq on Wed Apr 27 2016
# optimized out: fontconfig libX11-devel libXext-devel libXfixes-devel libXi-devel libXrender-devel libcom_err-devel libgpg-error libkrb5-devel libp11-kit libwayland-client libwayland-server perl pkg-config python-base python-modules xorg-compositeproto-devel xorg-damageproto-devel xorg-fixesproto-devel xorg-inputproto-devel xorg-kbproto-devel xorg-randrproto-devel xorg-recordproto-devel xorg-renderproto-devel xorg-xextproto-devel xorg-xproto-devel zlib-devel
BuildRequires: imake libICE-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXinerama-devel libXrandr-devel libXtst-devel libavahi-devel libcairo-devel libssl-devel libvncserver-devel xorg-cf-files

%if_with avahi
BuildRequires: libavahi-devel
%endif

%description
x11vnc allows one to remotely view and interact with real X displays
(i.e. a display corresponding to a physical monitor, keyboard, and mouse)
with any VNC viewer. In this way it plays the role for Unix/X11 that
WinVNC plays for Windows.

%package gui
License: GPL
Group: Networking/Remote access
BuildArch: noarch
Summary: GUI to run x11vnc

Requires: %name = %EVR
# /usr/bin/wish
Requires: tk

%description gui
%summary.

%package scripts
License: GPL
Group: Networking/Remote access
BuildArch: noarch
Summary: Various x11vnc wrappers

%description scripts
%summary.

In this directory you'll find a hodgepodge of wrapper scripts and
utility programs that have found some use with x11vnc.

Some are on the rough side and will need some customization for your use.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%autoreconf
%configure --without-uinput
%make_build

%install
%makeinstall
install tkx11vnc %buildroot%_bindir/

%files
%_bindir/%name
%_man1dir/%name.*
%doc README NEWS

%files gui
%_desktopdir/%name.desktop

%files scripts
%_bindir/tkx11vnc
%doc misc/*
%exclude  %_bindir/Xdummy

%changelog
