Name: x264
Version: 164
Release: alt1.1

Summary: CLI H.264 encoder
License: GPLv2
Group: Video

Url: http://www.videolan.org/x264.html
Source: %name-%version-%release.tar

BuildRequires: nasm
BuildRequires: libSDL-devel libx264-devel
BuildRequires: libavformat-devel libavcodec-devel libavdevice-devel libavutil-devel libswscale-devel

%package utils
Group: Video
Summary: H.264 encoder utils

%define desc \
libx264 is a free library for encoding H264/AVC video streams.\
The code is written from scratch.\
\
Encoder features: \
- CAVLC/CABAC \
- Multi-references \
- Intra: all macroblock types (16x16, 8x8, and 4x4 with all predictions) \
- Inter P: all partitions (from 16x16 down to 4x4) \
- Inter B: partitions from 16x16 down to 8x8 (including skip/direct) \
- Ratecontrol: constant quantizer, single or multipass ABR, optional VBV \
- Scene cut detection \
- Adaptive B-frame placement \
- B-frames as references / arbitrary frame order \
- 8x8 and 4x4 adaptive spatial transform \
- Lossless mode \
- Custom quantization matrices \
- Parallel encoding of multiple slices.\


%description %desc
This package includes CLI based H.264 encoder.

%description utils %desc
This package includes %name encoder utils.

%prep
%setup

%build
%ifarch %ix86
export ASFLAGS=' '
%endif
%ifarch %e2k
%add_optflags -mno-sse
%endif
%configure --system-libx264
%make_build %name

%install
%makeinstall_std
install -pm0755 tools/countquant_x264.pl %buildroot%_bindir

%files
%_bindir/%name

%files utils
%doc tools/q_matrix_jvt.cfg
%_bindir/countquant_x264.pl

%changelog
