%def_disable snapshot
%define _libexecdir %_prefix/libexec

%def_disable docs
%def_enable man
# kernel.unprivileged_userns_clone required
%def_disable check
%def_enable installed_tests

Name: xdg-desktop-portal
Version: 1.20.3
Release: alt1

Summary: Portal frontend service to Flatpak
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Url: https://github.com/flatpak/%name

Vcs: https://github.com/flatpak/xdg-desktop-portal.git

%if_disabled snapshot
Source: %url/releases/download/%version/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%{?_enable_installed_tests:%add_python3_path %_libexecdir/installed-tests/%name}

%define meson_ver 0.56.2
%define glib_ver 2.72
%define geoclue_ver 2.5.2
%define portal_ver 0.2.90
%define fuse3_ver 3.10.0

Requires: dbus
#Requires: flatpak >= 1.6.0
Requires: /usr/bin/fusermount
Requires: pipewire
Requires: geoclue2 >= %geoclue_ver

BuildRequires(pre): rpm-macros-meson rpm-build-systemd %{?_enable_installed_tests:rpm-build-python3}
BuildRequires: meson >= %meson_ver
BuildRequires: pkgconfig(flatpak) flatpak
BuildRequires: pkgconfig(fuse3) >= %fuse3_ver
BuildRequires: pkgconfig(gio-unix-2.0) >= %glib_ver
BuildRequires: pkgconfig(gdk-pixbuf-2.0)
BuildRequires: pkgconfig(libpipewire-0.3)
BuildRequires: pkgconfig(libgeoclue-2.0) >= %geoclue_ver
BuildRequires: pkgconfig(systemd)
BuildRequires: pkgconfig(json-glib-1.0)
# since 1.5
BuildRequires: pkgconfig(libportal) >= %portal_ver
# since 1.9.1
BuildRequires: pkgconfig(gstreamer-pbutils-1.0) pkgconfig(umockdev-1.0)
BuildRequires: pkgconfig(gudev-1.0)
%{?_enable_docs:BuildRequires: python3(sphinx) xmlto docbook-dtds docbook-style-xsl}
%{?_enable_man:BuildRequires: /usr/bin/rst2man}
%{?_enable_installed_tests:BuildRequires: /proc fuse3 pipewire
BuildRequires: python3(pytest) python3(gi)
BuildRequires: python3(dbus) python3(dbusmock)
BuildRequires: typelib(UMockdev) = 1.0
BuildRequires: /usr/bin/gst-inspect-1.0
# wavparse
BuildRequires: gst-plugins-good1.0}
# with our xdist tests failed in hasher with typical error
# Error creating thread: Resource temporarily unavailable
# python3(xdist)

%description
xdg-desktop-portal works by exposing a series of D-Bus interfaces known as
portals under a well-known name (org.freedesktop.portal.Desktop) and object
path (/org/freedesktop/portal/desktop). The portal interfaces include APIs for
file access, opening URIs, printing and others.

%package devel
Summary: Development files for %name
Group: Development/C
BuildArch: noarch
Requires: %name = %EVR

%description devel
The pkg-config file for %name.

%package tests
Summary: Tests for the %name
Group: Development/Other
Requires: %name = %EVR
Requires: flatpak >= 1.6.0
Requires: gst-plugins-good1.0

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %name.

%prep
%setup
sed -i 's/pytest-3/py.test-3/' meson.build

%build
%meson \
    %{subst_enable_meson_feature docs documentation} \
    %{subst_enable_meson_feature man man-pages} \
    %{subst_enable_meson_bool installed_tests installed-tests}
%nil
%meson_build

%install
%meson_install
# directory for portals such as xdg-desktop-portal-gtk
install -d -m755 %buildroot/%_datadir/%name/portals
%find_lang %name

%check
%__meson_test -t 6

%files -f %name.lang
%_libexecdir/%name
%_libexecdir/xdg-document-portal
%_libexecdir/xdg-permission-store
%_libexecdir/%name-validate-icon
%_libexecdir/%name-rewrite-launchers
%_libexecdir/%name-validate-sound
%_datadir/dbus-1/interfaces/org.freedesktop.portal.*.xml
%_datadir/dbus-1/interfaces/org.freedesktop.impl.portal.*.xml
%_datadir/dbus-1/interfaces/org.freedesktop.host.portal.Registry.xml
%_datadir/dbus-1/services/org.freedesktop.portal.Desktop.service
%_datadir/dbus-1/services/org.freedesktop.portal.Documents.service
%_datadir/dbus-1/services/org.freedesktop.impl.portal.PermissionStore.service
%_datadir/%name/
%_userunitdir/%name.service
%_userunitdir/xdg-document-portal.service
%_userunitdir/xdg-permission-store.service
%_userunitdir/%name-rewrite-launchers.service
%{?_enable_man:%_man5dir/portals.conf.5*}
%doc README.md NEWS*
%{?_enable_docs:%doc %_docdir/%name}

%files devel
%_datadir/pkgconfig/%name.pc

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%name/
%_datadir/installed-tests/%name/
%endif

%changelog
