%def_disable snapshot
%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)
%define _libexecdir %_prefix/libexec

Name: xdg-desktop-portal-gtk
Version: 1.15.3
Release: alt1

Summary: Backend implementation for xdg-desktop-portal using GTK+
Group: Graphical desktop/GNOME
License: LGPL-2.0-or-later
Url: https://github.com/flatpak/%name

Vcs: https://github.com/flatpak/xdg-desktop-portal-gtk.git

%if_disabled snapshot
Source: %url/releases/download/%version/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define xdg_desktop_portal_ver 1.14
%define gtk_ver 3.22

Requires: xdg-desktop-portal >= %xdg_desktop_portal_ver

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: libgtk+3-devel >= %gtk_ver gsettings-desktop-schemas-devel
BuildRequires: pkgconfig(xdg-desktop-portal) >= %xdg_desktop_portal_ver
BuildRequires: pkgconfig(gnome-desktop-3.0)
BuildRequires: libdbus-devel pkgconfig(systemd)

%description
A backend implementation for xdg-desktop-portal that is using GTK+ and various
pieces of GNOME infrastructure, such as the org.gnome.Shell.Screenshot or
org.gnome.SessionManager D-Bus interfaces.

%prep
%setup

%build
%meson
%meson_build

%check
%__meson_test

%install
%meson_install
%find_lang %name

%files -f %name.lang
%_libexecdir/%name
%_desktopdir/%name.desktop
%_datadir/dbus-1/services/org.freedesktop.impl.portal.desktop.gtk.service
%_datadir/xdg-desktop-portal/portals/gtk.portal
%_userunitdir/%name.service
%doc NEWS README*


%changelog
