Name:           xfce4-notifyd
Version:        0.9.7
Release:        alt1
Summary:        Simple notification daemon for Xfce
Summary(ru_RU.UTF-8): Менеджер уведомлений для Xfce

Group:          Graphical desktop/XFce
License:        GPL-2.0-only
URL:            https://docs.xfce.org/apps/notifyd/start
Vcs:            https://gitlab.xfce.org/apps/xfce4-notifyd.git
Source0:        %name-%version.tar
Patch:          %name-%version-%release.patch
Packager: Xfce Team <xfce@packages.altlinux.org>

%if_xfce4_wayland_support
%def_enable wayland
%else
%def_disable wayland
%endif

BuildRequires(pre): rpm-build-xfce4 >= 0.3.0 xfce4-dev-tools >= 4.18.1
BuildRequires: libxfce4ui-gtk3-devel libxfconf-devel libxfce4util-devel
BuildRequires: libxfce4panel-gtk3-devel
BuildRequires: libgio-devel libX11-devel
BuildRequires: libnotify-devel
BuildRequires: libcanberra-gtk3-devel
BuildRequires: libsqlite3-devel
BuildRequires: libdbus-devel
BuildRequires: rpm-build-xdg
%{?_enable_wayland:BuildRequires: libgtk-layer-shell-devel}

Requires:       xfce4-common
Requires:       dbus icon-theme-hicolor
Requires:       notify-send
Obsoletes:      notification-daemon-xfce <= 0.3.7

Provides: desktop-notification-daemon

%define _unpackaged_files_terminate_build 1

%description
Xfce4-notifyd is a simple, visually-appealing notification daemon for
Xfce that implements the freedesktop.org desktop notifications
specification.
Features:
* Themable using the GTK+ theming mechanism
* Visually appealing: rounded corners, shaped windows
* Supports transparency and fade effects

%description -l ru_RU.UTF-8
Простой менеджер уведомлений для Xfce работающий по спецификациям
freedesktop.org.
Возможности:
* Наличие встроенного механизма тем
* Поддержка скруглений для углов окон
* Поддержка прозрачности и эффекта скрытия

%package -n xfce4-notification-plugin
Summary: Notification plugin for the Xfce panel
Group: Graphical desktop/XFce
Requires: %name

%description -n xfce4-notification-plugin
Notification plugin for the Xfce panel.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--enable-maintainer-mode \
	--enable-dbus-start-daemon \
	--enable-x11 \
	%{subst_enable wayland} \
	--enable-sound \
	--enable-systemd \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README.md
%_xdgconfigdir/autostart/*.desktop
%_bindir/xfce4-notifyd-config
%_libdir/xfce4/notifyd/
%_desktopdir/*.desktop
%_datadir/dbus-1/services/*
%_usr/lib/systemd/user/xfce4-notifyd.service
%_iconsdir/hicolor/*/*/*.*
%_datadir/themes/Default/xfce-notify-4.0/
%_datadir/themes/Bright/
%_datadir/themes/Retro/
%_datadir/themes/Smoke/
%_datadir/themes/XP-Balloon/
%_datadir/themes/ZOMG-PONIES!/
%_man1dir/*

%files -n xfce4-notification-plugin
%_libdir/xfce4/panel/plugins/*
%_datadir/xfce4/panel/plugins/*.desktop

%exclude %_libdir/xfce4/panel/plugins/*.la

%changelog
