%def_enable libgtop

Name: xfce4-systemload-plugin
Version: 1.4.0
Release: alt1

Summary: System load plugin for the Xfce panel
Summary(ru_RU.UTF-8): Отображение использования ресурсов системы на панели Xfce
License: BSD-2-Clause
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/panel-plugins/xfce4-systemload-plugin
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/panel-plugins/xfce4-systemload-plugin.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfce4util-devel >= 4.17.2 libxfce4ui-gtk3-devel >= 4.16.0 libxfce4panel-gtk3-devel >= 4.16.0 libxfconf-devel >= 4.16.0
BuildRequires: gcc-c++
BuildRequires: libX11-devel libgtk+3-devel libstartup-notification libupower-devel
%{?_enable_libgtop:BuildRequires: libgtop-devel}

Requires: xfce4-panel >= 4.17

%define _unpackaged_files_terminate_build 1

%description
A system load plugin for the Xfce4 desktop environment. It displays the
current CPU load, memory in use, network utilization, swap space, and
system uptime in the Xfce4 panel

%description -l ru_RU.UTF-8
%name -- это модуль, отображающий уровень использования системных ресурсов
на панели графической среды Xfce.

%prep
%setup
%patch -p1

%build
%meson \
	-Dupower-glib=enabled \
	%{subst_enable_meson_feature libgtop libgtop}

%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc README.md COPYING AUTHORS NEWS
%_libdir/xfce4/panel/plugins/*.so
%_datadir/xfce4/panel/plugins/*.desktop
%_iconsdir/hicolor/*/apps/*.*

%changelog
