Name: xfsdump
Version: 3.1.12
Release: alt1

Summary: Administrative utilities for the XFS filesystem
License: GPLv2
Group: System/Kernel and hardware

Url: http://oss.sgi.com/projects/xfs/

# https://git.kernel.org/pub/scm/fs/xfs/xfsdump-dev.git/
Source: %name-%version.tar

# Automatically added by buildreq on Wed Apr 01 2009
BuildRequires: libattr-devel libncurses-devel libuuid-devel libxfs-devel

# we need fsx_projid from struct fsxattr
BuildRequires: libxfs-devel >= 2.8.16

%description
The xfsdump package contains xfsdump, xfsrestore and a number of
other utilities for administering XFS filesystems.

xfsdump examines files in a filesystem, determines which need to be
backed up, and copies those files to a specified disk, tape or other
storage medium.  It uses XFS-specific directives for optimizing the
dump of an XFS filesystem, and also knows how to backup XFS extended
attributes.  Backups created with xfsdump are "endian safe" and can
thus be transfered between Linux machines of different architectures
and also between IRIX machines.

xfsrestore performs the inverse function of xfsdump; it can restore a
full backup of a filesystem.  Subsequent incremental backups can then
be layered on top of the full backup.  Single files and directory
subtrees may be restored from full or partial backups.

%prep
%setup

%build
# http://bugs.debian.org/837581
%add_optflags -D_FILE_OFFSET_BITS=64
%make configure
%configure
%make_build

%install
make DIST_ROOT=%buildroot install install-dev
rm -rf %buildroot%_datadir/doc/%name
%find_lang %name

%files -f %name.lang
%doc doc/CHANGES.gz doc/README.xfsdump doc/*.gif doc/xfsdump.html
/sbin/*
%_sbindir/*
%_mandir/*/*

%changelog
