# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: xfstests
Version: 2023.05.28
Release: alt1
Summary: XFS QA testsuite
License: GPL-2.0-or-later
Group: Development/Tools
Url: https://git.kernel.org/pub/scm/fs/xfs/xfstests-dev.git
# Additional https://github.com/tytso/xfstests-bld

# Autoreqs work for too long.
AutoReq: nopython nopython3 noshell noshebang noperl
Requires: acl
Requires: attr
Requires: bash
Requires: bc
Requires: btrfs-progs
Requires: coreutils
Requires: dmsetup
Requires: e2fsprogs
Requires: keyutils
Requires: libcap-utils
Requires: lvm2
Requires: mount
Requires: perl
Requires: quota
Requires: util-linux
Requires: xfsdump
Requires: xfsprogs
Requires: xz

Source: %name-%version.tar
BuildRequires: libacl-devel
BuildRequires: libaio-devel
BuildRequires: libattr-devel
BuildRequires: libbtrfs-devel >= 5.14.2-alt3
BuildRequires: libcap-devel
BuildRequires: libgdbm-devel
BuildRequires: libssl-devel
BuildRequires: liburing-devel
BuildRequires: libuuid-devel
BuildRequires: libxfs-devel
BuildRequires: rpm-build-python
BuildRequires: rpm-build-python3

%description
The XFS regression test suite. Also includes some support for
acl, attr, udf, and nfs testing. Contains around 1600+ specific
tests for userspace & kernelspace.

%prep
%setup

%build
%autoreconf
%add_optflags -Wno-unused-result
%configure \
	--disable-static \
	--exec-prefix=%_libexecdir

%make_build V=1

%install
%makeinstall_std V=1

%global _customdocdir %_defaultdocdir/%name

%files
%doc README* MAINTAINERS LICENSES/* doc/*
%_libexecdir/xfstests

%changelog
