Name: xvkbd
Version: 4.1
Release: alt1

Summary: Virtual (on-screen) keyboard for X
License: GPLv2+
Group: System/X11

Url: http://t-sato.in.coocan.jp/xvkbd/
Source: %url/%name-%version.tar.gz
Source100: xvkbd.watch
# one-space patch sent upstream
Patch: xvkbd-4.1-make.patch
Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires(pre): rpm-build-licenses
BuildRequires: ImageMagick-tools imake libXaw-devel libXaw3d-devel
BuildRequires: libXext-devel libXp-devel libXpm-devel libXtst-devel
BuildRequires: xorg-cf-files xorg-sdk

Summary(ru_RU.UTF-8): Виртуальная (экранная) клавиатура для X
Summary(uk_UA.UTF-8): Віртуальна (екранна) клавіатура для X

%description
%name is a virtual (graphical) keyboard program for X Window System
which provides facility to enter characters onto other clients
(softwares) by clicking on a keyboard displayed on the screen. This may
be used for systems without a hardware keyboard such as kiosk terminals
or handheld devices.
This program also has facility to send characters specified as the
command line option to another client, which can help when one wants to
fully utilize some modern mice with multiple buttons.

%description -l ru_RU.UTF-8
%name - виртуальная (графическая) программная клавиатура для X Window,
которая предоставляет возможность вводить символы в другие клиенты
(программы) щелчком по клавишам, отображаемым на экране.  Это может
быть полезно для систем без аппаратной клавиатуры, таким как
терминалы-киоски или носимые устройства.
Эта программа также имеет возможность отправки символов, указанных
в опции командной строки, другому клиенту, что может быть полезно,
когда хочется полностью задействовать дополнительные кнопки
некоторых нынешних мышей.

%prep
%setup
%patch -p1

%build
xmkmf
# make CFLAGS=... broke as of 4.1 (used to work for 3.9)
export CFLAGS+="%optflags"
%make_build
for s in 48 36 32 24 22 16; do
	convert %{name}_icon.xbm \
		-resize ${s}x$s \
		-monochrome \
		-depth 8 \
		%name-$s.png
done

%install
%makeinstall_std install.man
for s in 48 36 32 24 22 16; do
	install -pDm644 %name-$s.png \
		%buildroot%_iconsdir/hicolor/${s}x$s/apps/%name.png
done
rm -rf %buildroot/%_datadir/X11

install -d -m 0755 %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%name.desktop <<__MENU__
[Desktop Entry]
Version=1.0
Name=%name
Exec=%name
Icon=%name
Categories=Utility;Accessibility;
Type=Application
X-MultipleArgs=true
Terminal=false
StartupNotify=true
Comment=On-screen keyboard for X
Comment[ru]=Виртуальная (экранная) клавиатура для X
__MENU__

%files
%_bindir/*
%_sysconfdir/X11/app-defaults/*
%_man1dir/*
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*

%changelog
