%def_enable snapshot
%define _unpackaged_files_terminate_build 1
%define xdg_name org.gnome.Yelp

%define ver_major 42
%define beta %nil
%def_disable debug
%def_enable lzma
%def_disable gtk_doc
%define webkit_api_ver 4.1
%def_without webkit2gtk_40
%{?_with_webkit2gtk_40:%define webkit_api_ver 4.0}
%def_enable check

Name: yelp
Version: %ver_major.3
Release: alt1%beta

Summary: Lightweight help browser for GNOME
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: http://yelp.io

Vcs: https://gitlab.gnome.org/GNOME/yelp.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define gio_ver 2.38
%define gtk_ver 3.14
%define xslt_ver 1.1.4
%define webkit_ver 2.19.2
%define yelpxsl_ver %ver_major.4
%define handy_ver 1.5.0

Requires: lib%name = %version-%release
Requires: yelp-xsl >= %yelpxsl_ver
Requires: dconf gnome-icon-theme gnome-icon-theme-symbolic
%ifarch %e2k
Obsoletes: yelp.sh
%endif

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson itstool gtk-doc
BuildRequires: libgio-devel >= %gio_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: libxslt-devel >= %xslt_ver
BuildRequires: pkgconfig(webkit2gtk-%webkit_api_ver) >= %webkit_ver
BuildRequires: yelp-xsl >= %yelpxsl_ver
BuildRequires: zlib-devel bzlib-devel libsqlite3-devel
%{?_enable_lzma:BuildRequires: liblzma-devel}

%description
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation. The name Yelp was suggested by Daniel Lundin.
Yelp is pronounced the same as the swedish word for 'help'.

%package -n lib%name
Summary: Shared library for Yelp
Group: System/Libraries

%description -n lib%name
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation.

This package provides shared library required for dconf to work

%package -n lib%name-devel
Summary: Development files for Yelp library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation.

This is a Yelp development package. Contains files needed for doing
development using Yelp.

%package -n lib%name-devel-doc
Summary: Development documentation for Yelp library
Group: Development/C
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation.

This package contains documentation needed for doing development using
Yelp.


%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_feature lzma lzma} \
    %{?_with_webkit2gtk_40:-Dwebkit2gtk-4-0}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/gnome-help
%_bindir/%name
%_desktopdir/%name.desktop
%_datadir/%name/
%_datadir/yelp-xsl/xslt/common/domains/yelp.xml
%config %_datadir/glib-2.0/schemas/org.gnome.yelp.gschema.xml
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_datadir/metainfo/%name.appdata.xml
%doc AUTHORS README* NEWS TODO

%files -n lib%name
%_libdir/*.so.*
%_libdir/%name/

%files -n lib%name-devel
%_includedir/lib%name/
%_libdir/*.so

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/lib%name/
%endif

%changelog
