%define _unpackaged_files_terminate_build 1

%if %{expand:%%{!?_without_check:%%{!?_disable_check:1}}0}
%define tests enabled
%else
%define tests disabled
%endif

Name: zathura
Version: 0.5.11
Release: alt1

Summary: A lightweight document viewer
License: Zlib
Group: Office
Url: https://pwmt.org/projects/%name/
Vcs: https://github.com/pwmt/zathura.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): meson
BuildRequires: libgirara-devel >= 0.4.5-alt1
BuildRequires: libgtk+3-devel libsqlite3-devel python3-module-docutils libmagic-devel zlib-devel
BuildRequires: libsynctex-devel
BuildRequires: libseccomp-devel
BuildRequires: libjson-glib-devel
# For man pages
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
# To create icons
BuildRequires: librsvg-utils
#For tests
%{?!_without_check:%{?!_disable_check:BuildRequires: xvfb-run libappstream-glib desktop-file-utils}}

Conflicts: zatura-pdf-poppler < 0.3.3-alt1
Conflicts: zatura-djvu < 0.2.10-alt1
Conflicts: zatura-ps < 0.2.8-alt1
Conflicts: zatura-cb < 0.1.11-alt1

%description
zathura is a highly customizable and functional document viewer based on
the girara user interface library and several document libraries.

This package contains ALT-specific changes so it is NOT original software
from https://pwmt.org.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Requires: libgtk+3-devel libgirara-devel

%description devel
This package contains libraries and header files for
developing applications that use %name.

%prep
%setup
%patch -p1

%build
%meson \
	-Dtests=%tests

%meson_build -v

%install
%meson_install
#  Create directory for plugins
mkdir -p %buildroot%_libdir/zathura
%find_lang %name

%check
%meson_test

%files -f %name.lang
%doc LICENSE AUTHORS README.md
%_bindir/%{name}*
%dir %_libdir/%name
%_desktopdir/*
%_iconsdir/hicolor/*/*/*
%_datadir/metainfo/*.xml
%_man1dir/*
%_man5dir/*
%_datadir/bash-completion/completions/*
%_datadir/zsh/site-functions/*
%_datadir/fish/vendor_completions.d/*

%files devel
%_includedir/*
%_libdir/pkgconfig/*.pc
%_datadir/dbus-1/interfaces/org.pwmt.*

%changelog
