%def_enable snapshot

%define real_name zim
%define rdn_name org.zim_wiki.Zim

Name: zim-wiki
Version: 0.76.1
Release: alt1

Summary: A desktop wiki and outliner
Group: Editors
License: GPL-2.0
Url: https://www.zim-wiki.org/

%if_disabled snapshot
Source: https://zim-wiki.org/downloads/%real_name-%version.tar.gz
%else
Source: %name-%version.tar
Patch: %name-%version-%release.patch
%endif

Patch1: AyatanaAppindicator.patch

BuildArch: noarch
Requires: typelib(Gtk) = 3.0
Requires: typelib(GtkSource) = 4
Requires: python3-module-pygobject3
# see README.md and PKG-INFO
Requires: python3-module-pyxdg xdg-utils
# Mac-specific
%add_typelib_req_skiplist typelib(GtkosxApplication)
# typelib(AppIndicator3)

Conflicts: zim

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3(wheel) python3(setuptools)
BuildRequires: python3-module-pygobject3 python3-modules-sqlite3
BuildRequires: typelib(Gtk) = 3.0

%description
Zim is a graphical text editor used to maintain a collection of wiki
pages. Each page can contain links to other pages, simple formatting and
images. Pages are stored in a folder structure, like in an outliner, and
can have attachments. Creating a new page is as easy as linking to a
nonexistent page. All data is stored in plain text files with wiki
formatting. Various plugins provide additional functionality, like a task
list manager, an equation editor, a tray icon, and support for version
control.

%prep
%setup
%patch -p1
%patch1 -p1

%build
%pyproject_build

%install
%pyproject_install
%find_lang %real_name

%files -f %real_name.lang
%_bindir/%real_name
%_datadir/%real_name
%_desktopdir/%rdn_name.desktop
%python3_sitelibdir/%real_name
%python3_sitelibdir/%{pyproject_distinfo %real_name}
%_man1dir/%{real_name}*
%_datadir/mime/*
%_datadir/metainfo/*
%_iconsdir/*/*/*/*.svg
%exclude %_iconsdir/ubuntu*

%doc README.md CHANGELOG.md

%changelog
