#Variable for pyproject_distinfo
%define nameP zxing_cpp

Name:     zxing-cpp
Version:  2.3.0
Release:  alt4

Summary:  C++ port of ZXing
License:  Apache-2.0
Group:    System/Libraries
Url:      https://github.com/zxing-cpp/zxing-cpp

Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source1: libzint.tar

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: libfmt-devel
BuildRequires: libstb-devel
BuildRequires: python3-module-setuptools 
BuildRequires: python3-module-wheel
BuildRequires: libopencv-devel
BuildRequires: pybind11-devel

%description
ZXing-C++ ("zebra crossing") is an open-source, multi-format 1D/2D barcode
image processing library implemented in C++. It was originally ported from the
Java ZXing Library but has been developed further and now includes many
improvements in terms of quality and performance. It can both read and write
barcodes in a number of formats.

%package -n lib%name
Summary: C++ port of ZXing
Group: System/Libraries

%description -n lib%name
ZXing-C++ ("zebra crossing") is an open-source, multi-format 1D/2D barcode
image processing library implemented in C++. It was originally ported from the
Java ZXing Library but has been developed further and now includes many
improvements in terms of quality and performance. It can both read and write
barcodes in a number of formats.

%package -n lib%name-devel
Summary: C++ port of ZXing (development files)
Group: Development/C++

%description -n lib%name-devel
Development files for lib%name.

%package -n python3-module-%name
Summary: C++ port of ZXing (python3 module)
Group: Development/Python3

%description -n python3-module-%name
Python3 module for %name.

%prep
%setup
%ifarch %e2k
# error #1587: cannot deduce "auto" type
sed -i '/{PointI{/s/, {/, PointI{/g;/{PointF{/s/, {/, PointF{/g' \
	core/src/ConcentricFinder.{h,cpp} \
	core/src/{aztec/AZ,qrcode/QR,datamatrix/DM}Detector.cpp
sed -E -i '/std::pair\(tl/s/\{(..), \{/std::pair{\1, PointI{/g' core/src/qrcode/QRDetector.cpp
sed -i '1i #define preferred_separator preferred_separator_zxing' test/blackbox/ZXFilesystem.h
%endif

# Removing broken links to files and adding a working submodule
rm -r core/src/libzint
tar -xf %SOURCE1 -C core/src/

%build
%cmake -GNinja
%ninja_build -C "%_cmake__builddir"

pushd wrappers/python
%pyproject_build
popd

%install
%ninja_install -C "%_cmake__builddir"

pushd wrappers/python
%pyproject_install
popd

%files
%_bindir/*

%files -n lib%name
%doc README.md example
%_libdir/libZXing.so.*

%files -n lib%name-devel
%_libdir/libZXing.so
%_includedir/ZXing/
%_libdir/cmake/ZXing/
%_libdir/pkgconfig/zxing.pc

%files -n python3-module-%name
%python3_sitelibdir/zxing*.so
%python3_sitelibdir/%{pyproject_distinfo %nameP}/

%changelog
