Summary: 389 Directory Server
Name:    389-ds
Version: 1.2.11.31
Release: alt0.M70P.1
License: GPLv2
Url:     http://port389.org
Group:   System/Servers
Packager: Andrey Cherepanov <cas@altlinux.org>
Source:  %name-%version-%release.tar
Source1: install.inf
Source3: setupssl2.sh
Patch0:  %name-%version-%release.patch

BuildRequires: 389-adminutil-devel gcc-c++ libdb4-devel libicu-devel 
BuildRequires: libldap-devel libnet-snmp-devel libnl-devel libpam-devel 
BuildRequires: libpcre-devel libsasl2-devel libsensors3-devel libsvrcore-devel
BuildRequires: perl-Mozilla-LDAP perl-libnet perl-bignum
BuildRequires: perl-DBM
BuildRequires: perl-NetAddr-IP

Provides:  fedora-ds = %version-%release
Obsoletes: fedora-ds < %version-%release

# AutoReq: yes, noperl
%add_perl_lib_path %_libdir/fedora-ds/perl
%add_findprov_skiplist %_datadir/fedora-ds/script-templates/*
%add_findreq_skiplist %_datadir/fedora-ds/script-templates/*

%description
389 Directory Server is an LDAPv3 compliant server. Use setup-ds.pl
to setup instances.

%package devel
Summary: Development libraries for 389 Directory Server
Group: Development/C
Requires: %name = %version-%release

%description devel
Development Libraries and heades for 389 Directory Server.

%prep
%setup -n %name-%version
%patch0 -p1
%autoreconf

cp %SOURCE1 install.inf

%build
%configure \
	   --localstatedir=/var \
	   --with-openldap \
	   --with-selinux

export XCFLAGS=$RPM_OPT_FLAGS

#USE_ADMSERV to avoid strange get_mag_var unresolved symbol
echo "#define USE_ADMSERV 1" >>config.h

%ifarch x86_64 ppc64 ia64 s390x sparc64
export USE_64=1
%endif

%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_logdir/fedora-ds
mkdir -p %buildroot%_localstatedir/fedora-ds
mkdir -p %buildroot%_lockdir/fedora-ds
mkdir -p %buildroot%_var/tmp/fedora-ds
mkdir -p %buildroot%_includedir/fedora-ds

install -p -m 644 ldap/servers/slapd/slapi-plugin.h %buildroot%_includedir/fedora-ds/
install -p -m 755 %SOURCE3 %buildroot%_datadir/fedora-ds/

# make sure perl scripts have a proper shebang
subst 's|#{{PERL-EXEC}}|#!%_bindir/perl|' %buildroot%_datadir/fedora-ds/script-templates/template-*.pl
subst 's|File::Spec->tmpdir|"/tmp"|' %buildroot%_libdir/fedora-ds/perl/DSCreate.pm

# move main libraries to common directory
mv %buildroot%_libdir/fedora-ds/*.so* %buildroot%_libdir/
find %buildroot%_libdir -name "*.la" -delete

%files
%doc README.ALT LICENSE EXCEPTION install.inf
%dir %_sysconfdir/fedora-ds
%dir %_sysconfdir/fedora-ds/schema
%config %_sysconfdir/fedora-ds/schema/*.ldif
%dir %_sysconfdir/fedora-ds/config
%config %_sysconfdir/fedora-ds/config/slapd-collations.conf
%config %_sysconfdir/fedora-ds/config/certmap.conf
%config %_sysconfdir/fedora-ds/config/ldap-agent.conf
%config %_sysconfdir/fedora-ds/config/template-initconfig
%config(noreplace) %_sysconfdir/sysconfig/fedora-ds
%_datadir/fedora-ds
%_bindir/*
%_sbindir/*
%dir	%_libdir/fedora-ds
%_libdir/*.so.*
%dir %_libdir/fedora-ds/perl
%_libdir/fedora-ds/perl/*.pm
%dir %_libdir/fedora-ds/plugins
%_libdir/fedora-ds/plugins/*.so*
%dir %_logdir/fedora-ds
%_initdir/*
%_man1dir/*.gz
%_man8dir/*.gz

%files devel
%doc LICENSE EXCEPTION
%_includedir/fedora-ds
%_libdir/*.so
%_pkgconfigdir/*.pc

%post
%post_service fedora-ds
%post_service fedora-ds-snmp

%preun
%preun_service fedora-ds
%preun_service fedora-ds-snmp

%triggerpostun -- 389-ds < 1.2.10.0-alt1
echo "Upgrading 389-ds < 1.2.10.0, manual Offline upgrade is required!
Turn 389-ds off and make 'setup-ds -u' then"

%changelog
