%def_enable shared
%def_enable static
%def_disable debug

%define Name 4tH
Name: 4th
%define lname lib%name
Version: 3.62.0
Release: alt2
Summary: Basic framework for creating application specific scripting languages
Summary(uk_UA.CP1251):         
Summary(ru_RU.CP1251):         
License: LGPLv3+
Group: Development/Other
URL: http://hansoft.come.to/
Source0: https://%name.googlecode.com/files/%name-%version-unix.tar
Source1: Makefile.ALT
Patch: %name-%version-%release.patch
%{?_enable_shared:Requires: %lname = %version-%release}

%if "%__cc" == "tcc"
BuildRequires: tcc >= 0.9.23-alt3
%endif
%if "%__cc" == "musl-gcc"
BuildRequires: musl-devel
%endif

%description
%Name is basic framework for creating application specific scripting
languages. It is a library of functions centered around a virtual
machine, which guarantees high performance, ease of use and low
overhead. But in the meanwhile %Name has acquired a reputation as an
educational tool. Its simplicity makes it perfectly suited to learn
Forth, from which it has been derived.
This package is an attempt to suit both audiences. It contains
instructions how to modify the package in order to fit your own
requirements. %Name in its current form is a calculator for simple
teletype applications.

%description -l uk_UA.CP1251
%Name -         
.   -     , 
  ,    
 . ,    , %Name    
.        
Forth' (    ).    
  . ³      
   . %Name     - 
    .

%description -l ru_RU.CP1251
%Name -        
 .   -    
,    , 
    . ,    ,
%Name    .   
     Forth' (    ).
      .   
       . %Name
    -     
.


%package examples
Group: Development/Other
Summary: Examples for the %Name
Summary(uk_UA.CP1251):   %Name
Summary(ru_RU.CP1251):   %Name
BuildArch: noarch

%description examples
%Name is basic framework for creating application specific scripting
languages. It is a library of functions centered around a virtual
machine, which guarantees high performance, ease of use and low
overhead. But in the meanwhile %Name has acquired a reputation as an
educational tool. Its simplicity makes it perfectly suited to learn
Forth, from which it has been derived.

This package contains examples for the %Name.

%description -l uk_UA.CP1251 examples
%Name -         
.   -     , 
  ,    
 . ,    , %Name    
.        
Forth' (    ).

      %Name.

%description -l ru_RU.CP1251 examples
%Name -        
 .   -    
,    , 
    . ,    ,
%Name    .   
     Forth' (    ).

      %Name.


%if_enabled shared
%package -n %lname
Group: System/Libraries
Summary: %Name shared library
Summary(uk_UA.CP1251):  %Name
Summary(ru_RU.CP1251):  %Name

%description -n %lname
%Name is basic framework for creating application specific scripting
languages. It is a library of functions centered around a virtual
machine, which guarantees high performance, ease of use and low
overhead. All its basic building blocks (compiler, interpreter,
decompiler, loader and saver) can be called with a single line of C. No
initialization necessary.

This package contains %Name shared library.

%description -n %lname -l uk_UA.CP1251
%Name -         
.   -     , 
  ,    
 .      (, ,
,   )    
  C,    .

     %Name.

%description -n %lname -l ru_RU.CP1251
%Name -        
 .   -    
,    , 
    .   
  (, , ,  
)       C,  
 .

     %Name.
%endif

%package -n %lname-devel
Group: Development/C
Summary: Files required to link software that uses %lname
Summary(uk_UA.CP1251): ,    ,   %lname
Summary(ru_RU.CP1251): ,    ,   %lname
Requires: %lname%{!?_enable_shared:-devel-static} = %version-%release

%description -n %lname-devel
%Name is basic framework for creating application specific scripting
languages. It is a library of functions centered around a virtual
machine, which guarantees high performance, ease of use and low
overhead. All its basic building blocks (compiler, interpreter,
decompiler, loader and saver) can be called with a single line of C. No
initialization necessary.

This package contains headers for development whith %Name.

%description -n %lname-devel -l uk_UA.CP1251
%Name -         
.   -     , 
  ,    
 .      (, ,
,   )    
  C,    .

        %Name.

%description -n %lname-devel -l ru_RU.CP1251
%Name -        
 .   -    
,    , 
    .   
  (, , ,  
)       C,  
 .

        %Name.


%if_enabled static
%package -n %lname-devel-static
Group: Development/C
Summary: Static %Name library
Summary(uk_UA.CP1251):   %Name
Summary(ru_RU.CP1251):   %Name
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
%Name is basic framework for creating application specific scripting
languages. It is a library of functions centered around a virtual
machine, which guarantees high performance, ease of use and low
overhead. All its basic building blocks (compiler, interpreter,
decompiler, loader and saver) can be called with a single line of C. No
initialization necessary.

This package contains static %Name library.

%description -n %lname-devel-static -l uk_UA.CP1251
%Name -         
.   -     , 
  ,    
 .      (, ,
,   )    
  C,    .

      %Name.

%description -n %lname-devel-static -l ru_RU.CP1251
%Name -        
 .   -    
,    , 
    .   
  (, , ,  
)       C,  
 .

      %Name.
%endif

%package doc-txt
Summary: %Name manual in plain text format
Summary(uk_UA.CP1251):   %Name   
Summary(ru_RU.CP1251):   %Name   
Group: Development/Documentation
BuildArch: noarch
Provides: %name-doc = %version-%release
Provides: %name-manual = %version-%release
Provides: %name-manual-txt = %version-%release

%description doc-txt
%Name is basic framework for creating application specific scripting
languages. It is a library of functions centered around a virtual
machine, which guarantees high performance, ease of use and low
overhead. But in the meanwhile %Name has acquired a reputation as an
educational tool. Its simplicity makes it perfectly suited to learn
Forth, from which it has been derived.

This package contains %Name manual in plain text format.

%description doc-txt -l uk_UA.CP1251
%Name -         
.   -     , 
  ,    
 .      (, ,
,   )    
  C,    .

      %Name   .

%description doc-txt -l ru_RU.CP1251
%Name -        
 .   -    
,    , 
    .   
  (, , ,  
)       C,  
 .

      %Name   .



%prep
%setup -n %name-%version-unix
%patch -p1
install -m 0644 %SOURCE1 sources/Makefile.ALT


%build
%if "%__cc" == "musl-gcc"
%define _optlevel s
%add_optflags -fno-asynchronous-unwind-tables
%endif
%add_optflags %{?_enable_shared:%optflags_shared} -fsigned-char -DUNIX -DDIR4TH='\"%_datadir/%name/\"'
%if "%__cc" == "gcc"
%add_optflags -DUSEGCCGOTO
%endif
%make_build -C sources -f Makefile.ALT \
	BINARIES=%_bindir LIBRARIES=%_libdir INCLUDES=%_includedir \
	%{?_enable_shared:SHARED=1} %{?_enable_static:STATIC=1} \
	CFLAGS="%optflags" %{?__cc:CC=%__cc} all

sed 's/\r$//' documentation/%{Name}manual.txt > documentation/manual.txt


%install
install -d -m 0755 %buildroot{%_bindir,%_libdir,%_datadir/%name/lib,%_includedir,%_man1dir,%_docdir/%name-%version/examples}
%make_install -C sources -f Makefile.ALT \
	BINARIES=%buildroot%_bindir LIBRARIES=%buildroot%_libdir INCLUDES=%buildroot%_includedir \
	%{?_enable_shared:SHARED=1} %{?_enable_static:STATIC=1} \
	CFLAGS="%optflags" %{?__cc:CC=%__cc} install
install -p -m 0644 documentation/%name.1 %buildroot%_man1dir/
ln -s %name.1 %buildroot%_man1dir/%{name}x.1
ln -s %name %buildroot%_bindir/%{name}x
install -p -m 0644 sources/%name.h %buildroot%_includedir/
install -p -m 0644 %name/lib/*.4th %buildroot%_datadir/%name/lib/
install -p -m 0644 %name/*.{4th,scr} %buildroot%_docdir/%name-%version/examples/
for d in 4pp{,/lib}; do
	install -d -m 0755 %buildroot%_docdir/%name-%version/examples/$d
	install -p -m 0644 %name/$d/*.4pp %buildroot%_docdir/%name-%version/examples/$d/
done
for d in %name/apps/*; do
	D=$(basename $d)
	install -d -m 0755 %buildroot%_docdir/%name-%version/examples/apps/$D
	install -p -m 0644 $d/* %buildroot%_docdir/%name-%version/examples/apps/$D/
done
for d in bench demo; do
	install -d -m 0755 %buildroot%_docdir/%name-%version/examples/$d
	install -p -m 0644 %name/$d/* %buildroot%_docdir/%name-%version/examples/$d/
done
install -p -m 0644 documentation/euro.txt %buildroot%_docdir/%name-%version/examples/
install -p -m 0644 README documentation/manual.txt %buildroot%_docdir/%name-%version/

# menu
install -d %buildroot%_desktopdir
iconv -f cp1251 -t utf-8 > %buildroot%_desktopdir/%name.desktop <<__MENU__
[Desktop Entry]
GenericName=%Name
Name=%Name System
Name[uk]=%Name-
Name[ru]=%Name-
Exec=%name
Icon=shells_section
Type=Application
Terminal=true
Categories=Development;IDE;ConsoleOnly;
__MENU__

%if "%__cc" == "musl-gcc" || "%__cc" == "tcc"
%add_verify_elf_skiplist %_bindir/*
%endif


%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/README
%_bindir/*
%_datadir/%name
%_man1dir/*
%_desktopdir/*


%if_enabled shared
%files -n %lname
%_libdir/*.so.*
%endif


%files -n %lname-devel
%_includedir/*
%{?_enable_shared:%_libdir/*.so}


%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%endif


%files examples
%dir %_docdir/%name-%version
%_docdir/%name-%version/examples


%files doc-txt
%dir %_docdir/%name-%version
%_docdir/%name-%version/*.txt


%changelog
