Name: AlephOne
Version: 1.0.1
Release: alt1.1

Summary: 3D first-person shooter game
License: %gpl2plus
Group: Games/Arcade
Url: http://marathon.sourceforge.net/

Packager: Artem Zolochevskiy <azol@altlinux.ru>

# http://downloads.sourceforge.net/marathon/AlephOne-20100118.tar.bz2
Source0: %name-%version.tar
Source1: %name.desktop
Source2: %name-48x48.png
Source3: alephone-wrapper.sh

BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Tue Jan 26 2010
BuildRequires: boost-devel gcc-c++ libGL-devel libSDL_image-devel libSDL_net-devel libSDL_ttf-devel libalsa-devel libmad-devel libpng-devel libsmpeg-devel libsndfile-devel libspeex-devel libvorbis-devel zziplib-devel
BuildRequires: desktop-file-utils

%description
Aleph One is an Open Source 3D first-person shooter game, based on the game
Marathon 2 by Bungie Software. It is set in a Sci-Fi universe dominated by
deviant computer AIs and features a well thought-out plot. Aleph One
supports, but doesn't require, OpenGL for rendering.

Aleph One requires additional data -- shape, sound, and map
information -- in order to run. The easiest way to get this is to go
to http://source.bungie.org/get/, and download one of the scenario zip
files there. Unzip it, and pass the resulting directory as an argument
to alephone. For example:

alephone "~/Marathon Infinity"

%prep
%setup

%build
%add_optflags -fpermissive
%configure --bindir=%_gamesbindir --datadir=%_gamesdatadir
%make_build

%install
%makeinstall_std
desktop-file-install --dir %buildroot%_desktopdir %SOURCE1
install -pD -m644 %SOURCE2 %buildroot%_liconsdir/%name.png
install -pD -m755 %SOURCE3 %buildroot%_gamesbindir/

%files
%doc AUTHORS INSTALL.Unix README docs/*.html examples
%dir %_gamesdatadir/%name
%dir %_gamesdatadir/%name/MML
%dir %_gamesdatadir/%name/Themes
%_gamesbindir/*
%_gamesdatadir/%name/Fonts
%_gamesdatadir/%name/MML/*.mml
%_gamesdatadir/%name/Themes/Default
%_liconsdir/%name.png
%_desktopdir/*
%_man6dir/*

%changelog
