Name: FlightGear-data
Version: 2.10.0
Release: alt2

Summary: Data pack for FlightGear open-source flight simulator
License: GPL
Group: Games/Arcade

Url: http://www.flightgear.org
Packager: Michael Shigorin <mike@altlinux.org>
Source: %name-%version.tar

AutoReqProv: no
Provides: fgfs-data = %version-%release
# to avoid data lurking w/o binaries
# NB: release intentionally left out
Requires: FlightGear = %version

BuildArch: noarch

# it's 450+ Mb of data
%brp_strip_none
%set_fixup_method skip
#set_strip_method none
%set_cleanup_method skip
%set_compress_method none
%set_verify_elf_method skip

%description
FlightGear is a free, open-source, multi-platform, and sophisticated
flight simulator framework for the development and pursuit of
interesting flight simulator ideas.

This package contains base FlightGear data files; feel free to
visit %url for more scenery and aircraft.

%package -n FlightGear-doc
Summary: Documentation for FlightGear open-source flight simulator
Group: Books/Computer books

%description -n FlightGear-doc
FlightGear is a free, open-source, multi-platform, and sophisticated
flight simulator framework for the development and pursuit of
interesting flight simulator ideas.

This package contains FlightGear documentation.

See also this nice and eagerly read tutorial:
http://www.4p8.com/eric.brasseur/flight_simulator_tutorial.html

%prep
%setup -n data

%install
mkdir -p %buildroot{%_datadir/flightgear,%_docdir}
mv Docs %buildroot%_docdir/FlightGear-%version
mv AUTHORS ChangeLog NEWS README %buildroot%_docdir/FlightGear-%version/
mv * %buildroot%_datadir/flightgear/

# It is the file in the package named Thumbs.db or Thumbs.db.gz, 
# which is normally a Windows image thumbnail database. 
# Such databases are generally useless in packages and were usually 
# accidentally included by copying complete directories from the source tarball.
find %buildroot -name 'Thumbs.db*' -print -delete

%files
%_datadir/flightgear

%files -n FlightGear-doc
%_docdir/FlightGear-%version

%changelog
