%def_enable egl
%def_enable gles2
%def_enable wayland_egl

Name:    Mesa
Version: 10.0.5
Release: alt0.M70P.2
Epoch:   4
License: MIT
Summary: OpenGL compatible 3D graphics library
Group:   System/Libraries
Url:     http://www.mesa3d.org

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source:  %name-%version.tar
Patch:   %name-%version-%release.patch

BuildRequires: llvm-devel >= 3.3 llvm-devel-static >= 3.3
BuildRequires: gcc-c++ indent flex libXdamage-devel libXext-devel libXft-devel libXmu-devel libXi-devel libXrender-devel libXxf86vm-devel
BuildRequires: libdrm-devel libexpat-devel xorg-glproto-devel xorg-dri2proto-devel python-modules libselinux-devel libxcb-devel libSM-devel
BuildRequires: python-module-libxml2 libudev-devel libXdmcp-devel libwayland-client-devel libwayland-server-devel libffi-devel libelf-devel
BuildRequires: libvdpau-devel libXvMC-devel xorg-dri3proto-devel xorg-presentproto-devel libxshmfence-devel

%description
Mesa is an OpenGL compatible 3D graphics library

%package -n libGL
Summary: OpenGL 1.3 compatible 3D graphics library for X Window server
Group: System/Libraries
Requires(post): coreutils

%description -n libGL
Mesa is an OpenGL compatible 3D graphics library

%package -n libGL-devel
Summary: Development files for Mesa Library
Group: Development/C
Requires: libGL = %epoch:%version-%release

%description -n libGL-devel
libGL-devel contains the libraries and header files needed to
develop programs which make use of Mesa

%package -n libEGL
Summary: Mesa EGL library
Group: System/Libraries
Requires: libGL = %epoch:%version-%release

%description -n libEGL
Mesa EGL library

%package -n libEGL-devel
Summary: Mesa libEGL development package
Group: Development/C
Requires: libEGL = %epoch:%version-%release

%description -n libEGL-devel
Mesa libEGL development package

%package -n libGLES
Summary: Mesa OpenGL ES library
Group: System/Libraries

%description -n libGLES
Mesa OpenGL ES library

%package -n libGLES-devel
Summary: Mesa libGLES development package
Group: Development/C
Requires: libGLES = %epoch:%version-%release
Requires: libEGL-devel = %epoch:%version-%release

%description -n libGLES-devel
Mesa libGLES development package

%package -n libgbm
Summary: GBM buffer management library
Group: System/Libraries

%description -n libgbm
GBM buffer management library

%package -n libgbm-devel
Summary: GBM buffer management development package
Group: Development/C
Requires: libgbm = %epoch:%version-%release

%description -n libgbm-devel
GBM buffer management development package

%package -n libwayland-egl
Summary: Mesa Wayland-EGL library
Group: System/Libraries
Requires: libGL = %epoch:%version-%release

%description -n libwayland-egl
Mesa EGL library for Wayland

%package -n libwayland-egl-devel
Summary: Mesa Wayland-EGL development package
Group: Development/C
Requires: libwayland-egl = %epoch:%version-%release

%description -n libwayland-egl-devel
Mesa Wayland-EGL development package

%package -n xorg-dri-swrast
Summary: Mesa software rendering libraries
Group: System/X11
Requires: libGL = %epoch:%version-%release

%description -n xorg-dri-swrast
Mesa software rendering libraries

%package -n xorg-dri-intel
Summary: Intel DRI driver
Group: System/X11
Requires: libGL = %epoch:%version-%release

%description -n xorg-dri-intel
DRI driver for Intel i8xx, i9xx

%package -n xorg-dri-radeon
Summary: ATI RADEON DRI driver
Group: System/X11
Requires: libGL = %epoch:%version-%release

%description -n xorg-dri-radeon
DRI driver for ATI R100, R200, R300, R400, R500

%package -n xorg-dri-nouveau
Summary: nVidia DRI driver
Group: System/X11
Requires: libGL = %epoch:%version-%release

%description -n xorg-dri-nouveau
DRI driver for nVidia

%package -n glxinfo
Summary: display info about a GLX extension and OpenGL renderer
Group: System/X11
Requires: libGL = %epoch:%version-%release

%description -n glxinfo
glxinfo lists information about the GLX extension, OpenGL capable visu-
als, and the OpenGL renderer on an X server. The GLX and renderer  info
includes  the  version  and extension attributes. The visual info lists
the GLX visual attributes available  for  each  OpenGL  capable  visual
(e.g.  whether  the  visual is double buffered, the component sizes, Z-
buffering depth, etc)

%package -n glxgears
Summary: GLX version of the infamous "gears" GL demo
Group: System/X11
Requires: libGL = %epoch:%version-%release

%description -n glxgears
glxgears  is a GLX demo that draws three rotating gears, and prints out
framerate information to stdout

%set_verify_elf_method unresolved=relaxed

%define dri_common	r200,radeon
%define dri_ix86	%dri_common,i915,i965,nouveau
%define dri_ppc		%dri_common,i915,i965

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
%ifarch %ix86
	--enable-32-bit \
	--with-dri-drivers=%dri_ix86 \
%else
%ifarch x86_64
	--enable-64-bit \
	--with-dri-drivers=%dri_ix86 \
%else
%ifarch ppc
	--enable-32-bit \
	--with-dri-drivers=%dri_ppc \
%else
%ifarch %arm
	--with-dri-drivers=swrast \
%else
	--with-dri-drivers=%dri_common \
%endif
%endif
%endif
%endif
%ifarch %ix86 x86_64
	--with-gallium-drivers=swrast,r300,r600,nouveau,radeonsi \
	--enable-vdpau \
	--enable-xvmc \
%endif
	--enable-texture-float \
	--enable-shared-glapi \
	--disable-gallium-egl \
	%{subst_enable egl} \
	%{subst_enable gles2} \
	--enable-texture-float \
	--enable-glx-tls \
	--enable-selinux \
	--with-dri-driverdir=%_libdir/X11/modules/dri \
%if_enabled wayland_egl
	--with-egl-platforms=x11,wayland,drm \
	--enable-gbm
%endif
#

%make_build

%install
%make DESTDIR=%buildroot install

mkdir -p %buildroot%_sysconfdir/X11/%_lib
# moved libGL
mv %buildroot%_libdir/libGL.so.1.2.0 %buildroot%_libdir/X11/libGL.so.1.2
ln -sf ../../..%_libdir/X11/libGL.so.1.2 %buildroot%_sysconfdir/X11/%_lib/libGL.so.1
ln -sf ../..%_sysconfdir/X11/%_lib/libGL.so.1 %buildroot%_libdir/
ln -sf X11/libGL.so.1.2 %buildroot%_libdir/libGL.so
# moved libEGL
mv %buildroot%_libdir/libEGL.so.1.0.0 %buildroot%_libdir/X11/libEGL.so.1.0.0
ln -sf ../../..%_libdir/X11/libEGL.so.1.0.0 %buildroot%_sysconfdir/X11/%_lib/libEGL.so.1
ln -sf ../..%_sysconfdir/X11/%_lib/libEGL.so.1 %buildroot%_libdir/
ln -sf X11/libEGL.so.1.0.0 %buildroot%_libdir/libEGL.so
# moved libGLESv2
mv %buildroot%_libdir/libGLESv2.so.2.0.0 %buildroot%_libdir/X11/libGLESv2.so.2.0.0
ln -sf ../../..%_libdir/X11/libGLESv2.so.2.0.0 %buildroot%_sysconfdir/X11/%_lib/libGLESv2.so.2
ln -sf ../..%_sysconfdir/X11/%_lib/libGLESv2.so.2 %buildroot%_libdir/
ln -sf X11/libGLESv2.so.2.0.0 %buildroot%_libdir/libGLESv2.so
#
/sbin/ldconfig -Nn %buildroot%_libdir/X11/

%post -n libGL
[ -r %_sysconfdir/X11/%_lib/libGL.so.1 ] || \
	ln -sf ../../..%_libdir/X11/libGL.so.1.2 %_sysconfdir/X11/%_lib/libGL.so.1
ln -sf ../..%_sysconfdir/X11/%_lib/libGL.so.1 %_libdir/

%post -n libEGL
[ -r %_sysconfdir/X11/%_lib/libEGL.so.1 ] || \
	ln -sf ../../..%_libdir/X11/libEGL.so.1.0.0 %_sysconfdir/X11/%_lib/libEGL.so.1
ln -sf ../..%_sysconfdir/X11/%_lib/libEGL.so.1 %_libdir/

%post -n libGLES
[ -r %_sysconfdir/X11/%_lib/libGLESv2.so.2 ] || \
	ln -sf ../../..%_libdir/X11/libGLESv2.so.2.0.0 %_sysconfdir/X11/%_lib/libGLESv2.so.2
ln -sf ../..%_sysconfdir/X11/%_lib/libGLESv2.so.2 %_libdir/

%files -n libGL
%doc docs/relnotes/%version.html
%dir %_sysconfdir/X11/%_lib
%ghost %_sysconfdir/X11/%_lib/libGL.so.1
%_libdir/libGL.so.*
%_libdir/libglapi.so.*
%dir %_libdir/X11
%_libdir/X11/libGL.so.*
%dir %_libdir/X11/modules
%dir %_libdir/X11/modules/dri

%files -n libGL-devel
%dir %_includedir/GL
%_includedir/GL/internal
%_includedir/GL/gl.h
%_includedir/GL/gl_mangle.h
%_includedir/GL/glext.h
%_includedir/GL/glx.h
%_includedir/GL/glx_mangle.h
%_includedir/GL/glxext.h
%_libdir/libGL.so
%_libdir/libglapi.so
%_pkgconfigdir/gl.pc
%_pkgconfigdir/dri.pc

%if_enabled egl
%files -n libEGL
%dir %_sysconfdir/X11/%_lib
%ghost %_sysconfdir/X11/%_lib/libEGL.so.1
%_libdir/libEGL.so.*
%_libdir/X11/libEGL.so.*

%files -n libEGL-devel
%_includedir/EGL
%_includedir/KHR
%_libdir/libEGL.so
%_pkgconfigdir/egl.pc
%endif

%if_enabled gles2
%files -n libGLES
%dir %_sysconfdir/X11/%_lib
%ghost %_sysconfdir/X11/%_lib/libGLESv2.so.2
%_libdir/libGLESv2.so.*
%_libdir/X11/libGLESv2.so.*

%files -n libGLES-devel
%_includedir/GLES2
%_libdir/libGLESv2.so
%_pkgconfigdir/glesv2.pc
%endif

%if_enabled wayland_egl
%files -n libgbm
%_libdir/libgbm.so.*

%files -n libgbm-devel
%_includedir/gbm.h
%_libdir/libgbm.so
%_pkgconfigdir/gbm.pc

%files -n libwayland-egl
%_libdir/libwayland-egl.so.*

%files -n libwayland-egl-devel
%_libdir/libwayland-egl.so
%_pkgconfigdir/wayland-egl.pc
%endif

%files -n xorg-dri-swrast
%_libdir/X11/modules/dri/swrast*_dri.so

%ifarch ppc %ix86 x86_64
%files -n xorg-dri-intel
%config(noreplace) %_sysconfdir/drirc
%_libdir/X11/modules/dri/i9?5_dri.so

%files -n xorg-dri-nouveau
%_libdir/X11/modules/dri/nouveau_*dri.so
%ifarch %ix86 x86_64
%_libdir/vdpau/libvdpau_nouveau.so*
%_libdir/libXvMCnouveau.so.*
%endif

%files -n xorg-dri-radeon
%_libdir/X11/modules/dri/radeon*_dri.so
%_libdir/X11/modules/dri/r?00_dri.so
%ifarch %ix86 x86_64
%_libdir/vdpau/libvdpau_r*.so*
%_libdir/libXvMCr*.so.*
%endif
%endif

%files -n glxinfo
%_bindir/glxinfo

%files -n glxgears
%_bindir/glxgears

%changelog
