#define git_date .git20130531
%define git_date %nil

%define dbus_version 1.1
%define libdbus_glib_version 0.76
%define libgudev_version 143

%def_with qmi
%def_with mbim
%def_enable introspection
%def_disable vala

Name: ModemManager
Version: 1.4.18
Release: alt1.M70P.1%git_date
License: %gpl2plus
Group: System/Configuration/Networking
Summary: Mobile broadband modem management service
Url: http://cgit.freedesktop.org/ModemManager/ModemManager/
Source: %name-%version.tar
Source1: ModemManager.init
Patch: %name-%version-%release.patch

Requires: dbus >= %dbus_version

BuildRequires(pre): rpm-build-licenses

BuildRequires: libdbus-glib-devel
BuildRequires: libgudev-devel >= %libgudev_version
BuildRequires: libgio-devel
%{?_with_qmi:BuildRequires: libqmi-glib-devel}
%{?_with_mbim:BuildRequires: libmbim-glib-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}
BuildRequires: intltool
BuildRequires: ppp-devel
BuildRequires: libpolkit-devel
BuildRequires: gtk-doc

# For tests
BuildRequires: /dev/pts
BuildRequires: dbus

# Because of starting from the init script
Conflicts: NetworkManager < 0.9.8.9

%description
ModemManager provides a DBus interface to communicate with
mobile broadband (GSM, CDMA, UMTS, ...) cards. Implements
a loadable plugin interface to add work-arounds for
non standard devices.

%package devel
License: %lgpl2plus
Group: Development/C
Summary: Headers for adding ModemManager support to applications

%description devel
This package contains various headers accessing some ModemManager
functionality from applications.

%package devel-doc
Group: Development/Documentation
Summary: Development documentation for %name
BuildArch: noarch

%description devel-doc
%summary

%package -n libmm-glib
License: %lgpl2plus
Summary: Libraries for adding ModemManager support to applications that use glib
Group: System/Libraries

%description -n libmm-glib
This package contains the libraries that make it easier to use some
ModemManager functionality from applications that use glib.

%package -n libmm-glib-devel
License: %lgpl2plus
Summary: Development files for libmm-glib
Group: Development/C
Requires: libmm-glib = %version-%release

%description -n libmm-glib-devel
This package contains libraries and header files for
developing applications that use libmm-glib.

%package -n libmm-glib-devel-doc
Group: Development/Documentation
Summary: Development documentation for libmm-glib
BuildArch: noarch

%description -n libmm-glib-devel-doc
%summary

%package -n libmm-glib-gir
Summary: GObject introspection data for the ModemManager
Group: System/Libraries
Requires: libmm-glib = %version-%release

%description -n libmm-glib-gir
%summary

%package -n libmm-glib-gir-devel
Summary: GObject introspection devel data for the ModemManager
Group: System/Libraries
BuildArch: noarch
Requires: libmm-glib-gir = %version-%release
Requires: libmm-glib-devel = %version-%release

%description -n libmm-glib-gir-devel
%summary

%package -n libmm-glib-vala
Summary: Vala bindings for the ModemManager
Group: Development/Other
BuildArch: noarch
Requires: libmm-glib-devel = %version-%release

%description -n libmm-glib-vala
%summary

%prep
%setup -n %name-%version
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--with-udev-base-dir=/lib/udev \
	--with-polkit \
	--with-systemdsystemunitdir=%_unitdir \
	%{subst_with qmi} \
	%{subst_with mbim} \
	%{subst_enable introspection} \
	%{subst_enable vala} \
	--enable-gtk-doc

%make_build

%check
make check

%install
%makeinstall_std
%find_lang %name

# Install initscript
install -Dm0755 %SOURCE1 %buildroot%_initdir/ModemManager

%post
# Don't restart service during upgrade:
# the network can be via modem controlled
# by ModemManager itself.
#post_service %name
SYSTEMCTL=systemctl
if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
	"$SYSTEMCTL" daemon-reload ||:
	if [ "$1" -eq 1 ]; then
		"$SYSTEMCTL" -q preset %name.service||:
	fi
else
	if [ "$1" -eq 1 ]; then
		/sbin/chkconfig --add %name ||:
	else
		/sbin/chkconfig %name resetpriorities ||:
	fi
fi

%preun
# Don't stop service:
# the network can be via modem controlled
# by ModemManager itself.
#preun_service %name
if [ "$1" -eq 0 ]; then
	SYSTEMCTL=systemctl
	if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
		"$SYSTEMCTL" --no-reload -q disable %name.service ||:
	else
		chkconfig --del %name ||:
	fi
fi

%files -f %name.lang
%doc ChangeLog NEWS AUTHORS README
%_datadir/dbus-1/system-services/*.service
%dir %_libdir/ModemManager/
%_libdir/ModemManager/*.so
%_sbindir/*
%_bindir/mmcli
%_sysconfdir/dbus-1/system.d/*.conf
%_datadir/dbus-1/interfaces/*.xml
/lib/udev/rules.d/*
%_iconsdir/hicolor/*/apps/*
%_datadir/polkit-1/actions/*.policy
%_unitdir/*.service
%_initdir/ModemManager
%doc %_man8dir/*.*

%exclude %_libdir/ModemManager/*.la

%files devel
%_includedir/%name
%_pkgconfigdir/%name.pc

%files devel-doc
%doc %_datadir/gtk-doc/html/%name

%files -n libmm-glib
%_libdir/libmm-glib.so.*

%files -n libmm-glib-devel
%_libdir/libmm-glib.so
%_includedir/libmm-glib
%_pkgconfigdir/mm-glib.pc

%files -n libmm-glib-devel-doc
%doc %_datadir/gtk-doc/html/libmm-glib

%if_enabled introspection
%files -n libmm-glib-gir
%_libdir/girepository-1.0/ModemManager-1.0.typelib

%files -n libmm-glib-gir-devel
%_datadir/gir-1.0/ModemManager-1.0.gir
%endif

%if_enabled vala
%files -n libmm-glib-vala
%_datadir/vala/vapi/*
%endif

%changelog
