%define git_date .git20150519
#define git_date %nil

%define dbus_version 1.2.12-alt2
%define libdbus_glib_version 0.76

%define ppp_version 2.4.5
%define wpa_supplicant_version 0.7.3-alt3
%define dhcpcd_version 4.0.0
%define openresolv_version 3.5.4-alt3

%def_enable systemd
%def_disable wimax
%def_enable introspection

Name: NetworkManager
Version: 0.9.8.10
Release: alt1.M70P.2%git_date
License: %gpl2plus
Group: System/Configuration/Networking
Summary: Network Link Manager and User Applications
Url: http://www.gnome.org/projects/NetworkManager/
# git://git.freedesktop.org/git/NetworkManager/NetworkManager.git
Source: %name-%version.tar
Source1: %name.conf
Source2: 50-ntpd
Source4: 10-netfs
Source5: 20-hostname
Source6: NetworkManager.sysconfig
Source7: 30-efw
Source8: 80-etcnet-post
Source9: NetworkManager-prestart
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

# For tests
BuildPreReq: dbus dhcpcd dhcp-client

BuildPreReq: intltool libgcrypt-devel libtool
BuildRequires: glibc-devel-static iproute2 libnl-devel libwireless-devel ppp-devel
BuildRequires: libdbus-glib-devel >= %libdbus_glib_version
BuildRequires: libpolkit1-devel libnss-devel libgio-devel libuuid-devel gtk-doc
BuildRequires: libgudev-devel
BuildRequires: libgnome-bluetooth-devel
BuildRequires: iptables libsoup-devel
BuildRequires: libmm-glib-devel
%{?_enable_wimax:BuildRequires: libiWmxSdk-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgudev-gir-devel}
%{?_enable_systemd:BuildRequires: systemd-devel libsystemd-login-devel}

Requires: dbus >= %dbus_version
Requires: wpa_supplicant >= %wpa_supplicant_version
Requires: iproute2 openssl
Requires: ppp = %ppp_version
Requires: nss >= 3.11.7
Requires: ppp-pppoe
Requires: dnsmasq
Requires: openresolv >= %openresolv_version
Requires: openresolv-dnsmasq >= %openresolv_version
Requires: libshell
Requires: ModemManager >= 1.2.0-alt1.M70P.1
Requires: NetworkManager-glib = %version-%release
Requires: nm-dhcp-client

Conflicts: NetworkManager-vpnc < 0.9.2
Conflicts: NetworkManager-openvpn < 0.9.2
Conflicts: NetworkManager-pptp < 0.9.2
Conflicts: NetworkManager-gnome < 0.9.2

Conflicts: dhcpcd < %dhcpcd_version

Obsoletes: nmcli

%description
NetworkManager attempts to keep an active network connection available
at all times.  The point of NetworkManager is to make networking
configuration and setup as painless and automatic as possible. If
using DHCP, NetworkManager is intended to replace default routes,
obtain IP addresses from a DHCP server, and change name servers
whenever it sees fit.

%package devel
License: %gpl2plus
Summary: Libraries and headers for adding NetworkManager support to applications
Group: Development/Other
Requires: libdbus-glib >= %libdbus_glib_version
Requires: libdbus-devel >= %dbus_version
Requires: pkgconfig

%description devel
This package contains various headers accessing some NetworkManager
functionality from applications.

%package glib
License: %gpl2plus
Summary: Libraries for adding NetworkManager support to applications that use glib
Group: Development/GNOME and GTK+
Requires: dbus >= %dbus_version

%description glib
This package contains the libraries that make it easier to use some
Network Manager functionality from applications that use glib.

%package glib-devel
Summary: Header files for adding NetworkManager support to applications that use glib.
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release
Requires: %name-glib = %version-%release
Requires: glib2-devel
Requires: pkgconfig
Requires: libdbus-glib-devel >= %libdbus_glib_version

%description glib-devel
This package contains the header and pkg-config files for development
applications using NetworkManager functionality from applications
that use glib.

%package glib-devel-doc
Summary: Development documentation for %name-glib
Group: Development/GNOME and GTK+
Conflicts: %name-glib < %version
BuildArch: noarch

%description glib-devel-doc
This package contains development documentation for %name-glib

%package glib-gir
Summary: GObject introspection data for the NetworkManager
Group: System/Libraries
Requires: %name-glib = %version-%release

%description glib-gir
GObject introspection data for the NetworkManager.

%package glib-gir-devel
Summary: GObject introspection devel data for the NetworkManager
Group: System/Libraries
BuildArch: noarch
Requires: %name-glib-gir = %version-%release
Requires: %name-glib-devel = %version-%release

%description glib-gir-devel
GObject introspection devel data for the NetworkManager.


%prep
%setup
%patch -p1

%build
# Disable remote settings client test.
# It is required X session.
#SUBDIRS=. tests
sed -i 's;^SUBDIRS=\. tests;#SUBDIRS=. tests;' libnm-glib/Makefile.am

%autoreconf
%configure \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	--disable-static \
	--with-crypto=nss \
	--with-dhclient=/sbin/dhclient \
	--with-dhcpcd=/sbin/dhcpcd \
	--with-dnsmasq=/usr/sbin/dnsmasq \
	--enable-doc=yes \
	--with-resolvconf=/sbin/resolvconf \
	--enable-concheck \
	--with-pppd-plugin-dir=%_libdir/pppd/%ppp_version \
	%{subst_enable wimax} \
	--enable-tests=yes \
	%{?_enable_systemd:--with-systemdsystemunitdir=/lib/systemd/system} \
%if_enabled systemd
	--with-session-tracking=systemd \
	--with-suspend-resume=systemd \
%else
	--with-session-tracking=ck \
	--with-suspend-resume=upower \
%endif
	--enable-etcnet-alt \
	--disable-ifcfg-rh \
	--disable-ifcfg-suse \
	--disable-ifupdown \
	--disable-ifnet \
	--with-modem-manager-1 \
	--enable-bluez4 \
	--enable-introspection=auto \
	--enable-more-warnings=error

%make_build

%install
%makeinstall_std
%find_lang %name
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_sysconfdir/NetworkManager/VPN
mkdir -p %buildroot%_sysconfdir/NetworkManager/system-connections
./libtool --mode=install install -m 755 test/nm-online %buildroot%_bindir/
mkdir -p %buildroot/%_var/log/
touch %buildroot/%_var/log/NetworkManager
mkdir -p %buildroot/%_var/lib/NetworkManager
touch %buildroot/%_var/lib/NetworkManager/timestamps
touch %buildroot/%_var/lib/NetworkManager/NetworkManager.state
install -m 0644 %SOURCE1 %buildroot%_sysconfdir/NetworkManager/
install -m 0755 %SOURCE2 %buildroot%_sysconfdir/NetworkManager/dispatcher.d
install -m 0755 %SOURCE4 %buildroot%_sysconfdir/NetworkManager/dispatcher.d
install -m 0755 %SOURCE5 %buildroot%_sysconfdir/NetworkManager/dispatcher.d
install -m 0755 %SOURCE7 %buildroot%_sysconfdir/NetworkManager/dispatcher.d
install -m 0755 %SOURCE8 %buildroot%_sysconfdir/NetworkManager/dispatcher.d
install -Dm0644 %SOURCE6 %buildroot%_sysconfdir/sysconfig/%name

# Install initscript
install -Dm0755 initscript/Alt/NetworkManager %buildroot%_initdir/NetworkManager

# Install NetworkManager pre start script
install -Dm0755 %SOURCE9 %buildroot%_sbindir/NetworkManager-prestart

%check
make check

%pre
# Workaround for upgrade
[ -d %_var/lib/NetworkManager/timestamps ] &&
rm -rf %_var/lib/NetworkManager/timestamps/ ||:

%post
#post_service %name
SYSTEMCTL=systemctl
if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
	"$SYSTEMCTL" daemon-reload ||:
	if [ "$1" -eq 1 ]; then
		"$SYSTEMCTL" -q preset NetworkManager.service ||:
	fi
else
	if [ "$1" -eq 1 ]; then
		/sbin/chkconfig --add NetworkManager ||:
	else
		/sbin/chkconfig NetworkManager resetpriorities ||:
	fi
fi

%preun
%preun_service %name
if [ $1 -eq 0 ]; then
    killall -TERM nm-system-settings >/dev/null 2>&1 ||:
fi

%triggerpostun -- %name <= 0.9.8.2-alt3
SYSTEMCTL=systemctl
if sd_booted && "$SYSTEMCTL" -q is-enabled %name.service; then
	"$SYSTEMCTL" enable -q %name-dispatcher.service
fi

%files -f %name.lang
%doc COPYING NEWS AUTHORS README CONTRIBUTING TODO
%_bindir/nm-tool
%_bindir/nm-online
%_bindir/nmcli
%_libdir/pppd/%ppp_version/nm-pppd-plugin.so
%_datadir/dbus-1/system-services/*.service
%doc %_man1dir/*.*
%doc %_man5dir/*.*
%doc %_man8dir/*.*
%dir %_libexecdir/NetworkManager/
%dir %_libdir/NetworkManager/
%_libdir/NetworkManager/libnm-*.so
%_libexecdir/NetworkManager/nm-*
%_sbindir/*
%_sysconfdir/dbus-1/system.d/*.conf
%config(noreplace) %_sysconfdir/NetworkManager/%name.conf
%_initrddir/NetworkManager
%dir %_sysconfdir/NetworkManager
%dir %_sysconfdir/NetworkManager/dispatcher.d
%dir %_sysconfdir/NetworkManager/VPN
%dir %_sysconfdir/NetworkManager/system-connections
%dir %_var/lib/NetworkManager
%ghost %config(noreplace) %_var/log/NetworkManager
%ghost %config(noreplace) %_var/lib/NetworkManager/NetworkManager.state
%ghost %config(noreplace) %_var/lib/NetworkManager/timestamps
/lib/udev/rules.d/*
%_datadir/polkit-1/actions/*.policy
%_sysconfdir/NetworkManager/dispatcher.d/*
%_datadir/bash-completion/completions/*
%config(noreplace) %_sysconfdir/sysconfig/%name
%{?_enable_systemd:/lib/systemd/system/%name.service}
%{?_enable_systemd:/lib/systemd/system/%name-wait-online.service}
%{?_enable_systemd:/lib/systemd/system/%name-dispatcher.service}

%files devel
%doc %_datadir/gtk-doc/html/%name
%dir %_includedir/%name
%_includedir/%name/%name.h
%_includedir/%name/NetworkManagerVPN.h
%_includedir/%name/nm-version.h
%_pkgconfigdir/%name.pc

%files glib
%_libdir/libnm-glib.so.*
%_libdir/libnm-glib-vpn.so.*
%_libdir/libnm-util.so.*

%files glib-devel
%dir %_includedir/libnm-glib
%_includedir/libnm-glib/*.h
%_includedir/%name/nm-setting*.h
%_includedir/%name/nm-connection.h
%_includedir/%name/nm-utils*.h
%_pkgconfigdir/libnm-glib.pc
%_pkgconfigdir/libnm-glib-vpn.pc
%_pkgconfigdir/libnm-util.pc
%_libdir/libnm-glib.so
%_libdir/libnm-glib-vpn.so
%_libdir/libnm-util.so

%files glib-devel-doc
%dir %_datadir/gtk-doc/html/libnm-glib
%_datadir/gtk-doc/html/libnm-glib/*
%dir %_datadir/gtk-doc/html/libnm-util
%_datadir/gtk-doc/html/libnm-util/*

%if_enabled introspection
%files glib-gir
%_libdir/girepository-1.0/NMClient-1.0.typelib
%_libdir/girepository-1.0/NetworkManager-1.0.typelib

%files glib-gir-devel
%_datadir/gir-1.0/NMClient-1.0.gir
%_datadir/gir-1.0/NetworkManager-1.0.gir
%endif

%exclude %_libdir/NetworkManager/*.la
%exclude %_libdir/pppd/%ppp_version/*.la

%changelog
