%define nm_version 0.9.8.0
%define git_date .git20141027
#define git_date %nil
%define gtkver 3

%def_with bluetooth

Name: NetworkManager-applet-gtk
Version: 0.9.8.10
Release: alt1.M70P.4%git_date
License: %gpl2plus
Group: Graphical desktop/GNOME
Summary: Panel applet for use with NetworkManager
Url: https://wiki.gnome.org/Projects/NetworkManager
# Upstream: git://git.gnome.org/network-manager-applet
Source: nm-applet-%version.tar
Patch: nm-applet-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildPreReq: libdbus-devel libdbus-glib libGConf-devel libgtk+%gtkver-devel intltool libtool libpolkit1-devel

BuildRequires: libwireless-devel
BuildRequires: libnotify-devel
BuildRequires: NetworkManager-devel >= %nm_version
BuildRequires: NetworkManager-glib-devel >= %nm_version
BuildRequires: NetworkManager-glib-gir-devel >= %nm_version
%{?_with_bluetooth:BuildRequires: libgnome-bluetooth-devel}
BuildRequires: iso-codes-devel
BuildRequires: gnome-common
BuildRequires: libgudev-devel
BuildRequires: libmm-glib-devel
BuildRequires: gobject-introspection-devel libgtk+%gtkver-gir-devel
BuildRequires: libsecret-devel
# For migration from libgnome-keyring to libsecret
BuildRequires: libgnome-keyring-devel
# For migration connections from gconf
BuildRequires: libGConf-devel

Requires: NetworkManager >= %nm_version
Requires: libnm-gtk = %version-%release
Requires: gnome-keyring gcr
Requires: dbus-tools-gui
Requires: mobile-broadband-provider-info
Requires: polkit-gnome
Requires: iso-codes

Obsoletes: NetworkManager-gnome < 0.9.8.4
Provides: NetworkManager-gnome = %version-%release

%description
This package contains GNOME utilities and applications for use with
NetworkManager, including a panel applet for wireless networks.

%package -n libnm-gtk
License: %gpl2plus
Group: Graphical desktop/GNOME
Summary: Private libraries for NetworkManager GUI support

%description -n libnm-gtk
This package contains private libraries to be used only by nm-applet and
the GNOME Control Center.

%package -n libnm-gtk-devel
License: %gpl2plus
Group: Development/GNOME and GTK+
Summary: Private header files for NetworkManager GUI support
Requires: libnm-gtk = %version-%release
Requires: NetworkManager-glib-devel >= %nm_version
Requires: libgtk+%gtkver-devel

%description -n libnm-gtk-devel
This package contains private header and pkg-config files to be used
only by nm-applet and the GNOME control center.

%package -n libnm-gtk-gir
License: %gpl2plus
Group: System/Libraries
Summary: GObject introspection data for the libnm-gtk
Requires: libnm-gtk = %version-%release

%description -n libnm-gtk-gir
GObject introspection data for the libnm-gtk.

%package -n libnm-gtk-gir-devel
License: %gpl2plus
Group: System/Libraries
Summary: GObject introspection devel data for the libnm-gtk
BuildArch: noarch
Requires: libnm-gtk-gir = %version-%release
Requires: libnm-gtk-devel = %version-%release

%description -n libnm-gtk-gir-devel
GObject introspection devel data for the libnm-gtk.

%prep
%setup -n nm-applet-%version
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	--with-gtkver=%gtkver \
	--with-modem-manager-1 \
	%{subst_with bluetooth} \
	--enable-more-warnings=error

%make_build

%install
%makeinstall_std
%find_lang nm-applet

# For VPN plugins
mkdir -p %buildroot/%_datadir/gnome-vpn-properties

%check
make check

%files -f nm-applet.lang
%_bindir/*
%_datadir/nm-applet
%_iconsdir/hicolor/*/apps/*
%_sysconfdir/xdg/autostart/nm-applet.desktop
%_libexecdir/NetworkManager/nm-applet-migration-tool
%_datadir/GConf/gsettings/nm-applet.convert
%_datadir/glib-2.0/schemas/org.gnome.nm-applet.gschema.xml
%doc %_man1dir/*.*

%_datadir/applications/*.desktop
%dir %_datadir/gnome-vpn-properties

%if_with bluetooth
%_libdir/gnome-bluetooth/plugins/*.so
%exclude %_libdir/gnome-bluetooth/plugins/*.la
%endif

%files -n libnm-gtk
%_libdir/*.so.*
%_datadir/libnm-gtk/

%files -n libnm-gtk-devel
%_includedir/libnm-gtk/
%_libdir/*.so
%_pkgconfigdir/libnm-gtk.pc

%files -n libnm-gtk-gir
%_libdir/girepository-1.0/NMGtk-1.0.typelib

%files -n libnm-gtk-gir-devel
%_datadir/gir-1.0/NMGtk-1.0.gir

%changelog
