%define nm_version 0.9.8
%define nm_applet_version 0.9.8
%define nm_applet_name NetworkManager-applet-gtk
%define gtkver 3

Name: NetworkManager-openconnect
Version: 0.9.8.4
Release: alt1.M70P.1
License: %gpl2plus
Group: System/Configuration/Networking
Summary: NetworkManager VPN integration for openconnect

Url: http://www.gnome.org/projects/NetworkManager/

Source: %name-%version.tar
Patch1: %name-%version-%release.patch
Requires: NetworkManager >= %nm_version
Requires: openconnect

BuildRequires(pre): rpm-build-licenses
BuildRequires: libopenconnect-devel >= 3.02
BuildRequires: perl-XML-Parser
BuildRequires: NetworkManager-devel >= %nm_version
BuildRequires: NetworkManager-glib-devel >= %nm_version
BuildRequires: libgtk+%gtkver-devel
BuildRequires: libdbus-glib-devel >= 0.74
BuildRequires: libGConf-devel libgnome-keyring-devel
BuildRequires: libssl-devel
BuildRequires: intltool gettext
BuildRequires: libxml2-devel


%description
This package contains software for integrating the openconnect VPN software
with NetworkManager and the GNOME desktop

%package gtk
License: %gpl2plus
Summary: Applications for use %name with %nm_applet_name
Group: Graphical desktop/GNOME
Requires: shared-mime-info >= 0.16
Requires: GConf2
Requires: %nm_applet_name >= %version
Requires: NetworkManager-openconnect = %version-%release

Obsoletes: %name-gnome < 0.9.8.4
Provides: %name-gnome = %version-%release

%description gtk
This package contains applications for use with
NetworkManager panel applet.

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure \
    --disable-static \
    --libexecdir=%_libexecdir/NetworkManager \
    --localstatedir=%_var \
    --with-gtkver=%gtkver

%make_build

%install
%makeinstall_std
%find_lang %name

%files
%doc AUTHORS ChangeLog COPYING
%config(noreplace) %_sysconfdir/dbus-1/system.d/nm-openconnect-service.conf
%config(noreplace) %_sysconfdir/NetworkManager/VPN/nm-openconnect-service.name
%_libexecdir/NetworkManager/nm-openconnect-service
%_libexecdir/NetworkManager/nm-openconnect-service-openconnect-helper

%files gtk -f %name.lang
%_libdir/NetworkManager/lib*.so*
%_libexecdir/NetworkManager/nm-openconnect-auth-dialog
%_datadir/gnome-vpn-properties/openconnect

%exclude %_libdir/NetworkManager/lib*.la

%changelog
