BuildRequires(pre): rpm-build-python

%define dirs DerApproximator FuncDesigner OpenOpt SpaceFuncs

Name: OOSuite
Version: 0.43
Release: alt1.svn20130131
Summary: OpenOpt Suite
License: BSD
Group: Sciences/Mathematics
Url: http://openopt.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# svn://openopt.org/PythonPackages
Source: %name-%version.tar.gz

BuildPreReq: python-devel gcc-fortran /proc
BuildPreReq: libnumpy-devel python-module-setuptools
BuildPreReq: python-module-matplotlib
BuildPreReq: libglpk-devel
BuildPreReq: python-module-cvxopt python-module-pswarm_py
BuildPreReq: python-module-pyipopt python-module-pywrapper
BuildPreReq: python-module-scipy libopenblas-devel

%description
OpenOpt is a free optimization framework that was created in June of
2007. It is a relatively new project that is currently developed in the
optimization department of the Cybernetics Institute at the Ukrainian
National Academy of Sciences, in collaboration with the SciPy
development team. OpenOpt interfaces with many different algorithms for
solving optimization problems (solvers), some of which are written in C
or Fortran.

%package -n python-module-toms587
Summary: Python wrapper of toms587
Group: Development/Python
%setup_python_module toms587
%py_provides toms587
Conflicts: python-module-toms_587
Obsoletes: python-module-toms_587

%description -n python-module-toms587
This package contains python wrapper of toms587.

%package -n python-module-openopt
Summary: Python module of Numerical optimization framework
Group: Development/Python
%setup_python_module openopt
Requires: libglpk >= 4.38
Requires: python-module-scipy >= 0.8.0
Requires: python-module-matplotlib
%py_requires scipy setuptools matplotlib cvxopt
%py_requires pswarm_py pyipopt pywrapper toms587
%add_python_req_skip cplex

%description -n python-module-openopt
OpenOpt is a free optimization framework that was created in June of
2007. It is a relatively new project that is currently developed in the
optimization department of the Cybernetics Institute at the Ukrainian
National Academy of Sciences, in collaboration with the SciPy
development team. OpenOpt interfaces with many different algorithms for
solving optimization problems (solvers), some of which are written in C
or Fortran.

This package contains python module of OpenOpt.

%package -n python-module-openopt-tests
Summary: Tests for Python module of Numerical optimization framework
Group: Development/Python
Requires: python-module-openopt = %version-%release

%description -n python-module-openopt-tests
OpenOpt is a free optimization framework that was created in June of
2007. It is a relatively new project that is currently developed in the
optimization department of the Cybernetics Institute at the Ukrainian
National Academy of Sciences, in collaboration with the SciPy
development team. OpenOpt interfaces with many different algorithms for
solving optimization problems (solvers), some of which are written in C
or Fortran.

This package contains tests for python module of OpenOpt.

%package -n python-module-openopt-examples
Summary: Examples for Python module of Numerical optimization framework
Group: Development/Python
Requires: python-module-openopt = %version-%release

%description -n python-module-openopt-examples
OpenOpt is a free optimization framework that was created in June of
2007. It is a relatively new project that is currently developed in the
optimization department of the Cybernetics Institute at the Ukrainian
National Academy of Sciences, in collaboration with the SciPy
development team. OpenOpt interfaces with many different algorithms for
solving optimization problems (solvers), some of which are written in C
or Fortran.

This package contains examples for python module of OpenOpt.

%package -n python-module-DerApproximator
Summary: A python module for finite-differences derivatives approximation
Group: Development/Python
%setup_python_module DerApproximator

%description -n python-module-DerApproximator
DerApproximator - tool to get (or check user-supplied) derivatives via
finite-difference approximation.

%package -n python-module-DerApproximator-tests
Summary: Tests for python module for finite-differences derivatives approximation
Group: Development/Python
Requires: python-module-DerApproximator = %version-%release

%description -n python-module-DerApproximator-tests
DerApproximator - tool to get (or check user-supplied) derivatives via
finite-difference approximation.

This package contains tests for DerApproximator.

%package -n python-module-FuncDesigner
Summary: A python module for function design and automatic derivatives
Group: Development/Python
%setup_python_module FuncDesigner

%description -n python-module-FuncDesigner
FuncDesigner - tool to rapidly build functions and get their derivatives
via automatic differentiation. Also, you can solve/optimize problems
coded in FuncDesigner by OpenOpt.

%package -n python-module-FuncDesigner-tests
Summary: Tests for python module for function design and automatic derivatives
Group: Development/Python
Requires: python-module-FuncDesigner = %version-%release

%description -n python-module-FuncDesigner-tests
FuncDesigner - tool to rapidly build functions and get their derivatives
via automatic differentiation. Also, you can solve/optimize problems
coded in FuncDesigner by OpenOpt.

This package contains tests for FuncDesigner.

%package -n python-module-FuncDesigner-examples
Summary: Examples for python module for function design and automatic derivatives
Group: Development/Python
Requires: python-module-FuncDesigner = %version-%release

%description -n python-module-FuncDesigner-examples
FuncDesigner - tool to rapidly build functions and get their derivatives
via automatic differentiation. Also, you can solve/optimize problems
coded in FuncDesigner by OpenOpt.

This package contains examples for FuncDesigner.

%package -n python-module-SpaceFuncs
Summary: Python module for 2D, 3D, ND space objects modelling and optimization
Group: Development/Python
%setup_python_module SpaceFuncs

%description -n python-module-SpaceFuncs
SpaceFuncs is a completely free Python language module for 2D, 3D,
N-dimensional space calculations with abilities of

  * parametrized modeling (using FuncDesigner)
  * performing numerical optimization and solving geometrical systems of
    equations (possibly parametrized), using FuncDesigner automatic
    differentiation, that yields more precise (and very often faster)
    results than finite-differences derivatives approximation
  * some graphic output

%package -n python-module-SpaceFuncs-examples
Summary: Examples for SpaceFuncs
Group: Development/Python
Requires: python-module-SpaceFuncs = %version-%release

%description -n python-module-SpaceFuncs-examples
SpaceFuncs is a completely free Python language module for 2D, 3D,
N-dimensional space calculations with abilities of

  * parametrized modeling (using FuncDesigner)
  * performing numerical optimization and solving geometrical systems of
    equations (possibly parametrized), using FuncDesigner automatic
    differentiation, that yields more precise (and very often faster)
    results than finite-differences derivatives approximation
  * some graphic output

This package contains examples for SpaceFuncs.

%prep
%setup

%build
f2py --opt="%optflags" --f90exec=="f95" \
	-m toms587 \
	-c OpenOpt/openopt/solvers/Standalone/toms587.f \
	-lopenblas
export PYTHONPATH=$PWD
for dir in %dirs; do
	pushd $dir
	%python_build_debug -v
	popd
done

%install
for dir in %dirs; do
	pushd $dir
	%python_install
	popd
done

install -d  %buildroot%python_sitelibdir
install -m644 toms587.so %buildroot%python_sitelibdir

%ifarch x86_64
mv %buildroot%python_sitelibdir_noarch/DerApproximator* \
	%buildroot%python_sitelibdir/
mv %buildroot%python_sitelibdir_noarch/FuncDesigner* \
	%buildroot%python_sitelibdir/
mv %buildroot%python_sitelibdir_noarch/SpaceFuncs* \
	%buildroot%python_sitelibdir/
mv %buildroot%python_sitelibdir_noarch/kernel* \
	%buildroot%python_sitelibdir/
mv %buildroot%python_sitelibdir_noarch/openopt* \
	%buildroot%python_sitelibdir/
%endif
cp -fR FuncDesigner/FuncDesigner/examples \
	FuncDesigner/FuncDesigner/tests \
	%buildroot%python_sitelibdir/FuncDesigner/
touch %buildroot%python_sitelibdir/FuncDesigner/examples/__init__.py
touch %buildroot%python_sitelibdir/FuncDesigner/tests/__init__.py
cp -fR DerApproximator/tests \
	%buildroot%python_sitelibdir/DerApproximator/
touch %buildroot%python_sitelibdir/DerApproximator/tests/__init__.py
cp -fR SpaceFuncs/examples \
	%buildroot%python_sitelibdir/SpaceFuncs/
touch %buildroot%python_sitelibdir/SpaceFuncs/examples/__init__.py

%files -n python-module-toms587
%doc OpenOpt/openopt/solvers/Standalone/toms587.f
%python_sitelibdir/toms587.so

%files -n python-module-openopt
%doc OpenOpt/COPYING.txt OpenOpt/README.txt
%doc OpenOpt/openopt/doc/*
%python_sitelibdir/openopt*
%exclude %python_sitelibdir/openopt/tests
%exclude %python_sitelibdir/openopt/examples

%files -n python-module-openopt-tests
%python_sitelibdir/openopt/tests

%files -n python-module-openopt-examples
%python_sitelibdir/openopt/examples

%files -n python-module-DerApproximator
%doc DerApproximator/COPYING.txt
%python_sitelibdir/DerApproximator*
%exclude %python_sitelibdir/DerApproximator/tests

%files -n python-module-DerApproximator-tests
%python_sitelibdir/DerApproximator/tests

%files -n python-module-FuncDesigner
%python_sitelibdir/FuncDesigner*
%exclude %python_sitelibdir/FuncDesigner/tests
%exclude %python_sitelibdir/FuncDesigner/examples

%files -n python-module-FuncDesigner-tests
%python_sitelibdir/FuncDesigner/tests

%files -n python-module-FuncDesigner-examples
%python_sitelibdir/FuncDesigner/examples

%files -n python-module-SpaceFuncs
%python_sitelibdir/SpaceFuncs*
%exclude %python_sitelibdir/SpaceFuncs/examples
%python_sitelibdir/kernel

%files -n python-module-SpaceFuncs-examples
%python_sitelibdir/SpaceFuncs/examples

%changelog
