Name: R-base
Version: 3.1.2
Release: alt0.M70P.1

Summary: A language for data analysis and graphics
License: GPL
Group: Sciences/Mathematics
Packager: Kirill Maslinsky <kirill@altlinux.org>

URL: http://www.r-project.org
Source: R-%version.tar
Patch: R-%version-%release.patch

# Automatically added by buildreq on Thu Mar 03 2011
BuildRequires: bzlib-devel gcc-c++ gcc-fortran libXmu-devel libjpeg-devel liblzma-devel libpango-devel libpcre-devel libpng-devel libreadline-devel libtiff-devel texlive-fonts-recommended texlive-generic-recommended texlive-xetex tk-devel zlib-devel

BuildPreReq: liblapack-devel libicu-devel

%description
R is `GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

R is designed as a true computer language with control-flow
constructions for iteration and alternation, and it allows users to
add additional functionality by defining new functions. For
computationally intensive tasks, C, C++ and Fortran code can be
linked and called at run time.

S is the statistician's Matlab and R is to S what Octave is to Matlab.

%prep
%setup -q -n R-%version
%patch -p1
rm src/extra/{zlib,bzip2,pcre}/*.[ch]
rm src/extra/xz/*/*.[ch]
rm src/extra/blas/*.f src/modules/lapack/*.f

%build
%define verid %(v=%version; IFS=.; set $v; echo "$1.$2")
%define Rhome %_libdir/R
%define Rbindir %Rhome/bin
%define Rdocdir %_docdir/R-%verid
export	lt_cv_prog_cc_static_works=no \
	ac_cv_path_R_ZIPCMD=zip ac_cv_path_R_UNZIPCMD=unzip \
	ac_cv_path_R_BROWSER=firefox ac_cv_path_R_PDFVIEWER=evince \
	ac_cv_path_PAGER='less -isR' ac_cv_prog_R_PRINTCMD=lpr
%add_optflags -fno-strict-aliasing
%configure \
	--enable-prebuilt-html \
	--enable-R-shlib --with-x \
	--with-system-{zlib,bzlib,pcre,xz} \
	--with-blas=openblas --with-lapack=lapack \
	--with-tcl-config=%_libdir/tclConfig.sh --with-tk-config=%_libdir/tkConfig.sh \
	--libdir='${prefix}/%_lib' rincludedir='${prefix}/include/R' \
	rdocdir='${prefix}/share/doc/R-%verid'

%make_build
%make_build pdf info

%install
%makeinstall_std install-pdf install-info

mv %buildroot{%Rhome/lib,%_libdir}/libR.so

# make compatibility symlink and provides
ln -s libR.so %buildroot%_libdir/libR-2.11.so
%filter_from_provides /^libR\.so/{p;s/R/R-2.11/}

ln -s `relative %Rdocdir %Rhome/doc` %buildroot%Rhome/doc
ln -s `relative %_includedir/R %Rhome/include` %buildroot%Rhome/include

cmp %buildroot%_bindir/R %buildroot%Rhome/bin/R
ln -snfv `relative %Rhome/bin/R %_bindir/R` %buildroot%_bindir/R
cmp %buildroot%_bindir/Rscript %buildroot%Rhome/bin/Rscript
ln -snfv `relative %Rhome/bin/Rscript %_bindir/Rscript` %buildroot%_bindir/Rscript

fgrep -r %buildroot %buildroot && exit 1

mkdir -p %buildroot/etc/R
mv %buildroot%Rhome/etc/* %buildroot/etc/R/
rmdir %buildroot%Rhome/etc
ln -s `relative /etc/R %Rhome/etc` %buildroot%Rhome/etc

# libR is relocated, nuke LD_LIBRARY_PATH
[ -f %buildroot/etc/R/ldpaths ]
: >%buildroot/etc/R/ldpaths

mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=R
Comment=R - a language for statistical computing
Icon=R
Exec=R
Terminal=true
Categories=Science;Math;
EOF

# use system libtool
[ -f %buildroot%Rhome/bin/libtool ]
ln -snfv `relative %_bindir/libtool %Rhome/bin/libtool` %buildroot%Rhome/bin/libtool

%define _perl_lib_path %Rhome/share/perl
%add_findprov_skiplist %Rhome/share/perl/*.pl

rm -fv %buildroot%_infodir/dir*

%check
export TZ="GMT"
# don't test for i586 (unstable version)
%ifarch x86_64
make check
%endif

%files
	%doc doc/NEWS README
	%_bindir/R
	%_bindir/Rscript
	%_man1dir/R.*
	%_man1dir/Rscript.*
	%_libdir/libR.so
	%_libdir/libR-2.11.so
	%_desktopdir/%name.desktop

%dir	%Rhome

%dir	%Rbindir
	%Rbindir/R
	%Rbindir/Rscript

	%Rbindir/BATCH
	%Rbindir/Rcmd
	%Rbindir/Rd2pdf
	%Rbindir/Rdconv
	%Rbindir/Rprof
	%Rbindir/pager
	%Rbindir/Stangle
	%Rbindir/Sweave
	%Rbindir/javareconf
	%Rbindir/rtags

%dir	%Rbindir/exec
	%Rbindir/exec/R

%dir	/etc/R
%config(noreplace) /etc/R/*
	%Rhome/etc

%define R_library_path %Rhome/library
%dir	%R_library_path

%define R_library() \
%dir	%R_library_path/%1 \
	%R_library_path/%1/* \
%doc	%R_library_path/%1/html

# avoid dependency on R-devel
%add_findreq_skiplist %R_library_path/*/include/*.h

# Priority: base
	%R_library base
	%R_library datasets
	%R_library grDevices
	%R_library graphics
	%R_library grid
	%R_library methods
	%R_library splines
	%R_library stats
	%R_library stats4
	%R_library tools
	%R_library utils
	%R_library compiler
# Priority: recommended
	%R_library KernSmooth
	%R_library MASS
	%R_library Matrix
	%R_library boot
	%R_library class
	%R_library cluster
	%R_library codetools
	%R_library foreign
	%R_library lattice
	%R_library mgcv
	%R_library nlme
	%R_library nnet
	%R_library rpart
	%R_library spatial
	%R_library survival
	%R_library parallel

%dir	%Rhome/modules
	%Rhome/modules/*.so*
%dir	%Rhome/share
	%Rhome/share/*

%dir	%Rdocdir
%doc	%Rdocdir/[A-Z]*
%exclude %Rdocdir/COPYING*
	%Rhome/doc

%package -n R-devel
Summary: Development files for the R Statistical Environment
Group: Development/Other
PreReq: R-base = %version-%release

%description -n R-devel
R is `GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

%files -n R-devel
%dir	%Rbindir
	%Rbindir/COMPILE
	%Rbindir/INSTALL
	%Rbindir/LINK
	%Rbindir/REMOVE
	%Rbindir/Rdiff
	%Rbindir/SHLIB
	%Rbindir/build
	%Rbindir/check
	%Rbindir/config
	%Rbindir/f77_f2c
	%Rbindir/libtool
	%Rbindir/mkinstalldirs

%dir	%_includedir/R
	%_includedir/R/*.h
%dir	%_includedir/R/R_ext
	%_includedir/R/R_ext/*.h
	%Rhome/include

%dir	%Rhome
%dir	%Rhome/lib

	%_pkgconfigdir/libR.pc

%package -n R-tcltk
Summary: Tcl/Tk Interface for the R Statistical Environment
Group: Sciences/Mathematics
Requires: R-base = %version-%release

%description -n R-tcltk
R is `GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

This package provides access to the platform-independent Tcl scripting
language and Tk GUI elements.

%files -n R-tcltk
%add_tcl_lib_path %R_library_path/tcltk
%dir	%R_library_path
	%R_library tcltk

%package -n R-doc-html
Summary: HTML manuals for the R Statistical Environment
Group: Sciences/Mathematics
Requires: R-base = %version-%release
BuildArch: noarch

%description -n R-doc-html
R is `GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

%files -n R-doc-html
%dir	%Rdocdir
%dir	%Rdocdir/html/
%doc	%Rdocdir/html/*
%dir	%Rdocdir/manual/
%doc	%Rdocdir/manual/*.html

%package -n R-doc-pdf
Summary: PDF manuals for the R Statistical Environment
Group: Sciences/Mathematics
Conflicts: R-base > %version, R-base < %version
BuildArch: noarch

%description -n R-doc-pdf
R is `GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

%files -n R-doc-pdf
%dir	%Rdocdir
%dir	%Rdocdir/manual/
%doc	%Rdocdir/manual/*.pdf

%package -n R-doc-info
Summary: Info manuals for the R Statistical Environment
Group: Sciences/Mathematics
Conflicts: R-base > %version, R-base < %version
BuildArch: noarch

%description -n R-doc-info
R is `GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

%files -n R-doc-info
%_infodir/R-*.info*

%changelog
