Name: SPICE
Version: 0.12.2
Release: alt1
Summary: Implements the SPICE protocol
Group: Graphical desktop/Other
License: LGPLv2+
Url: http://www.spice-space.org/

Source: http://www.spice-space.org/download/releases/%name-%version.tar
Source2: spice-common.tar
Source3: spice-protocol.tar
Patch1: fix-alt.patch

# https://bugzilla.redhat.com/show_bug.cgi?id=613529
ExclusiveArch: %ix86 x86_64 armh

BuildRequires: cegui06-devel gcc-c++ 
BuildRequires: libXfixes-devel libXrandr-devel libXext-devel libX11-devel libXinerama-devel
BuildRequires: libalsa-devel libcelt051-devel libjpeg-devel libpixman-devel zlib-devel
BuildRequires: libssl-devel libsasl2-devel python-module-pyparsing
BuildRequires: libcacard-devel >= 0.1.2
BuildRequires: glib2-devel >= 2.22

%description
The Simple Protocol for Independent Computing Environments (SPICE) is
a remote display system built for virtual environments which allows
you to view a computing 'desktop' environment not only on the machine
where it is running, but from anywhere on the Internet and from a wide
variety of machine architectures.

%package -n spice-client
Summary: Implements the client side of the SPICE protocol
Group: Graphical desktop/Other

%description -n spice-client
The Simple Protocol for Independent Computing Environments (SPICE) is
a remote display system built for virtual environments which allows
you to view a computing 'desktop' environment not only on the machine
where it is running, but from anywhere on the Internet and from a wide
variety of machine architectures.

This package contains the SPICE client application.

%package -n libspice-server
Summary: Implements the server side of the SPICE protocol
Group: System/Libraries

%description -n libspice-server
The Simple Protocol for Independent Computing Environments (SPICE) is
a remote display system built for virtual environments which allows
you to view a computing 'desktop' environment not only on the machine
where it is running, but from anywhere on the Internet and from a wide
variety of machine architectures.

This package contains the run-time libraries for any application that wishes
to be a SPICE server.

%package -n libspice-server-devel
Summary: Header files, libraries and development documentation for spice-server
Group: Development/C
Requires: libspice-server = %version-%release

%description -n libspice-server-devel
This package contains the header files, static libraries and development
documentation for spice-server. If you like to develop programs
using spice-server, you will need to install spice-server-devel.

%prep
%setup
tar -xf %SOURCE2 
tar -xf %SOURCE3 -C spice-common
%patch1 -p1
# version in .tarball-version file
echo "%version" > .tarball-version

%build
rm -f GITVERSION
%autoreconf
%configure			\
	--enable-client		\
	--enable-gui		\
	--enable-smartcard	\
	--enable-static=no	\
	--with-sasl

%make_build

%install
%make_install install DESTDIR=%buildroot
rm -f %buildroot%_libdir/libspice-server.a
rm -f %buildroot%_libdir/libspice-server.la

%files -n spice-client
%doc COPYING README NEWS
%_bindir/spicec


%files -n libspice-server
%doc COPYING README NEWS
%_libdir/libspice-server.so.*

%files -n libspice-server-devel
%_includedir/spice-server
%_libdir/libspice-server.so
%_pkgconfigdir/spice-server.pc

%changelog
