Name: SimplePAMApps
Version: 0.60
Release: alt33

%def_with login
%def_with su

Summary: Simple PAM-based Applications
License: BSD or GPL
Group: System/Base
Url: http://www.linux-pam.org/pre/applications/

# http://www.linux-pam.org/pre/applications/%name-%version.tar.bz2
Source0: %name-0.60.tar
Source1: login.pamd
Source2: su.pamd
Source3: su.control

Patch1: %name-0.60-owl-alt-login.patch
Patch2: %name-0.60-owl-alt-su.patch
Patch3: %name-0.60-owl-alt-login-su-ut_id.patch
Patch4: %name-0.60-alt-login-su-ut_user.patch
Patch5: %name-0.60-alt-login-su-env.patch
Patch6: %name-0.60-alt-login-su-strip-argv0.patch
Patch7: %name-0.60-alt-owl-warnings.patch
Patch8: %name-0.60-owl-log.patch
Patch9: %name-0.60-owl-su-pam_acct_mgmt.patch
Patch10: %name-0.60-alt-makefile-passwd.patch
Patch11: %name-0.60-alt-openpam.patch
Patch12: %name-0.60-alt-audit.patch
Patch13: %name-0.60-alt-utmp_do_close_session.patch
Patch14: %name-0.60-alt-su-make_process_killable.patch

BuildPreReq: libpam-devel libaudit-devel

%description
These are applications for use with the Linux-PAM library.
This package may include "login" and "su".

%package -n login
Summary: Start an interactive session on the system
Group: System/Base
# pam_console fixed for login lives in 0.75-alt11.
#Requires: pam >= 0.75-alt11
# pam_lastlog fixed (nowtmp option added) in 0.75-alt12.
Requires: pam >= 0.75-alt12

%description -n login
The login application opens an interactive session with a Linux
workstation.  It is one of the first applications a user interacts with,
but is generally not invoked by a normal user.  Instead some program
like mingetty(8) will invoke login.

%package -n su
Summary: Assume a user's identity
Group: System/Base
PreReq: control

%description -n su
Su invokes the preferred shell of another user.  The identity of the new
user can be specified with the username argument.  The default username
is that of the local superuser (UID=0).

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
find -type f -print0 |
	xargs -r0 fgrep -lZ PAM_DATA_QUIET -- |
	xargs -r0 sed -i s/PAM_DATA_QUIET/PAM_DATA_SILENT/ --

%build
autoheader
autoconf
touch conf/.ignore_age

%if_enabled debug
%add_optflags -DDEBUG
%endif
%configure --without-pniam --without-pwdb --with-audit
make

%install
%if_with login
install -pD -m700 pamapps/login/login %buildroot/bin/login
install -pD -m644 pamapps/login/login.1 %buildroot%_man1dir/login.1
install -pD -m600 %_sourcedir/login.pamd %buildroot%_sysconfdir/pam.d/login
%endif #with login

%if_with su
install -pD -m700 pamapps/su/su %buildroot/bin/su
install -pD -m644 pamapps/su/su.1 %buildroot%_man1dir/su.1
install -pD -m600 %_sourcedir/su.pamd %buildroot%_sysconfdir/pam.d/su
install -pD -m755 %_sourcedir/su.control %buildroot%_controldir/su
%endif #with su

%pre -n su
%pre_control su

%post -n su
%post_control -s wheelonly su

%triggerpostun -n login -- util-linux < 2.11h-alt3
f=%_sysconfdir/pam.d/login
if [ ! -f "$f" ]; then
	if [ -f "$f".rpmsave ]; then
		cp -pf "$f".rpmsave "$f"
	elif [ -f "$f".rpmnew ]; then
		cp -pf "$f".rpmnew "$f"
	fi
fi

%triggerpostun -n su -- sh-utils < 2.0.11-alt2
f=%_sysconfdir/pam.d/su
if [ ! -f "$f" ]; then
	if [ -f "$f".rpmsave ]; then
		cp -pf "$f".rpmsave "$f"
	elif [ -f "$f".rpmnew ]; then
		cp -pf "$f".rpmnew "$f"
	fi
fi

%if_with login
%files -n login
/bin/login
%_man1dir/login.*
%config(noreplace) %_sysconfdir/pam.d/login
%doc Copyright Discussions
%endif #with login

%if_with su
%files -n su
%verify(not mode,group) /bin/su
%_man1dir/su.*
%config(noreplace) %verify(not size,md5,mtime) %_sysconfdir/pam.d/su
%config %_controldir/su
%doc Copyright Discussions
%endif #with su

%changelog
