%define prerel %nil
%define _name timidity

Name: TiMidity++
Version: 2.14.0
Release: alt3%prerel

Summary: Great-sounding CPU-hungry MIDI soundfile player
License: GPLv2
Group: Sound

Url: http://timidity.sourceforge.net
Source0: http://prdownloads.sourceforge.net/timidity/%name-%version%prerel.tar.bz2
Source1: timidity.init
Source2: timidity.sysconfig
Source3: timidity.desktop
Patch0: TiMidity++-2.13.0-alt-config.patch
Patch4: TiMidity++-2.14.0-tcltk-link.patch
Packager: Michael Shigorin <mike@altlinux.org>

%define tcl_ver 8.4.0-alt1
%define tk_ver 8.4.0-alt1

Requires: timidity-instruments
Requires: tcl >= %tcl_ver, tk >= %tk_ver

# Automatically added by buildreq on Tue Feb 20 2007
BuildRequires: emacs-common esound-devel jackit-devel libXaw-devel libXaw3d-devel libalsa-devel libao-devel libflac-devel libgtk+2-devel libncurses-devel liboggflac-devel libslang2-devel libspeex-devel openmotif-devel tk-devel

BuildRequires: tcl-devel >= %tcl_ver, tk-devel >= %tk_ver
BuildRequires: libpng-devel
BuildRequires: libogg-devel libvorbis-devel

Summary(ru_RU.KOI8-R): / MIDI-
Summary(uk_UA.KOI8-U): / MIDI-̦

%description
TiMidity++ is a converter that converts some of MIDI files
(formats : Standard MIDI file (*.MID), Recomposer files (*.RCP, *.R36,
*.G18, *.G36) and Module file (*.mod)) into formatted audio file  (ex
.RIFF  WAVE). TiMidity uses Gravis Ultrasound-compatible patch files or
Soundfonts( *.sfx, *.sf2 ) to generate digital audio data from MIDI
files. The digital audio data generated by TiMidity can be stored in a
file for processing, or played in real time through an audio device. In
real time playing, TiMidity if able to show the lyric contained in KAR
file or WRD file.

%description -l ru_RU.KOI8-R
TiMidity++ --  MIDI-,   
 MIDI      wavetable 
    (patch files) --  
 Gravis Ultrasound .pat- (  
).     
timidity-instruments  timidity-eaw-patches.

%description -l uk_UA.KOI8-U
TiMidity++ --  MIDI-̦,   դ ϧ
Ц MIDI  դ   Φ wavetable 
Ħ ..  ަ (patch files) -- ͦ  
Gravis Ultrasound .pat-̦ (   ). æ
ަ    timidity-instruments 
timidity-eaw-patches.

%prep
%setup -n %name-%version%prerel
%patch0 -p1
%patch4 -p2
cp -a INSTALL INSTALL.orig

%build
%define _optlevel 3
export EXTRACFLAGS="-DUSE_NON_CONST %optflags %optflags_fastmath %optflags_notraceback"
%configure \
    --program-prefix="" \
    --enable-interface=xaw,ncurses,gtk,tcltk,emacs,slang \
    --enable-audio=default,oss,alsa,esd,vorbis,ao,jack,flac,speex \
    --with-default-output=alsa \
    --enable-server \
    --enable-alsaseq \
    --enable-network \
    --enable-spectrogram \
    --enable-wrd \
    --enable-dynamic \
    --enable-vt100 \
    --enable-spline=cubic

%make_build

%install
%makeinstall

# bonus tracks
install -pDm755 %SOURCE1 %buildroot%_initdir/%_name
install -pDm644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%_name
install -pDm644 %SOURCE3 %buildroot%_desktopdir/%_name.desktop
install -pDm644 interface/pixmaps/%_name.xpm %buildroot%_liconsdir/%_name.xpm

# default config
mkdir -p %buildroot%_sysconfdir
echo "dir %_datadir/%_name" >%buildroot%_sysconfdir/%_name.cfg

# fixups
subst 's,%buildroot,,g' %buildroot%_usr/lib/%_name/tkmidity.tcl
subst 's@/usr/local/bin/%_name@%_bindir/%_name@' interface/%_name.el
install -pDm644 interface/%_name.el %buildroot%_emacslispdir/%_name.el

%files
%_bindir/%_name
%_usr/lib/%_name
%_mandir/*/*
%_emacslispdir/%_name.el
%_desktopdir/%_name.desktop
%_liconsdir/*
%_initdir/%_name
%_sysconfdir/sysconfig/%_name
%config(noreplace) %_sysconfdir/%_name.cfg
%doc ChangeLog INSTALL.orig README
%doc doc/C/{README*,FAQ}

%changelog
