# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libICE-devel libSM-devel
# END SourceDeps(oneline)
Name:           abe
Version:        1.1
Release:        alt5_18

Summary:        Scrolling, platform-jumping, ancient pyramid exploring game
Group:          Games/Other
License:        GPL+
URL:            http://abe.sourceforge.net/
Source0:        http://downloads.sourceforge.net/abe/%{name}-%{version}.tar.gz
Source1:        %{name}.png
# Enable changing the video settings.  Sent upstream 2 Apr 2006:
# https://sourceforge.net/tracker/?func=detail&aid=1463202&group_id=70141&atid=526743
Patch0:         %{name}-1.1-settings.patch
# Fix a double free() bug.  Sent upstream 15 Mar 2011:
# https://sourceforge.net/tracker/?func=detail&aid=3214269&group_id=70141&atid=526745
Patch1:         %{name}-1.1-doublefree.patch
# Fix an incorrect printf format specifier.  Sent upstram 15 Mar 2011:
# https://sourceforge.net/tracker/?func=detail&aid=3214270&group_id=70141&atid=526745
Patch2:         %{name}-1.1-format.patch
# Add support for aarch64.  Sent upstream 25 Mar 2013:
# https://sourceforge.net/tracker/?func=detail&aid=3609029&group_id=70141&atid=526743
Patch3:         %{name}-1.1-aarch64.patch

BuildRequires:  libSDL-devel >= 1.2.3 libSDL_mixer-devel >= 1.2.3
BuildRequires:  libXmu-devel libXi-devel
BuildRequires:  desktop-file-utils
Source44: import.info

%description
A scrolling, platform-jumping, key-collecting, ancient pyramid exploring game,
vaguely in the style of similar games for the Commodore+4.

%prep
%setup -q
%patch0
%patch1
%patch2

# Fix the FSF's address
sed 's/59 Temple Place, Suite 330, Boston, MA  02111-1307/51 Franklin Street, Suite 500, Boston, MA  02110-1335/' COPYING > COPYING.new
touch -r COPYING COPYING.new
mv -f COPYING.new COPYING

%build
%configure --with-data-dir=%{_datadir}/%{name}
sed -i "s/^CFLAGS =.*/CFLAGS = ${RPM_OPT_FLAGS} \$\(SDL_CFLAGS\)/" src/Makefile
make %{?_smp_mflags}

%install
make DESTDIR=$RPM_BUILD_ROOT install

# make install does not copy the game data files.
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/%{name}
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/applications/
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/pixmaps/
cp -p -r images maps sounds $RPM_BUILD_ROOT/%{_datadir}/%{name}
install -p -m 644 %{SOURCE1} $RPM_BUILD_ROOT/%{_datadir}/pixmaps/

cat << EOF > %{name}.desktop
[Desktop Entry]
Name=Abe
Comment="Abe's Amazing Adventure"
Exec=abe
Icon=abe
Terminal=false
Type=Application
Categories=Game;ArcadeGame;
EOF

desktop-file-install --dir $RPM_BUILD_ROOT/%{_datadir}/applications/ %{name}.desktop

%files
%doc COPYING README
%{_bindir}/*
%{_datadir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png

%changelog
