%def_enable gnome
%def_without gnomevfs
%def_with gucharmap

Name: abiword
Version: 2.8.6
Release: alt1.6

Summary: Lean and fast full-featured word processor
Group: Office
License: GPL
Url: http://www.abisource.com/

Packager: Damir Shayhutdinov <damir@altlinux.ru>

Source: http://www.abisource.com/downloads/abiword/%version/source/abiword-%version.tar.gz
Source1: abiword.desktop
Source6: abiword-48.png.bz2
Source7: abiword-32.png.bz2
Source8: abiword-16.png.bz2
Source10: abiword.keys
Source11: abiword.mime

Patch: %name-2.8.6-headers.patch
Patch1: %name-2.8.6-alt-glib2-2.32.0.patch
Patch2: %name-2.8.6-alt-gcc4.6.patch
Patch3: %name-2.8.6-alt-libpng15.patch
Patch4: %name-2.8.6-alt-link-plugins.patch

#AutoReq: yes, noshell
Obsoletes: abisuite, abisuite-koi8, abisuite-cp1251, abisuite-iso8859-8
Conflicts: abiword-light

BuildPreReq: libpng-devel
BuildRequires: bzlib-devel gcc-c++ libaiksaurus-gtk-devel libenchant-devel libfribidi-devel
BuildRequires: libots-devel libreadline-devel libgtkmathview-devel librsvg-devel libwmf-devel
BuildRequires: liblink-grammar-devel >= 4.2.1 libxslt-devel
BuildRequires: libwpd9-devel libwpg-devel perl-HTML-Tree t1lib-devel
BuildRequires: libwv-devel boost-devel libdbus-glib-devel libtidy-devel libwmf-devel
%if_enabled gnome
#BuildRequires: libgnomeoffice-devel libgsf-gnome-devel libglade-devel
BuildRequires: libgnomeoffice-devel libglade-devel
%endif
%{?_with_gnomevfs:BuildRequires: gnome-vfs-devel}
%{?_with_gucharmap:BuildRequires: libgucharmap-devel}

%description
AbiWord is a cross-platform, Open Source Word Processor developed
by the people at AbiSource, Inc. and by developers from around the world.
(http://www.abisource.com)
It is a lean and fast full-featured word processor. It works on Microsoft
Windows and most Unix Systems. Features include:

   * Basic character formatting (bold, underline, italics, etc.)
   * Paragraph alignment
   * Spell-check
   * Import of Word97 and RTF documents
   * Export to RTF, Text, HTML, and LaTeX formats
   * Document Templates
   * Interactive rulers and tabs
   * Styles
   * Unlimited undo/redo
   * Multiple column control
   * Widow/orphan control
   * Find/Replace
   * Images
   and much more...

%package devel
Group: Development/C++
Summary: Headers for Abiword plugins
Requires: %name = %version-%release
Requires: libfribidi-devel >= 0.10.4

%description devel
Headers and pkgconfig support for  Abiword plugin building.

%prep
%setup -q
%patch -p1 -b .headers
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p2
%autoreconf
%build
%configure %{subst_with gnomevfs} \
	--enable-print \
	--enable-plugins \
	--enable-templates \
	--enable-clipart \
	--disable-static

%make_build

%install
%make_install DESTDIR=%buildroot install

mkdir -p $RPM_BUILD_ROOT%_datadir/mime-info
mkdir -p $RPM_BUILD_ROOT%_libdir/abiword-2.8/plugins
install -m 644 %SOURCE10 %SOURCE11  $RPM_BUILD_ROOT%_datadir/mime-info

sed -i 's/fribidi >= 0.10.4//g' %buildroot%_pkgconfigdir/abiword-2.8.pc
# (fg) Icons
mkdir -p $RPM_BUILD_ROOT%_liconsdir
mkdir -p $RPM_BUILD_ROOT%_niconsdir
mkdir -p $RPM_BUILD_ROOT%_miconsdir
mkdir -p $RPM_BUILD_ROOT%_datadir/pixmaps
bzcat %SOURCE6 > $RPM_BUILD_ROOT%_liconsdir/abiword.png
bzcat %SOURCE7 > $RPM_BUILD_ROOT%_niconsdir/abiword.png
bzcat %SOURCE8 > $RPM_BUILD_ROOT%_miconsdir/abiword.png

mv $RPM_BUILD_ROOT%_iconsdir/abiword_48.png $RPM_BUILD_ROOT%_datadir/pixmaps/

install -D %SOURCE1 %buildroot%_desktopdir/

%files
#_bindir/AbiWord-2.6
%_bindir/abiword
%dir %_libdir/abiword-2.8
%dir %_libdir/abiword-2.8/plugins
%_miconsdir/*
%_liconsdir/*
%_niconsdir/%name.png
%_datadir/pixmaps/abiword_48.png
%_datadir/abiword-2.8
%_datadir/mime-info/*
%_desktopdir/abiword.desktop
%_libdir/abiword-2.8/plugins/*.so
%_libdir/libabiword-2.8.so
%exclude %_libdir/abiword-2.8/plugins/*.la
%_man1dir/*

%files devel
%_includedir/*
%_pkgconfigdir/*

#TODO: apply %%lang tags to localized files /usr/share/abiword-2.8/strings/*.strings (5 Mb)

%changelog
