%define _localstatedir %_var
%define _libexecdir %_prefix/libexec


Name: accountsservice
Version: 0.6.30
Release: alt2
Summary: D-Bus interfaces for querying and manipulating user account information

Group: System/Base
License: GPLv3+
Url: http://www.fedoraproject.org/wiki/Features/UserAccountDialog
#VCS: git://anongit.freedesktop.org/accountsservice

Source: %name-%version.tar
Source2: %name.conf
Patch1: %name-%version-%release.patch

BuildRequires: intltool gtk-doc
BuildRequires: glib2-devel libgio-devel
BuildRequires: libpolkit-devel
BuildRequires: gobject-introspection-devel
BuildRequires: vala vala-tools
BuildRequires: libsystemd-login-devel >= 186 libsystemd-daemon-devel systemd-devel

Requires: polkit
Requires: shadow-utils
Requires: lib%name = %version-%release

%package -n lib%name
Summary: Client-side library to talk to accountservice
Group: System/Libraries

%description -n lib%name
The libaccountsservice package contains a library that can
be used by applications that want to interact with the accountsservice
daemon.

%package -n lib%name-devel
Summary: Development files for accountsservice
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
The libaccountsservice-devel package contains headers and other
files needed to build applications that use accountsservice.

%description
The accountsservice project provides a set of D-Bus interfaces for
querying and manipulating user account information and an implementation
of these interfaces, based on the useradd, usermod and userdel commands.

%package -n lib%name-gir
Summary: GObject introspection data for the accountsservice library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the accountsservice library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the accountsservice library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-devel = %version-%release lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the accountsservice library

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure \
	--disable-static \
	--enable-systemd \
	--with-systemdsystemunitdir=%_unitdir
%make_build

%install
%make DESTDIR=%buildroot install
install -m644 -p -D %SOURCE2 %buildroot%_sysconfdir/%name.conf

%find_lang accounts-service

%files -f accounts-service.lang
%doc COPYING README AUTHORS NEWS
%_sysconfdir/dbus-1/system.d/org.freedesktop.Accounts.conf
%_libexecdir/accounts-daemon
%_datadir/dbus-1/interfaces/org.freedesktop.Accounts.xml
%_datadir/dbus-1/interfaces/org.freedesktop.Accounts.User.xml
%_datadir/dbus-1/system-services/org.freedesktop.Accounts.service
%_datadir/polkit-1/actions/org.freedesktop.accounts.policy
%dir %_localstatedir/lib/AccountsService/
%dir %_localstatedir/lib/AccountsService/users
%dir %_localstatedir/lib/AccountsService/icons
%_unitdir/accounts-daemon.service
%dir %_libdir/%name
%_libdir/%name/%name.conf
%config(noreplace) %_sysconfdir/%name.conf

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_vapidir/*

%files -n lib%name-gir-devel
%_girdir/*.gir

%changelog
