Name: acpid
Version: 2.0.17
Release: alt1
Epoch: 1
Summary: ACPI kernel daemon and control utility
License: GPL
Group: System/Servers
Url: http://www.tedfelix.com/linux/acpid-netlink.html
Packager: Valery Inozemtsev <shrek@altlinux.ru>

PreReq: sysvinit-utils

Source0: %name-%version.tar.xz
Source1: %name.init
Source2: %name.service

%description
The ACPI specification defines power and system management functions
for each computer, in a generic manner.  The ACPI daemon coordinates
the management of power and system functions when ACPI kernel
support is enabled (kernel 2.3.x or later).

%package events-power
Summary: Power event config
Group: System/Servers
BuildArch: noarch
PreReq: acpid = %version
Conflicts: acpid < 2.0.8

%description events-power
Power event config for acpid

%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%make DESTDIR=%buildroot install

install -pD -m755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m644 %SOURCE2 %buildroot%systemd_unitdir/acpid.service

mkdir -p %buildroot%_sysconfdir/acpi/events
cat << __EOF__ > %buildroot%_sysconfdir/acpi/events/power
event=button/power
action=/sbin/poweroff
__EOF__

mkdir -p %buildroot%_sysconfdir/sysconfig
cat << __EOF__ > %buildroot%_sysconfdir/sysconfig/acpid
ACPID_ARGS="-n"
__EOF__

%post
if pidof %name >/dev/null 2>&1; then
	[ -f %_var/run/%name.pid ] || pidof %name > %_var/run/%name.pid
fi
%post_service %name

%preun
%preun_service %name

%files
%doc Changelog README TODO
%dir %_sysconfdir/acpi
%dir %_sysconfdir/acpi/events
%config(noreplace) %_sysconfdir/sysconfig/acpid
%_initdir/%name
%systemd_unitdir/acpid.service
%_bindir/*
%_sbindir/*
%_man8dir/*.8*

%files events-power
%config(noreplace) %_sysconfdir/acpi/events/power

%changelog
