############################################################
# AICCU - Automatic IPv6 Connectivity Client Utility
# by Jeroen Massar <jeroen@sixxs.net>
# (c) Copyright 2003-2005 SixXS
############################################################
# AICCU RPM Spec File
############################################################

Summary: AICCU - SixXS Automatic IPv6 Connectivity Client Utility
Name: aiccu
Version: 2007.01.15
Release: alt2.qa1
License: BSD
Group: System/Configuration/Networking
Url: http://www.sixxs.net/tools/aiccu

Source: http://www.sixxs.net/archive/sixxs/aiccu/unix/aiccu_20070115.tar.gz
Source2: aiccu-alt-initscript.init
Patch1: aiccu-fix-linkage-as-needed.patch
BuildRequires: libgnutls-devel

%description
This client automatically gives one IPv6 connectivity
without having to manually configure interfaces etc.
One does need a SixXS account and at least a tunnel. These
can be freely & gratis requested from the SixXS website.
For more information about SixXS check http://www.sixxs.net

%prep
%setup -q -n %name
%patch1 -p2
# fix executable permissions on non-executable content
# so debuginfo can pick them up properly
find . -type f -not -name rules -and -not -name *init* -exec chmod a-x \{\} \;

%build
%make

%install
%make_install DESTDIR=%buildroot install

mkdir -p %buildroot%_sysconfdir/sysconfig
touch %buildroot%_sysconfdir/sysconfig/%name

rm -rf %buildroot%_sysconfdir/init.d

mkdir -p %buildroot%_initdir
install -pm755 %SOURCE2 %buildroot%_initdir/%name

%post
%post_service %name

%preun
%preun_service %name

%files
%doc doc/README doc/LICENSE
%_sbindir/aiccu
# aiccu.conf contains the users's SixXS password, so don't
# make it readable by non-root
%attr(600, root,root) %config(noreplace) %_sysconfdir/aiccu.conf
%_initdir/aiccu
%attr(600, root,root) %config(noreplace) %_sysconfdir/sysconfig/%name

%changelog
