Name: alterator-bacula
Version: 1.3.2
Release: alt1

Source:%name-%version.tar

%add_findreq_skiplist %_libexecdir/alterator/backend3/bacula-restore

%define backupadmin_group backupadmin

Summary: module for Bacula backup system
License: GPL
Group: System/Configuration/Other
Requires(pre): shadow-utils
Requires: bacula-director-common >= 5.2.13-alt3
Requires: bacula-storage bacula-client bacula-dir
# require console timeout feature
Requires: bacula-console >= 3.0.2-alt6
Requires: ntfs-3g
Requires: alterator >= 4.10-alt5
Requires: alterator-l10n >= 2.7-alt19
Requires: alterator-sh-functions alterator-net-functions alterator-hw-functions >= 0.6-alt1
Requires: alterator-service-functions
Requires: passwdqc-utils
Requires: bacula-director-mysql
Requires: MySQL-server-control
Requires: mysql-server
Requires: mysql-client
Conflicts: alterator-lookout < 2.1-alt1
Conflicts: alterator-fbi < 5.20-alt1

Provides:  alterator-bacula-functions = %version-%release
Obsoletes: alterator-bacula-functions < %version-%release
Provides:  alterator-backup-server = %version-%release
Obsoletes: alterator-backup-server < %version-%release
Provides:  alterator-distro-backup-server = %version-%release
Obsoletes: alterator-distro-backup-server < %version-%release
Provides:  alterator-bacula-server = %version-%release
Obsoletes: alterator-bacula-server < %version-%release

BuildArch: noarch

BuildPreReq: alterator >= 4.10-alt5

%description
module for Bacula backup system

%pre
/usr/sbin/groupadd -r -f %backupadmin_group

%prep
%setup -q

%build
%make_build

%install
%makeinstall
%define altdir %_datadir/alterator
mkdir -p %buildroot/%altdir/{applications,desktop-directories}
install -m644 desktop-directories/*.directory %buildroot/%altdir/desktop-directories/

for n in archive settings clients schedule; do
  sed 's/X-Backup-Server/X-Alterator-Backup/' \
     applications/bacula-server-$n.desktop \
     > %buildroot/%altdir/applications/bacula-$n.desktop
done

%files
%config(noreplace) %_sysconfdir/alterator/bacula
%_datadir/alterator/ui/*
%_datadir/alterator/ui/bacula/local-backup/
%_alterator_backend3dir/*
%_alterator_backend3dir/bacula-local-backup
%_datadir/alterator/applications/*
%_datadir/alterator/applications/bacula-local-backup.desktop
%_datadir/alterator/steps/*
%_datadir/alterator/type/*
%_bindir/*
%_sbindir/*
%altdir/desktop-directories/*

%changelog
