%define _altdata_dir %_datadir/alterator

Name: alterator-fbi
Version: 5.31
Release: alt0.M70P.2

Packager: Dmitriy Kruglikov <dkr@altlinux.org>

Source:%name-%version.tar

Summary: alterator on rails
License: GPL
Group: System/Configuration/Other

#backward compatibility
Provides: alterator-http = %version, ahttpd = %version, httpd-alterator = %version, alterator-ahttpd = %version
Obsoletes: alterator-http, ahttpd, httpd-alterator, alterator-ahttpd

Requires: alterator-sh-functions >= 0.13-alt2
Requires: avahi-sh-functions >= 0.1-alt2
Requires: design-alterator
Requires: alterator >= 4.23-alt1
Requires: alterator-l10n >= 2.7-alt4
Requires: alterator-sslkey
Requires: gettext
Requires: alterator-l10n >= 0.15

Requires(pre): libguile-vhttpd >= 0.7.3-alt1
Requires(pre): shadow-utils

BuildPreReq: alterator >= 4.12-alt1, libguile-vhttpd, guile18-devel, libexpat-devel

Provides: alterator-etcgit-bar

%description
this is an alterator based engine (form based interface) to create a simple form based html interface

%prep
%setup -q

%build
%make_build
%make check-api

%install
export LD_LIBRARY_PATH=$(pwd)/src/libguile-xmltokenizer/
%makeinstall HTMLROOT=%buildroot%_var/www/ unitdir=%buildroot%_unitdir

#ahttpd
%__install -d %buildroot%_var/run/ahttpd
%__install -d %buildroot%_logdir/ahttpd
%__install -Dpm640 ahttpd.logrotate %buildroot/%_sysconfdir/logrotate.d/ahttpd
%__install -Dpm644 ahttpd.conf %buildroot%_sysconfdir/ahttpd/ahttpd.conf
%__install -Dpm644 acl.conf %buildroot%_sysconfdir/ahttpd/acl.conf
%__install -Dpm755 ahttpd.init %buildroot/%_initrddir/ahttpd
%__install -d %buildroot/%_cachedir/ahttpd

#ssl
touch %buildroot%_sysconfdir/ahttpd/ahttpd.cnf
mkdir -p %buildroot/%_localstatedir/ssl/certs/
touch %buildroot/%_localstatedir/ssl/certs/ahttpd.csr

#compatibility:begin
touch %buildroot/%_datadir/alterator/build/html-messages.mak
#compatibility:end

%pre
/usr/sbin/groupadd -r -f _ahttpd
/usr/sbin/groupadd -r -f _alteratord
/usr/sbin/useradd -r -g _ahttpd -G _alteratord -d /dev/null -s /dev/null -n _ahttpd >/dev/null 2>&1 ||:

%post
%post_service ahttpd

%preun
%preun_service ahttpd

%triggerin -- httpd-alterator
if /sbin/service httpd-alterator status >/dev/null 2>/dev/null; then
    /sbin/service httpd-alterator stop
    /sbin/service ahttpd start
fi ||:
/sbin/service configd stop
/sbin/chkconfig configd --del
/usr/sbin/usermod  -G _alteratord _ahttpd >/dev/null 2>&1 ||:

%triggerin -- ahttpd
/sbin/service configd stop
/sbin/chkconfig configd --del
/usr/sbin/usermod  -G _alteratord _ahttpd >/dev/null 2>&1 ||:

%triggerpostun -- ahttpd
/sbin/chkconfig ahttpd --add
/sbin/chkconfig ahttpd on
/sbin/service ahttpd start


%files
#common
%_bindir/*
%_libdir/*.so*
%_libexecdir/alterator/backend3/*
%_datadir/alterator/build/*
%_datadir/alterator/design/images/*
%_datadir/alterator/design/scripts/*
%_datadir/alterator/design/styles/*
%_datadir/alterator/ui/*
%_datadir/alterator/type/*
%_datadir/alterator/interfaces/*/*
%_datadir/alterator/applications/*

#server
%config(noreplace) %_sysconfdir/logrotate.d/*
%_initdir/*
%_sbindir/*
%_man5dir/*
%_man8dir/*
%_var/run/ahttpd
%attr(750,root,adm) %_logdir/ahttpd
%attr(700,_ahttpd,root) %dir %_sysconfdir/ahttpd
%attr(700,_ahttpd,root) %dir %_sysconfdir/ahttpd
%config(noreplace) %_sysconfdir/ahttpd/ahttpd.conf
%config(noreplace) %_sysconfdir/ahttpd/acl.conf
%attr(750,_ahttpd,root) %_cachedir/ahttpd
%_unitdir/ahttpd.service
%_unitdir/ahttpd.socket

#ssl
%ghost  %config(noreplace) %_sysconfdir/ahttpd/ahttpd.cnf
%ghost  %_localstatedir/ssl/certs/ahttpd.csr


%changelog
