%define _altdata_dir %_datadir/alterator

Name: alterator-standalone
Version: 7.1.1
Release: alt2

Packager: Stanislav Ievlev <inger@altlinux.org>

Source:%name-%version.tar

Summary: System Management center
License: GPL
Group: System/Configuration/Other
BuildArch: noarch
Requires: alterator >= 4.7-alt4
Requires: alterator-l10n
Requires: alterator-lookout >= 2.1-alt3
Requires: alterator-browser-qt >= 2.11.6-alt1

Requires: consolehelper

#backward compatibility
Provides: acc = %version, alterator-profile = %version, %name-usermode = %version
Obsoletes: acc, alterator-profile, %name-usermode

BuildPreReq: alterator >= 4.7-alt4

%description
ALTLinux Control Center
Contains engine for system management

%prep
%setup

%build
%make_build

%install
%makeinstall

#install consolehelper
for obj in acc alterator-standalone;
do
install -d %buildroot/%_bindir
ln -s %_libexecdir/consolehelper/helper %buildroot%_bindir/$obj
install -d %buildroot%_sysconfdir/pam.d/

cat>%buildroot%_sysconfdir/pam.d/$obj<<EOF
#%PAM-1.0
auth	sufficient	pam_rootok.so
auth	required	pam_stack.so service=system-auth
account	required	pam_permit.so
password	required	pam_deny.so
session	optional	pam_xauth.so
EOF

install -d %buildroot%_sysconfdir/security/console.apps/
cat>%buildroot%_sysconfdir/security/console.apps/$obj<<EOF
USER=root
PROGRAM=%_sbindir/$obj
SESSION=true
FALLBACK=true
EOF
done

install -Dpm644 acc.desktop %buildroot/%_desktopdir/acc.desktop

%files
%_sbindir/*
%_altdata_dir/ui/*/
%_desktopdir/*
%_man8dir/*
%config(noreplace) %_sysconfdir/pam.d/*
%config(noreplace) %_sysconfdir/security/console.apps/*
%_bindir/*

%changelog
