%define ver_major 3.8
%def_enable glade
%def_enable vala
%def_enable gtk_doc

Name: anjuta
Version: %ver_major.2
Release: alt2.M70P.1
Summary: GNOME IDE for C and C++
Group: Development/GNOME and GTK+
License: GPLv2+
Url: http://anjuta.org/

Requires: autogen >= 5.0 libgda4-sqlite
Obsoletes: %{name}2 < %version lib%name libgnome-build <= 2.26
Obsoletes: %{name}2-docs < %version %{name}2-core < %version %{name}2-project-templates < %version
Provides: %{name}2 = %version-%release lib%name
Provides: %{name}2-docs = %version-%release %{name}2-core = %version-%release %{name}2-project-templates = %version-%release

Source: %name-%version.tar
# Patch: %name-%version-%release.patch

BuildRequires: dconf flex gcc-c++ autogen gnome-common gtk-doc intltool yelp-tools itstool
BuildRequires: gobject-introspection-devel >= 0.6.7
BuildRequires: libgjs-devel
BuildRequires: glib2-devel >= 2.32.0 libgio-devel
BuildRequires: libgtk+3-devel >= 3.4.0 libgtk+3-gir-devel
BuildRequires: libgdk-pixbuf-devel >= 2.0.0 libgdk-pixbuf-gir-devel
BuildRequires: libxml2-devel >= 2.4.23
BuildRequires: libwebkit2gtk-devel
BuildRequires: libgdl3-devel >= 3.5.5
BuildRequires: libvte3-devel >= 0.27.6
BuildRequires: libdevhelp-devel >= 3.7.4
%{?_enable_glade:BuildRequires: libgladeui2.0-devel >= 3.12.0}
BuildRequires: libgtksourceview3-devel >= 3.0.0
%{?_enable_vala:BuildRequires: libvala-devel vala}
BuildRequires: python-devel python-modules-compiler
BuildRequires: libgda4-devel >= 4.2.0 libsqlite3-devel
BuildRequires: libXrender-devel libXext-devel
BuildRequires: libgraphviz-devel
BuildRequires: perl-devel perl-Locale-gettext

%description
Anjuta DevStudio is a versatile Integrated Development Environment (IDE)
for GNOME Desktop Environment. It features a number of advanced
programming facilities. These include project management, application and
class wizards, an on-board interactive debugger, a powerful source editor,
syntax highlighting, Intellisense-like autocompletion, symbol navigation,
integration with version control systems and a GUI designer, and other
tools.

%package devel
Summary: Development files for Anjuta
Group: Development/Other
Requires: %name = %version-%release
Obsoletes: %{name}2-devel-doc < %version
Obsoletes: %{name}2-devel < %version
Provides: %{name}2-devel-doc
Provides: %{name}2-devel

%description devel
Libraries and header files necessary to develop and build Anjuta plugins.

%package cvs
Summary: CVS support in Anjuta
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Requires: cvs
Obsoletes: %{name}2-cvs < %version
Provides: %{name}2-cvs

%description cvs
CVS support plugin for Anjuta DevStudio IDE.

%package glade
Summary: Glade support in Anjuta
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Obsoletes: %{name}2-glade < %version
Provides: %{name}2-glade

%description glade
Valgrind support plugin for Anjuta DevStudio IDE.

%package devhelp
Summary: DevHelp integration plugin for Anjuta
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Obsoletes: %{name}2-devhelp < %version
Provides: %{name}2-devhelp

%description devhelp
This plugin lets you run DevHelp from inside Anjuta.

%define schemasdir %_datadir/glib-2.0/schemas
%define anjuta_libdir %_libdir/%name
%define anjuta_datadir %_datadir/%name
%define anjuta_pixmapsdir %_pixmapsdir/%name

%add_findprov_lib_path %anjuta_libdir
%add_findreq_skiplist %anjuta_datadir/templates/python/src/*.py
%add_findreq_skiplist %anjuta_datadir/templates/pygtk/src/*.py

%prep
%setup -q
# %patch -p1

%build
NOCONFIGURE=1 ./autogen.sh
%configure \
    --disable-static \
    --disable-rpath \
    --disable-silent-rules \
    --disable-schemas-compile \
    %{subst_enable vala} \
    --disable-packagekit \
    --enable-plugin-devhelp \
%if_enabled glade
    --enable-plugin-glade \
    --enable-glade-catalog \
%else
    --disable-plugin-glade \
%endif
    --disable-plugin-subversion \
    %{?_enable_gtk_doc:--enable-gtk-doc}
    
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang --with-gnome --output=global.lang %name %name-manual %name-build-tutorial %name-faqs

%files -f global.lang
%doc AUTHORS NEWS README THANKS TODO FUTURE ROADMAP doc/ScintillaDoc.html
%_bindir/*
%_libdir/*.so.*
%_typelibdir/*.typelib
%anjuta_libdir/
%exclude %anjuta_libdir/*.la
%exclude %anjuta_libdir/*cvs*
%if_enabled glade
%exclude %anjuta_libdir/*glade*
%endif
%exclude %anjuta_libdir/*devhelp*

%dir %anjuta_datadir
%anjuta_datadir/welcome.txt
%anjuta_datadir/layout.xml
%anjuta_datadir/languages.xml
%anjuta_datadir/snippets-global-variables.xml
%anjuta_datadir/snippets.anjuta-snippets
%anjuta_datadir/sources.list
%anjuta_datadir/class-templates
%anjuta_datadir/templates
%anjuta_datadir/build
%anjuta_datadir/profiles
%anjuta_datadir/gdb.init
%anjuta_datadir/tables.sql

%dir %anjuta_datadir/glade
%anjuta_datadir/glade/*.png
%anjuta_datadir/glade/*.ui
%exclude %anjuta_datadir/glade/*cvs*.ui

%anjuta_datadir/tools

%dir %anjuta_datadir/ui
%anjuta_datadir/ui/*.ui
%anjuta_datadir/ui/*.xml
%exclude %anjuta_datadir/ui/*cvs*.ui
%exclude %anjuta_datadir/ui/*devhelp*.ui

%anjuta_datadir/anjuta_project.template

%schemasdir/org.gnome.anjuta*gschema.xml
%exclude %schemasdir/org.gnome.anjuta.cvs.gschema.xml

%_iconsdir/hicolor/*/apps/anjuta.*
%_iconsdir/gnome/*/*/*
%anjuta_pixmapsdir/
%exclude %anjuta_pixmapsdir/*cvs*
%exclude %anjuta_pixmapsdir/*glade*
%exclude %anjuta_pixmapsdir/*devhelp*

%_desktopdir/%name.desktop
%_datadir/mime/packages/*

%_man1dir/*

%files devel
%_includedir/libanjuta*
%_libdir/*.so
%_girdir/*.gir
%_pkgconfigdir/*.pc
%{?_enable_gtk_doc:%_datadir/gtk-doc/html/lib%name}

%files cvs
%anjuta_libdir/*cvs*
%exclude %anjuta_libdir/lib*.la
%anjuta_datadir/ui/*cvs*.ui
%anjuta_datadir/glade/*cvs*.ui
%schemasdir/org.gnome.anjuta.cvs.gschema.xml
%anjuta_pixmapsdir/*cvs*

%if_enabled glade
%files glade
%anjuta_libdir/*glade*
%exclude %anjuta_libdir/lib*.la
%_libdir/glade/modules/libgladeanjuta.so
%_datadir/glade/catalogs/anjuta-glade.xml
%exclude %_libdir/glade/modules/*.la
%anjuta_pixmapsdir/*glade*
%endif

%files devhelp
%anjuta_libdir/*devhelp*
%_pixmapsdir/%name/*devhelp*
%exclude %anjuta_libdir/lib*.la
%exclude %anjuta_pixmapsdir/*devhelp*

%changelog
