Name: ansible
Summary: SSH-based configuration management, deployment, and task execution system
Version: 1.9.2
Release: alt0.M70P.1

Group: System/Libraries
License: GPLv3
Source0: %name-%version.tar
Source1: %name-modules-core-%version.tar
Source2: %name-modules-extras-%version.tar

Patch0:%name-%version-alt.patch
Patch1: %name-modules-core-%version-alt.patch

Url: http://www.ansible.com

Packager: Evgenii Terechkov <evg@altlinux.org>

BuildArch: noarch
BuildRequires: python-module-setuptools

# Skip findreq on all modules:
%add_findreq_skiplist %python_sitelibdir/%name/modules/*

%description
Ansible is a radically simple model-driven configuration management,
multi-node deployment, and remote task execution system. Ansible works
over SSH and does not require any software or daemons to be installed
on remote nodes. Extension modules can be written in any language and
are transferred to managed machines automatically.

%prep
%setup
%patch0 -p1
tar -xvf %SOURCE1               # creates ./library/...
tar -xvf %SOURCE2
pushd library
%patch1 -p1
popd

%build
%python_build

%install
%python_install
mkdir -p %buildroot%_sysconfdir/%name/
cp examples/ansible.cfg %buildroot%_sysconfdir/%name/
touch %buildroot%_sysconfdir/%name/hosts
mkdir -p %buildroot/%_man1dir
cp -v docs/man/man1/*.1 %buildroot/%_man1dir/
rm -f library/{VERSION,README.md,COPYING,CONTRIBUTING.md}
cp -va library/* %buildroot%python_sitelibdir/%name/modules

%files
%_bindir/%{name}*
%config(noreplace) %_sysconfdir/%name
%_man1dir/%{name}*
%python_sitelibdir/%{name}*
%doc examples/playbooks examples/scripts examples/hosts
%doc README.md CONTRIBUTING.md CHANGELOG.md RELEASES.txt CODING_GUIDELINES.md ISSUE_TEMPLATE.md

%changelog
