# hey Emacs, its -*- rpm-spec -*-
# you can build --with/--without:
# - mod_deflate [with]

# %%branch_switch set %%branch_release use
#%%define branch_switch Mxx

%define russian_patchlevel PL30.24
%define apache_vanilla_version 1.3.42
%define apache_version %{apache_vanilla_version}rus%russian_patchlevel
%define apache_release %release
%define mod_realip_version 2.0
%define mod_perl_version 1.29
%define mod_perl_version_pad %{mod_perl_version}00
%define mod_perl_doc_version %{mod_perl_version}_%apache_version
%define mod_deflate_version 1.0.21
%define mod_accel_version 1.0.34
%define EAPI_version 2.8.30a
%define mm_version 1.1.3
# EAPI tarball is subset of mod_ssl tarball

# default is 256
%define apache_hard_server_limit 1024

%define old_apache_home /home/httpd
%define suexec_docroot %apache_datadir

%def_with mod_deflate

Name: apache
Version: %apache_version
Release: %branch_release alt5

Summary: The most widely used Web server on the Internet
License: %asl
Group: System/Servers

Url: http://httpd.apache.org
Packager: Michael Shigorin <mike@altlinux.org>

Requires: %name-base = %version-%release
Requires: webserver-cgi-bin
Requires: webserver-html
Requires: webserver-icons

# http://httpd.apache.org/dist/httpd/apache_%apache_vanilla_version.tar.gz
# ftp://apache.lexa.ru/pub/apache-rus/patches_%apache_version.tar.gz
Source0: apache_%apache_version.tar
Source4: apache.logrotate
Source5: httpd.conf
# update EAPI by hand from mod_ssl source tarball
Source9: EAPI-%EAPI_version.tar.bz2
Source12: http://sysoev.ru/mod_deflate/mod_deflate-%mod_deflate_version.tar.gz
Source13: mod_perl-%mod_perl_version.tar.bz2
Source14: mod_realip-%mod_realip_version.tar.gz
Source15: httpd-perl.conf
Source16: proxied_handlers.pl
Source17: http://sysoev.ru/mod_accel/mod_accel-%mod_accel_version.tar.gz
Source23: apache-mime.types
#Source24: logo.gif
Source26: Vhosts.conf
Source27: Vhosts-perl.conf
Source28: sgi_performance.gif
Source29: ra-powered.gif

Source30: altlinux.html

# initscripts for current Sisyphus
Source35: httpd.init
Source36: httpd-perl.init

# scripts for control
Source40: cgi-bin_test-cgi.sh
Source41: cgi-bin_printenv.sh

Source50: DynamicVhosts.conf
Source51: VirtualHomePages.conf
Source52: README.apache
Source53: apache-mod_charset.conf
Source54: apache-mod_realip.conf

# rpm macro definitions
Source61: apache-README.ALT
Source62: 00-example.conf
Source63: TUNING.ALT
Source64: apache.monit

# scripts for condstopstart-web
Source70: server-condstop.sh
Source72: server-condstart.sh

Patch1: apache-1.3.41rusPL30.23-alt-manual-0.1.patch
Patch2: apache-1.3.41rusPL30.23-alt-fix-getline-0.1.patch
Patch3: apache-1.3.31-apxs.patch
Patch4: apache_1.3.27-srvroot.patch
Patch5: apache_1.3.23-nondbm.patch

Patch8: apache-1.3.23-alt-db4.patch
Patch10: apache-1.3.31-acl-support.patch

Patch75: apache-1.3.27-openbsd-tmp.patch
Patch76: apache-1.3.34-alt-linkage.patch

Patch77: apache-1.3.41-unloop-rewrite.patch

Patch80: uneapi.patch
# Expat patch
Patch94: apache-1.3.33-fix-htpasswd-buffer.patch
Patch97: mod_perl-1.29-CVE-2007-1349.patch

# https://rt.cpan.org/Public/Bug/Display.html?id=64999
Patch98: mp1+perl5.14.diff
Patch99: mod_perl-perl-5.16.patch

BuildRequires(pre): rpm-macros-branch
BuildRequires(pre): rpm-macros-apache
BuildRequires(pre): rpm-macros-condstopstart
BuildPreReq: %_datadir/rpm-build-rpm-eval/rpm-eval.sh
BuildPreReq: rpm-macros-webserver-cgi-bin-control
BuildPreReq: rpm-build-licenses

# Automatically added by buildreq on Thu Oct 13 2011 (-bi)
BuildRequires: libdb4-devel libgdbm-devel libmm-devel perl-BSD-Resource perl-CGI perl-DBM perl-Devel-Symdump perl-devel perl-libwww perl-Pod-Simple

%if_with mod_deflate
BuildRequires: zlib-devel
%endif

BuildConflicts: bind-devel

Summary(ru_RU.KOI8-R):   - Internet
Summary(uk_UA.KOI8-U): ¦  - Internet

%description
Apache is a powerful, full-featured, efficient and freely-available
Web server. Russian Apache is an extended version that supports various
character sets, which are necessary for Russian, Ukrainian, Czech
and other websites.

This special version also includes some optimizations, Extended Application
Programming Interface (EAPI) with the shared memory support,
hooks for SSL module and several cosmetic improvements.
%if_with mod_deflate
It also includes mod_deflate to spare the traffic (needs activation).
%endif

%description -l ru_RU.KOI8-R
Apache - , ,  
  -.

Russian Apache -       
,        
, ,    .

     ,
Extended Application Programming Interface (EAPI)   
,   SSL    .
%if_with mod_deflate
     mod_deflate.
%endif

%description -l uk_UA.KOI8-U
Apache - , æ,  
צ  -.

Russian Apache - æ  Ӧ   Ц Ҧ
,  դ     Ӧ, ,
   .

 Ӧ   ˦ ͦæ,
Extended Application Programming Interface (EAPI)  Ц Ħϧ
'Ԧ, Ц  SSL  ˦  .
%if_with mod_deflate
  Ʀ צΦ  mod_deflate.
%endif

%package base
Summary: The most widely used Web server on the Internet (base)
Summary(ru_RU.KOI8-R):   - Internet ()
Summary(uk_UA.KOI8-U): ¦  - Internet ()
Group: System/Servers

Provides: russian-apache = %russian_patchlevel webserver
Provides: httpd
PreReq: %name-common = %version-%release
Requires: mm >= %mm_version
Requires: monit-base
Requires: service >= 0.5-alt1
Requires: %condstopstart_webdir
Requires: %condstopstart_webrundir

Provides: %apache_moduledir

%description base
Apache is a powerful, full-featured, efficient and freely-available
Web server. Russian Apache is an extended version that supports various
character sets, which are necessary for Russian, Ukrainian, Czech
and other websites.

This special version also includes some optimizations, Extended Application
Programming Interface (EAPI) with the shared memory support,
hooks for SSL module and several cosmetic improvements.
%if_with mod_deflate
It also includes mod_deflate to spare the traffic (needs activation).
%endif

This package does not require a webserver-cgi-bin, webserver-html and
webserver-icons.

%description -l ru_RU.KOI8-R base
Apache - , ,  
  -.

Russian Apache -       
,        
, ,    .

     ,
Extended Application Programming Interface (EAPI)   
,   SSL    .
%if_with mod_deflate
     mod_deflate.
%endif

     webserver-cgi-bin, webserver-html 
webserver-icons.

%description -l uk_UA.KOI8-U base
Apache - , æ,  
צ  -.

Russian Apache - æ  Ӧ   Ц Ҧ
,  դ     Ӧ, ,
   .

 Ӧ   ˦ ͦæ,
Extended Application Programming Interface (EAPI)  Ц Ħϧ
'Ԧ, Ц  SSL  ˦  .
%if_with mod_deflate
  Ʀ צΦ  mod_deflate.
%endif

     webserver-cgi-bin, webserver-html 
webserver-icons.

%package full
Summary: The most widely used Web server on the Internet (full)
Summary(ru_RU.KOI8-R):   - Internet (full)
Summary(uk_UA.KOI8-U): ¦  - Internet (full)
Group: System/Servers

Requires: %name = %version-%release
Requires: %name-cgi-bin
Requires: %name-html
Requires: %name-icons

%description full
Apache is a powerful, full-featured, efficient and freely-available
Web server. Russian Apache is an extended version that supports various
character sets, which are necessary for Russian, Ukrainian, Czech
and other websites.

This special version also includes some optimizations, Extended Application
Programming Interface (EAPI) with the shared memory support,
hooks for SSL module and several cosmetic improvements.
%if_with mod_deflate
It also includes mod_deflate to spare the traffic (needs activation).
%endif

This package requires a apache-cgi-bin, apache-html and apache-icons.

%description -l ru_RU.KOI8-R full
Apache - , ,  
  -.

Russian Apache -       
,        
, ,    .

     ,
Extended Application Programming Interface (EAPI)   
,   SSL    .
%if_with mod_deflate
     mod_deflate.
%endif

    apache-cgi-bin, apache-html  apache-icons.

%description -l uk_UA.KOI8-U full
Apache - , æ,  
צ  -.

Russian Apache - æ  Ӧ   Ц Ҧ
,  դ     Ӧ, ,
   .

 Ӧ   ˦ ͦæ,
Extended Application Programming Interface (EAPI)  Ц Ħϧ
'Ԧ, Ц  SSL  ˦  .
%if_with mod_deflate
  Ʀ צΦ  mod_deflate.
%endif

    apache-cgi-bin, apache-html  apache-icons.

%package mod_perl
Summary: Russian Apache Web server with a built-in Perl interpreter
Summary(ru_RU.KOI8-R): - Russian Apache    Perl
Summary(uk_UA.KOI8-U): - Russian Apache ڦ   Perl
Group: System/Servers
Icon: mod_perl.gif
Requires: %name-mod_perl-base = %version-%release
Requires: webserver-cgi-bin
Requires: webserver-html
Requires: webserver-icons

%description mod_perl
Apache is a powerful, full-featured, efficient and freely-available
Web server. Russian Apache is an extended version that supports various
character sets, which are necessary for Russian, Ukrainian, Czech
and other websites.

mod_perl incorporates a Perl interpreter into the Apache web
server, so that the Apache web server can directly execute Perl
code.  Mod_perl links the Perl runtime library into the Apache
web server and provides an object-oriented Perl interface for
Apache's C language API.  The end result is a quicker CGI script
turnaround process, since no external Perl interpreter has to
be started.

This package contains Apache with mod_perl linked statically. You may want to
prefer this configuration rather than use mod_perl as a DSO, because it is more
stable and less prone to memory leaks.

This special version also includes Extended Application Programming Interface
(EAPI) with the shared memory support, hooks for SSL module and several
cosmetic improvements.

%description -l ru_RU.KOI8-R mod_perl
Apache - , ,  
  -.

Russian Apache -       
,        
, ,    .

mod_perl   Apache   Perl  
-   Perl   Apache API.  
 -   CGI-,   
     Perl-.

  Apache    mod_perl.  
     mod_perl,   
      .

    Extended Application Programming Interface (EAPI)
   ,   SSL   
.

%description -l uk_UA.KOI8-U mod_perl
Apache - , æ,  
צ  -.

Russian Apache - æ  Ӧ   Ц Ҧ
,  դ     Ӧ, ,
   .

 ͦ Apache    mod_perl.  
  æ æ, Φ ͦ  mod_perl,
   ¦ ¦       '.

 Ӧ   Extended Application Programming Interface (EAPI) 
Ц Ħϧ 'Ԧ, Ц  SSL  ˦ 
.

%package mod_perl-base
Summary: Russian Apache Web server with a built-in Perl interpreter (base)
Summary(ru_RU.KOI8-R): - Russian Apache    Perl ()
Summary(uk_UA.KOI8-U): - Russian Apache ڦ   Perl ()
Group: System/Servers
Icon: mod_perl.gif
Requires: mm >= %mm_version, perl >= 1:5.6.0
PreReq: %name-common = %version-%release
Provides: russian-apache = %russian_patchlevel webserver
Provides: httpd
Provides: mod_perl = %mod_perl_version
Obsoletes: mod_perl < %mod_perl_version

Provides: %apache_moduleperldir
Provides: %apache_addonconfdir
Provides: %apache_datadir/perl

# ugly hack ][
Provides: perl(mod_perl.pm) = %mod_perl_version_pad

%description mod_perl-base
Apache is a powerful, full-featured, efficient and freely-available
Web server. Russian Apache is an extended version that supports various
character sets, which are necessary for Russian, Ukrainian, Czech
and other websites.

mod_perl incorporates a Perl interpreter into the Apache web
server, so that the Apache web server can directly execute Perl
code.  Mod_perl links the Perl runtime library into the Apache
web server and provides an object-oriented Perl interface for
Apache's C language API.  The end result is a quicker CGI script
turnaround process, since no external Perl interpreter has to
be started.

This package contains Apache with mod_perl linked statically. You may want to
prefer this configuration rather than use mod_perl as a DSO, because it is more
stable and less prone to memory leaks.

This special version also includes Extended Application Programming Interface
(EAPI) with the shared memory support, hooks for SSL module and several
cosmetic improvements.

This package does not require a webserver-cgi-bin, webserver-html and
webserver-icons.

%description -l ru_RU.KOI8-R mod_perl-base
Apache - , ,  
  -.

Russian Apache -       
,        
, ,    .

mod_perl   Apache   Perl  
-   Perl   Apache API.  
 -   CGI-,   
     Perl-.

  Apache    mod_perl.  
     mod_perl,   
      .

    Extended Application Programming Interface (EAPI)
   ,   SSL   
.

     webserver-cgi-bin, webserver-html 
webserver-icons.

%description -l uk_UA.KOI8-U mod_perl-base
Apache - , æ,  
צ  -.

Russian Apache - æ  Ӧ   Ц Ҧ
,  դ     Ӧ, ,
   .

 ͦ Apache    mod_perl.  
  æ æ, Φ ͦ  mod_perl,
   ¦ ¦       '.

 Ӧ   Extended Application Programming Interface (EAPI) 
Ц Ħϧ 'Ԧ, Ц  SSL  ˦ 
.

     webserver-cgi-bin, webserver-html 
webserver-icons.

%package mod_perl-full
Summary: Russian Apache Web server with a built-in Perl interpreter (full)
Summary(ru_RU.KOI8-R): - Russian Apache    Perl (full)
Summary(uk_UA.KOI8-U): - Russian Apache ڦ   Perl (full)
Group: System/Servers
Icon: mod_perl.gif
Requires: %name-mod_perl = %version-%release
Requires: %name-cgi-bin
Requires: %name-html
Requires: %name-icons

%description mod_perl-full
Apache is a powerful, full-featured, efficient and freely-available
Web server. Russian Apache is an extended version that supports various
character sets, which are necessary for Russian, Ukrainian, Czech
and other websites.

mod_perl incorporates a Perl interpreter into the Apache web
server, so that the Apache web server can directly execute Perl
code.  Mod_perl links the Perl runtime library into the Apache
web server and provides an object-oriented Perl interface for
Apache's C language API.  The end result is a quicker CGI script
turnaround process, since no external Perl interpreter has to
be started.

This package contains Apache with mod_perl linked statically. You may want to
prefer this configuration rather than use mod_perl as a DSO, because it is more
stable and less prone to memory leaks.

This special version also includes Extended Application Programming Interface
(EAPI) with the shared memory support, hooks for SSL module and several
cosmetic improvements.

This package requires a apache-cgi-bin, apache-html and apache-icons.

%description -l ru_RU.KOI8-R mod_perl-full
Apache - , ,  
  -.

Russian Apache -       
,        
, ,    .

mod_perl   Apache   Perl  
-   Perl   Apache API.  
 -   CGI-,   
     Perl-.

  Apache    mod_perl.  
     mod_perl,   
      .

    Extended Application Programming Interface (EAPI)
   ,   SSL   
.

    apache-cgi-bin, apache-html  apache-icons.

%description -l uk_UA.KOI8-U mod_perl-full
Apache - , æ,  
צ  -.

Russian Apache - æ  Ӧ   Ц Ҧ
,  դ     Ӧ, ,
   .

 ͦ Apache    mod_perl.  
  æ æ, Φ ͦ  mod_perl,
   ¦ ¦       '.

 Ӧ   Extended Application Programming Interface (EAPI) 
Ц Ħϧ 'Ԧ, Ц  SSL  ˦ 
.

    apache-cgi-bin, apache-html  apache-icons.

%package common
Summary: Files common for apache and apache-mod_perl installations
Summary(ru_RU.KOI8-R):     apache  apache-mod_perl
Summary(uk_UA.KOI8-U): ЦΦ   æ apache  apache-mod_perl
Group: System/Servers
PreReq: webserver-common

Provides: %apache_basedir
Provides: %apache_confdir
Provides: %apache_confdir/vhosts
Provides: %apache_vhconfdir
Provides: %apache_addonconfdir
Provides: %apache_modconfdir
Provides: %apache_logdir
Provides: %_cachedir/httpd
Provides: %apache_tmpdir
Provides: %apache_tmpdir/tmp
Provides: %apache_tmpdir/sessions
Provides: %apache_tmpdir/uploads
Provides: %apache_datadir/apache

%description common
This package contains files required for both apache and apache-mod_perl
package installations. Install this if you want to install Apache or/and
Apache with mod_perl.

%description -l ru_RU.KOI8-R common
    ,   apache  apache-mod_perl.
,    Russian Apache
/ Russian Apache  mod_perl.

%description -l uk_UA.KOI8-U common
  ͦ , ˦ ȦΦ  apache  apache-mod_perl.
צ ,    Russian Apache.

%package -n rpm-build-%name
Summary: RPM helper to rebuild Web servers and apps packages
Summary(ru_RU.KOI8-R):     Web   
Group: Development/Other

Requires: rpm-macros-%name

%description -n rpm-build-%name
These helper provide possibility to rebuild Web servers and applications
packages by some ALT Linux Web Packaging Policy.

%description -n rpm-build-%name -l ru_RU.KOI8-R
         
   ALT Linux Web Packaging Policy.

%package devel
Summary: Module development tools for the Apache web server
Summary(ru_RU.KOI8-R):     - Apache
Summary(uk_UA.KOI8-U):   ̦  - Apache
Group: Development/C
BuildArch: noarch
PreReq: %name-base = %version-%release
Requires: rpm-build-%name >= %version-%release

Provides: %_includedir/%name

%description devel
The apache-devel package contains the source code for the Apache
Web server you'll need to build Dynamic
Shared Objects (DSOs) for Apache.

If you are installing the Apache Web server and
you want to be able to compile or develop additional modules
for Apache, you'll need to install this package.

%description -l ru_RU.KOI8-R devel
       - Apache,
      (DSO).

   - Apache    
    ,    .

%description -l uk_UA.KOI8-U devel
 ͦ צ   Ȧ Ԧ - Apache,
 ȦΦ  Цæ ͦ  ̦ (DSO).

   - Apache   Ц 
   צ ̦,    .

%package suexec
Summary: Suexec binary for Apache
Summary(ru_RU.KOI8-R):  suexec  Apache
Summary(uk_UA.KOI8-U):  suexec  Apache
Group: System/Servers
PreReq: %name-common = %version-%release

%description suexec
This package adds suexec to Apache. Suexec provides Apache users the ability
to run CGI and SSI programs under user IDs different from the user ID of the
calling web-server. Normally, when a CGI or SSI program executes, it runs as
the same user who is running the web server.

%description -l ru_RU.KOI8-R suexec
    Apache suexec.     CGI-
 SSI-   ,   UID
-.

%description -l uk_UA.KOI8-U suexec
    Apache suexec.   Ѥ  CGI-
 SSI- Ц Ʀ ,  צҦ צ
UID -.

%package -n mod_perl-doc
Summary: mod_perl documentation
Summary(ru_RU.KOI8-R):   mod_perl
Summary(uk_UA.KOI8-U): æ  mod_perl
Group: System/Servers
Version: %mod_perl_doc_version
PreReq: %name-common = %apache_version-%release
Requires: %apache_htdocsaddondir

%description -n mod_perl-doc
This package contains assorted documentation on the mod_perl Apache module.

%description -l ru_RU.KOI8-R -n mod_perl-doc
      Apache mod_perl.

%description -l uk_UA.KOI8-U -n mod_perl-doc
  ͦ æ   Apache mod_perl.

%package manual
Summary: Apache Manual
Summary(ru_RU.KOI8-R):   Apache
Summary(uk_UA.KOI8-U): æ  Apache
Group: System/Servers
Version: %apache_version
BuildArch: noarch
PreReq: %name-common = %version-%release
AutoReq: no

%description manual
This package contains the Apache server documentation in HTML format.

%description -l ru_RU.KOI8-R manual
     - Apache   HTML.

%description -l uk_UA.KOI8-U manual
  ͦ æ  - Apache  Ԧ HTML.

%package datadirs
Summary: data dirs for Apache
Summary(ru_RU.KOI8-R):    Apache
Group: System/Servers
BuildArch: noarch

Provides: %_datadir/%name
Provides: %_datadir/%name/cgi-bin

%description datadirs
This package contains the Apache server data dirs.

%description -l ru_RU.KOI8-R datadirs
      - Apache.

%package cgi-bin-test-cgi
Summary: cgi-bin/test-cgi for Apache
Summary(ru_RU.KOI8-R): cgi-bin/test-cgi  Apache
Group: System/Servers
BuildArch: noarch
PreReq: webserver-common
PreReq: %_sysconfdir/control.d/webserver-cgi-bin-functions
Provides: webserver-cgi-bin-test-cgi
Conflicts: apache2-cgi-bin-test-cgi
Conflicts: apache2-cgi-bin < 2.2.9-alt10
Conflicts: apache-common < 1.3.37rusPL30.23-alt1.1

Requires: %_datadir/%name/cgi-bin

%description cgi-bin-test-cgi
This package contains the Apache server test-cgi scripts.

%description -l ru_RU.KOI8-R cgi-bin-test-cgi
   test-cgi   - Apache.

%package cgi-bin-printenv
Summary: cgi-bin/printenv for Apache
Summary(ru_RU.KOI8-R): cgi-bin/printenv  Apache
Group: System/Servers
BuildArch: noarch
PreReq: webserver-common
PreReq: %_sysconfdir/control.d/webserver-cgi-bin-functions
Provides: webserver-cgi-bin-printenv
Conflicts: apache2-cgi-bin-printenv
Conflicts: apache2-cgi-bin < 2.2.9-alt10
Conflicts: apache-common < 1.3.37rusPL30.23-alt1.1

Requires: %_datadir/%name/cgi-bin

%description cgi-bin-printenv
This package contains the Apache server printenv scripts.

%description -l ru_RU.KOI8-R cgi-bin-printenv
   printenv   - Apache.

%package cgi-bin
Summary: cgi-bin for Apache
Summary(ru_RU.KOI8-R): cgi-bin  Apache
Group: System/Servers
BuildArch: noarch
Requires: %name-cgi-bin-test-cgi
Requires: %name-cgi-bin-printenv
Provides: webserver-cgi-bin
Conflicts: apache2-cgi-bin

%description cgi-bin
This package contains the Apache server cgi-bin dir and cgi scripts.

%description -l ru_RU.KOI8-R cgi-bin
    cgi-bin     - Apache.

%package html
Summary: html for Apache
Summary(ru_RU.KOI8-R): html  Apache
Group: System/Servers
BuildArch: noarch
PreReq: webserver-common
Provides: webserver-html
Conflicts: apache-common < 1.3.37rusPL30.23-alt1.1
Conflicts: apache2-html

%description html
This package contains the Apache server html dir.

%description -l ru_RU.KOI8-R html
    html  - Apache.

%package icons
Summary: icons for Apache
Summary(ru_RU.KOI8-R): icons  Apache
Group: System/Servers
BuildArch: noarch
PreReq: webserver-common
Provides: webserver-icons
Conflicts: apache-common < 1.3.37rusPL30.23-alt1.1
Conflicts: apache2-icons

%description icons
This package contains the Apache server icons dir.

%description -l ru_RU.KOI8-R icons
    icons  - Apache.

%add_findprov_lib_path %_libdir/%name

%prep
%{expand:%%global _builddir %_builddir/apache-%apache_version-%apache_release}
rm -rf %_builddir
mkdir -p %_builddir

%setup -q -n mod_deflate-%mod_deflate_version -T -b 12
%setup -q -n mod_accel-%mod_accel_version -T -b 17
%setup -q -n mod_perl-%mod_perl_version -T -b 13
%setup -q -n apache_%apache_version
%setup -q -n mod_realip-%mod_realip_version -T -b 14

# Install mod_realip
cp $RPM_BUILD_DIR/mod_realip-%mod_realip_version/*.c $RPM_BUILD_DIR/apache_%apache_version/src/modules/extra/

cd $RPM_BUILD_DIR/apache_%apache_version

# fix problem with mod_long_names (by pilot@);
# get apxs to understand Includes (updated patch1)
%patch1 -p1

# fix build
%patch2 -p1

%patch3 -p1
%patch4 -p1
%patch5 -p1

%patch8 -p1

%if_with acl_support
%patch10 -p1
%endif

%patch75 -p1
%patch76 -p1
%patch77 -p1

%patch94 -p1

# should be obsolete with mod_perl-1.30
pwd
pushd ../mod_perl-%mod_perl_version
%patch97 -p1
%patch98 -p1
%patch99 -p1
popd

chmod -x $(find htdocs -type f)
subst 's|" PLATFORM "|%distribution/%apache_release|;' \
	$RPM_BUILD_DIR/apache_%apache_version/src/main/http_main.c

#####
cd ..
rm -rf apache-mod_perl_%apache_vanilla_version

#### EAPI
pushd apache_%apache_version
%setup -q -n apache_%apache_version -T -D -b 9
mv ../EAPI-%EAPI_version/pkg.eapi/*.c src/ap/
mv ../EAPI-%EAPI_version/pkg.eapi/*.h src/include/
mv ../EAPI-%EAPI_version/pkg.addon/*.c src/modules/extra
cp src/modules/extra/mod_define.c src/modules/standard
popd

pushd apache_%apache_version
patch -p0 -s < ../EAPI-%EAPI_version/pkg.addon/addon.patch
patch -p0 -s < ../EAPI-%EAPI_version/pkg.eapi/eapi.patch
popd

cp -pr apache_%apache_version apache-mod_perl_%apache_vanilla_version

%build
echo "### define configure flags"
APFLAGS="--serverroot=%apache_basedir \
	--prefix=%prefix \
	--bindir=%_bindir \
	--sbindir=%_sbindir \
	--mandir=%_mandir \
	--sysconfdir=%apache_confdir \
	--datadir=%apache_datadir \
	--htdocsdir=%apache_htdocsdir \
	--includedir=%_includedir/apache \
	--localstatedir=%_var \
	--runtimedir=%_var/run \
	--logfiledir=%apache_logdir \
	--proxycachedir=%_cachedir/httpd \
	--disable-rule=WANTHSREGEX \
	--disable-rule=EXPAT \
        --with-perl=%__perl \
	--without-confadjust \
	--enable-module=all \
	--enable-module=auth_digest \
	--disable-module=auth_dbm \
	--enable-shared=max \
	--enable-suexec \
	--suexec-caller=%apache_user \
	--suexec-docroot=%suexec_docroot \
	--suexec-userdir=public_html \
	--activate-module=src/modules/extra/mod_realip.o \
%if_with mod_accel
	--activate-module=src/modules/accel/libaccel.a \
%endif
%if_with mod_deflate
	--activate-module=src/modules/extra/mod_deflate.o \
%endif
	"

%if_with mod_deflate
echo "### Patching source of apache to enable mod_deflate"
pushd ../mod_deflate-%mod_deflate_version
./configure --with-apache=../apache_%apache_version
# SMP build incompatible
%make
./configure --with-apache=../apache-mod_perl_%apache_vanilla_version
%make
mv CHANGES CHANGES.mod_deflate
mv CHANGES.rus CHANGES.mod_deflate.rus
mv LICENSE LICENSE.mod_deflate
mv readme.html readme.mod_deflate.ru.html
popd
%endif

%if_with mod_accel
echo "### Patching source of apache to enable mod_accel"
pushd ../mod_accel-%mod_accel_version
./configure --with-apache=../apache_%apache_version
%make
./configure --with-apache=../apache-mod_perl_%apache_vanilla_version
%make
mv CHANGES CHANGES.mod_accel
mv CHANGES.rus CHANGES.mod_accel.rus
mv LICENSE LICENSE.mod_accel
mv readme.html readme.mod_accel.ru.html
popd
%endif

LIMITS="-DHARD_SERVER_LIMIT=%apache_hard_server_limit"

%if_with acl_support
ACL_SUPPORT="-DACL_SUPPORT"
%endif

echo "### Build the *normal* Apache"

OPTIM="%optflags $LIMITS $ACL_SUPPORT" \
EAPI_MM=SYSTEM \
CFLAGS='-DEAPI_MM_CORE_PATH=\\\"%_var/run/mm\\\" -I%_includedir/db4 -I%_includedir/gdbm -DDBM_SUFFIX=\\\".db\\\"' \
LIBS="-ldb -lgdbm -lgdbm_compat -lpthread" \
found_dbm="1" \
./configure \
	--enable-rule=EAPI \
	--libexecdir=%apache_moduledir \
	--enable-rule=SHARED_CORE \
	$APFLAGS

%make

echo "### configure mod_perl"
cd $RPM_BUILD_DIR/mod_perl-%mod_perl_version
perl -pi -e "s|PRODUCT|BASEPRODUCT|;" Makefile.PL
PERL_CC="gcc" \
PERL_CCFLAGS=`perl -V:ccflags|cut -f 2 -d\'` \
perl -I$RPM_BUILD_DIR/mod_perl-%mod_perl_version/lib  Makefile.PL \
    PREFIX=%prefix INSTALLDIRS=vendor \
    USE_APACI=1 \
    APACHE_SRC=../apache-mod_perl_%apache_vanilla_version/src \
    APACHE_HEADER_INSTALL=1 \
    DO_HTTPD=1 \
    PREP_HTTPD=1 \
    EVERYTHING=1

echo "### build Perl-side "
%make
chmod -R o-w t/docs/
cd faq
%make
echo "### build Apache with mod_perl"
cd $RPM_BUILD_DIR/apache-mod_perl_%apache_vanilla_version

OPTIM="%optflags $LIMITS $ACL_SUPPORT" \
PERL_CC="gcc" \
PERL_CCFLAGS=`perl -V:ccflags|cut -f 2 -d\'` \
PERL5LIB=$RPM_BUILD_DIR/mod_perl-%mod_perl_version/lib \
CFLAGS='-I%_includedir/db4 -I%_includedir/gdbm -DDBM_SUFFIX=\\\".db\\\"' \
LIBS="-ldb -lgdbm -lgdbm_compat -lpthread" \
found_dbm="1" \
./configure \
	--enable-rule=EAPI \
	--libexecdir=%apache_moduleperldir \
	$APFLAGS \
	--activate-module=src/modules/perl/libperl.a \
	--activate-module=src/modules/extra/mod_realip.o \
	--disable-shared=include \
	--disable-shared=perl

%make build-std
%make -C src/support apxs

%install
# Generate sed script for substitute the real paths in configs
echo '
s|@RUNDIR@|%condstopstart_webrundir|g
' >> SetMacros.sed

# install the normal Apache
pushd $RPM_BUILD_DIR/apache_%apache_version
%make install-quiet root=%buildroot
install -d %buildroot%apache_tmpdir/{,tmp,sessions,uploads}
popd

# install apache-mod_perl
pushd $RPM_BUILD_DIR/apache-mod_perl_%apache_vanilla_version
install -m755 src/httpd %buildroot%_sbindir/httpd-perl
install -d -m755 %buildroot%apache_moduleperldir/
install -m755 src/modules/*/*.so %buildroot%apache_moduleperldir/
sed  -e 's;^#!/.*;#!/usr/bin/perl;' \
	-e 's;\@prefix\@;%prefix;' \
	-e 's;\@sbindir\@;%_sbindir;' \
	-e 's;\@libexecdir\@;%apache_moduleperldir;' \
	-e 's;\@includedir\@;%_includedir/%name;' \
	-e 's;\@sysconfdir\@;%apache_confdir;' \
	< src/support/apxs > %buildroot%_sbindir/apxs-perl
chmod 755 %buildroot%_sbindir/apxs-perl
popd

ln -snf `relative %apache_logdir %apache_basedir/` \
	%buildroot%apache_loglink
ln -snf `relative %apache_moduledir %apache_basedir/` \
	%buildroot%apache_modulelink
ln -snf `relative %apache_moduleperldir %apache_basedir/` \
	%buildroot%apache_moduleperllink

# install log rotation stuff
install -pD -m644 %SOURCE4 \
	%buildroot%_sysconfdir/logrotate.d/apache

# install configuration files
pushd %buildroot%apache_confdir
	install -m644 %SOURCE5 httpd.conf
	install -m644 %SOURCE15 httpd-perl.conf
	perl -pi -e 's/^\s*User nobody/User %apache_user/;' \
		    -e 's/^\s*Group nobody/Group %apache_group/;' \
		    httpd*.conf
	install -m644 %SOURCE23 apache-mime.types
	cp -a mime.types.default apache-mime.types.default
	install -d -m755 vhosts
	install -p -m644 %SOURCE26 %SOURCE27 %SOURCE50 %SOURCE51 vhosts/
	install -pD -m644 %SOURCE16 addon-modules/proxied_handlers.pl

	install -d -m755 addon-modules.d
	install -pD -m644 %SOURCE53 addon-modules.d/mod_charset.conf
	install -pD -m644 %SOURCE54 addon-modules.d/mod_realip.conf

	install -d -m755 vhosts.d
	install -p -m644 %SOURCE62 vhosts.d/00-example.conf

	install -d -m755 vhosts-perl.d
	
	# purge unneeded ones
	rm -f {{access,srm}.conf,mime.types}{,.default}
popd

# monit support
install -pD -m644 %SOURCE64 %buildroot%_sysconfdir/monitrc.d/apache

#install misc documentation and logos
install -pD -m644 %SOURCE52 %buildroot%apache_htdocsdir/README.txt
install -pD -m644 %SOURCE61 %buildroot%apache_htdocsdir/README.ALT
install -pD -m644 %SOURCE63 %buildroot%apache_htdocsdir/TUNING.ALT
rm -f %buildroot%apache_htdocsdir/index.html.ru{,.ucs*}
for f in %buildroot%apache_htdocsdir/index.html*; do
	perl -pi \
		-e 's|apache_pb\.gif|ra-powered.gif|g;' \
		-e 's|</BODY>|<!--#include file="altlinux.html" -->\n</BODY>|i;' \
		< $f > ${f/.html/.shtml} \
        && rm -f $f
done
perl -pi -e 's|http://www\.apache\.org/httpd|http://apache.lexa.ru/|' \
	%buildroot%apache_htdocsdir/index.shtml.ru*
install -m644 %SOURCE29 %buildroot/%apache_htdocsdir/
install -m644 %SOURCE30 %buildroot/%apache_htdocsdir/
install -d -m755 %buildroot/%apache_htdocsaddondir/
install -m644 $RPM_BUILD_DIR/EAPI-%EAPI_version/pkg.addon/mod_define.html \
	%buildroot/%apache_htdocsdir/manual/mod/mod_define.html

perl -pi -e "s|/usr/local/bin/perl|%__perl|g;" \
	%buildroot/%apache_htdocsdir/manual/misc/howto.html
perl -pi -e "s|/path/to/bin/perl|%__perl|g;" \
	%buildroot/%apache_htdocsdir/manual/mod/mod_rewrite.html
perl -pi -e "s|/usr/local/bin/perl|%__perl|g;" \
	%buildroot/%apache_htdocsdir/manual/search/manual-index.cgi

#install cache_create for mod_accel
%if_with mod_accel
install -m755 $RPM_BUILD_DIR/mod_accel-%mod_accel_version/create_cache \
	%buildroot%_bindir/create_cache
%endif

# install mod_perl files
pushd $RPM_BUILD_DIR/mod_perl-%mod_perl_version
%perl_vendor_install
rm -f %buildroot%perl_vendor_autolib/mod_perl/.packlist
install -d  -m755 %buildroot%apache_datadir/perl
install -pD -m644 eg/README \
	%buildroot%apache_htdocsaddondir/mod_perl/README.eg
install -m644 README SUPPORT Changes faq/*.{html,txt} \
		 apache-modlist.html htdocs/manual/mod/mod_perl.html \
	%buildroot%apache_htdocsaddondir/mod_perl/
perl -pi -e "s|../../../|/manual/images/|g;" \
	%buildroot%apache_htdocsaddondir/mod_perl/mod_perl.html
perl -pi -e 's,/usr/local/bin/perl,%_bindir/perl,' \
	%buildroot%perl_vendor_archlib/Apache/Resource.pm
popd

# install proper initscripts
mkdir -p %buildroot%_sysconfdir/rc.d/init.d

install -m755 %SOURCE35 \
	%buildroot%_sysconfdir/rc.d/init.d/httpd
install -m755 %SOURCE36 \
	%buildroot%_sysconfdir/rc.d/init.d/httpd-perl

# replace the "official" apachectl by a symlink to the init script
rm -f %buildroot%_sbindir/apachectl*
ln -s `relative %_sysconfdir/rc.d/init.d/httpd %_sbindir/` \
	%buildroot%_sbindir/apachectl
ln -s `relative %_sysconfdir/rc.d/init.d/httpd-perl %_sbindir/` \
	%buildroot%_sbindir/apachectl-perl

# take away manuals to place them in docdir
mv %buildroot%apache_htdocsdir/manual/ \
	$RPM_BUILD_DIR/apache_%apache_version/
mv %buildroot%apache_htdocsaddondir/mod_perl/ \
	$RPM_BUILD_DIR/apache_%apache_version/perldocs

# fix manpages
subst 's,/usr/local/apache,%apache_basedir,g' \
	%buildroot/%_mandir/man?/*.[0-9]
subst 's,/usr/local/etc/apache,%apache_confdir,g' \
	%buildroot/%_mandir/man?/*.[0-9]

# check modules for undefined symbols
pushd %buildroot%apache_moduledir
ldd -r libhttpd.so 2>%_builddir/check.log >/dev/null
for f in *.so; do
	[ "$f" != libhttpd.so ] || continue
	[ -f "$f" ] || continue
	LD_PRELOAD=./libhttpd.so ldd -r "$f" 2>&1 >/dev/null ||:
done >>%_builddir/check.log
! [ -s %_builddir/check.log ] || exit 1
popd # %buildroot%apache_moduledir
pushd %buildroot%apache_moduleperldir
for f in *.so; do
	[ -f "$f" ] || continue
	LD_PRELOAD=%buildroot%apache_moduledir/libhttpd.so ldd -r "$f" 2>&1 >/dev/null ||:
done >%_builddir/check.log
! [ -s %_builddir/check.log ] || exit 1
popd # %buildroot%apache_moduleperldir

mkdir -p %buildroot%apache_datadir/apache/

# Install scripts for control
install -pD %SOURCE40 %buildroot%_controldir/cgi-bin_test-cgi
install -pD %SOURCE41 %buildroot%_controldir/cgi-bin_printenv

# Create datadirs
install -d %buildroot%_datadir/%name/cgi-bin/

# Move cgi scripts to data dirs
mv %buildroot%apache_cgibindir/* %buildroot%_datadir/%name/cgi-bin/

# Install condstopstart-web scripts for httpd
install -pD %SOURCE70 %buildroot%condstopstart_webdir/httpd-condstop
ln -s httpd-condstop %buildroot%condstopstart_webdir/httpd-condstop-rpm
install -pD %SOURCE72 %buildroot%condstopstart_webdir/httpd-condstart
ln -s httpd-condstart %buildroot%condstopstart_webdir/httpd-condstart-rpm

sed -i '
s|@SERVER@|httpd|g
s|@LOCKFILE@|%_locksubsysdir/httpd|g
' %buildroot%condstopstart_webdir/httpd-cond*

# Install condstopstart-web scripts for httpd-perl
install -pD %SOURCE70 %buildroot%condstopstart_webdir/httpd-perl-condstop
ln -s httpd-condstop %buildroot%condstopstart_webdir/httpd-perl-condstop-rpm
install -pD %SOURCE72 %buildroot%condstopstart_webdir/httpd-perl-condstart
ln -s httpd-condstart %buildroot%condstopstart_webdir/httpd-perl-condstart-rpm

sed -i '
s|@SERVER@|httpd-perl|g
s|@LOCKFILE@|%_locksubsysdir/httpd-perl|g
' %buildroot%condstopstart_webdir/httpd-perl-cond*

# Substitute the real paths in files
find %buildroot%_sysconfdir %buildroot%condstopstart_webdir \
		-type f -print0 \
	| xargs -r0i %_datadir/rpm-build-rpm-eval/rpm-eval.sh "{}"
find %buildroot%_sysconfdir %buildroot%condstopstart_webdir \
		-type f -print0 \
	| xargs -r0 sed -i -f SetMacros.sed

mkdir -p %buildroot%_rpmlibdir
cat <<\EOF >%buildroot%_rpmlibdir/%name-files.req.list
# %name dirlist for %_rpmlibdir/files.req
%apache_moduledir/	%name-base
%apache_basedir/	%name-common
%apache_confdir/	%name-common
%apache_confdir/vhosts/	%name-common
%apache_vhconfdir/	%name-common
%apache_addonconfdir/	%name-common
%apache_modconfdir/	%name-common
%apache_logdir/	%name-common
%_cachedir/httpd/	%name-common
%apache_tmpdir/	%name-common
%apache_tmpdir/tmp/	%name-common
%apache_tmpdir/sessions/	%name-common
%apache_tmpdir/uploads/	%name-common
%apache_datadir/apache/	%name-common
%_datadir/%name/	%name-datadirs
%_datadir/%name/cgi-bin/	%name-datadirs
%apache_moduleperldir/	%name-mod_perl-base
%apache_addonconfdir/	%name-mod_perl-base
%apache_datadir/perl/	%name-mod_perl-base
%_includedir/%name/	%name-devel
EOF

# SCRIPTS

%pre common
%_sbindir/groupadd -r -f %apache_group 2>/dev/null ||:
%_sbindir/groupadd -r -f %apache_webmaster 2>/dev/null ||:
%_sbindir/useradd -g %apache_group -c 'WWW server' -d %apache_datadir -s '' \
	-G %webserver_group -r %apache_user 2>/dev/null || :
if LANG=C %_bindir/id %apache_user 2>/dev/null | \
		grep -qv "groups=[^[:space:]]*(%webserver_group)"; then
	echo 'Warning: User %apache_user was not included in the group %webserver_group!'
	%_bindir/gpasswd -a %apache_user %webserver_group
	echo '     Added user %apache_user to group %webserver_group.'
fi
if [ -e %old_apache_home -a ! -e %apache_datadir ]; then
	mkdir -p `dirname %apache_datadir`
	ln -s %old_apache_home %apache_datadir
fi

# FIXME: see #2920
#post common
#find %apache_logdir -group %apache_webmaster -print0 \
#| xargs -0 chgrp %apache_group

%post manual
ln -snf %_docdir/apache-manual-%apache_version %apache_datadir/apache/manual

%preun manual
if [ $1 = 0 ]; then
	rm -f %apache_datadir/apache/manual
fi

%post base
%post_service httpd

%preun base
%preun_service httpd
## XXX: is this correct with standalone httpd-perl??
## => commenting out as of 1.3.32
#if [ $1 = 0 ]; then
#	rm -rf %apache_logdir/*
#fi

%post mod_perl-base
%post_service httpd-perl

%preun mod_perl
%preun_service httpd-perl
%postun mod_perl-base
if [ -e %_sbindir/apachectl ]; then
	%_sbindir/apachectl update
fi

%post -n mod_perl-doc
ln -snf %_docdir/mod_perl-doc-%mod_perl_doc_version \
	%apache_htdocsaddondir/mod_perl

%preun -n mod_perl-doc
if [ $1 = 0 ]; then
	rm -f %apache_htdocsaddondir/mod_perl
fi

%post suexec
if [ -e %_sbindir/apachectl ]; then
	%_sbindir/apachectl update
fi

%postun suexec
if [ -e %_sbindir/apachectl ]; then
	%_sbindir/apachectl update
fi

%pre cgi-bin-test-cgi
%pre_webserver_cgi_bin_control cgi-bin_test-cgi

%post cgi-bin-test-cgi
%post_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_test-cgi

%preun cgi-bin-test-cgi
%preun_webserver_cgi_bin_control cgi-bin_test-cgi

%postun cgi-bin-test-cgi
%postun_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_test-cgi

%triggerpostun cgi-bin-test-cgi -- apache-common < 1.3.37rusPL30.23-alt1.1, apache-cgi-bin < 1.3.41rusPL30.23-alt4.7.3, apache2-cgi-bin < 2.2.9-alt10, apache2-cgi-bin-test-cgi
%triggerpostun_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_test-cgi

%pre cgi-bin-printenv
%pre_webserver_cgi_bin_control cgi-bin_printenv

%post cgi-bin-printenv
%post_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_printenv

%preun cgi-bin-printenv
%preun_webserver_cgi_bin_control cgi-bin_printenv

%postun cgi-bin-printenv
%postun_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_printenv

%triggerpostun cgi-bin-printenv -- apache-common < 1.3.37rusPL30.23-alt1.1, apache-cgi-bin < 1.3.41rusPL30.23-alt4.7.3, apache2-cgi-bin < 2.2.9-alt10, apache2-cgi-bin-printenv
%triggerpostun_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_printenv

%files datadirs
%dir %_datadir/%name/
%dir %_datadir/%name/cgi-bin/

%files cgi-bin-test-cgi
%_controldir/cgi-bin_test-cgi
%attr(644,root,root) %_datadir/%name/cgi-bin/test-cgi

%files cgi-bin-printenv
%_controldir/cgi-bin_printenv
%attr(644,root,root) %_datadir/%name/cgi-bin/printenv

%files cgi-bin

%files html
%attr(664,root,%apache_webmaster) %config(noreplace) %apache_htdocsdir/*html*
%attr(664,root,%apache_webmaster) %config(noreplace) %apache_htdocsdir/*.txt
%attr(664,root,%apache_webmaster) %config(noreplace) %apache_htdocsdir/*.gif
%attr(604,root,%apache_group) %apache_htdocsdir/README.ALT
%attr(604,root,%apache_group) %apache_htdocsdir/TUNING.ALT

%files icons
%defattr(644,root,%apache_webmaster,2775)
%apache_iconsdir/README*
%apache_iconsdir/*.gif
%apache_iconsdir/*.png
%apache_iconssmalldir/*.gif
%apache_iconssmalldir/*.png

%files common
%dir %apache_basedir/
%dir %apache_datadir/apache/
%_sbindir/ab
%_sbindir/logresolve
%_sbindir/rotatelogs
%_bindir/*

%attr(750,root,%apache_webmaster) %dir %apache_confdir/
%config(noreplace) %apache_confdir/magic
%config(noreplace) %apache_confdir/apache-mime.types
%dir %apache_confdir/vhosts/
%config(noreplace) %apache_confdir/vhosts/*.conf
%dir %apache_vhconfdir/
%config(noreplace) %apache_vhconfdir/*.conf
%dir %apache_addonconfdir/
%dir %apache_modconfdir/
%config(noreplace) %apache_modconfdir/*.conf
%apache_conf.default
%apache_confdir/magic.default
%apache_confdir/apache-mime.types.default
%apache_confdir/tables

%apache_loglink

%defattr(644,root,root,755)
%attr(750,root,%apache_group) %dir %apache_logdir/
%attr(2770,root,%apache_group) %dir %_cachedir/httpd/

%attr(750,root,%apache_group) %dir %apache_tmpdir/
%attr(2770,root,%apache_group) %dir %apache_tmpdir/tmp/
%attr(2770,root,%apache_group) %dir %apache_tmpdir/sessions/
%attr(2770,root,%apache_group) %dir %apache_tmpdir/uploads/

%_mandir/man?/*

%config(noreplace) %_sysconfdir/logrotate.d/apache

%doc README* LICENSE ABOUT_APACHE CHANGES.rus*
%doc ../EAPI-%EAPI_version/pkg.eapi/README.EAPI

%if_with mod_deflate
%doc ../mod_deflate-%mod_deflate_version/CHANGES.mod_deflate*
%doc ../mod_deflate-%mod_deflate_version/LICENSE.mod_deflate
%doc ../mod_deflate-%mod_deflate_version/readme.mod_deflate.ru.html
%endif

%files

%files base
%_initdir/httpd
%_sbindir/apachectl
%_sbindir/httpd
%apache_apxs
%config(noreplace) %apache_conf
%config(noreplace) %_sysconfdir/monitrc.d/apache
%dir %apache_moduledir/
%apache_moduledir/*
%apache_modulelink

%condstopstart_webdir/httpd-cond*

%files full

%files mod_perl

%files mod_perl-base
%_initdir/httpd-perl
%_sbindir/apachectl-perl
%_sbindir/httpd-perl
%dir %apache_moduleperldir/
%apache_moduleperldir/*
%apache_moduleperllink
%_sbindir/apxs-perl
%config(noreplace) %apache_confdir/httpd-perl.conf
%dir %apache_addonconfdir/
%config(noreplace) %apache_addonconfdir/proxied_handlers.pl
%perl_vendor_archlib/Apache*
%perl_vendor_archlib/Bundle*
%perl_vendor_archlib/mod_perl*
%perl_vendor_autolib/Apache*
%attr(3771,root,%apache_group) %dir %apache_datadir/perl/

%condstopstart_webdir/httpd-perl-cond*

%files mod_perl-full

%files -n mod_perl-doc
%doc perldocs/*

%files manual
%doc manual/*

%files -n rpm-build-%name
%_rpmlibdir/%name-files.req.list

%files devel
%dir %_includedir/%name/
%_includedir/%name/*

%files suexec
%attr(4710,root,%apache_group) %_sbindir/suexec

# TODO
# - seperate apache-mod_perl-devel ?
# - buildreq plugs "apache-mod_perl" build dependency somehow :-/
# - update fuzzy patches?
# - seperate htpasswd
# - include /etc/monitrc.d/apache ?
# - control suexec?
# - fix all ugly hacks!
# - macro for %_cachedir/httpd/

%changelog
