Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-java
BuildRequires: maven
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-compat
%global base_name launcher
%global short_name commons-%{base_name}

Name:          apache-%{short_name}
Version:       1.1
Release:       alt1_10.20100521svn936225jpp7
Summary:       A cross platform Java application launcher
Group:         Development/Java
License:       ASL 2.0
URL:           http://commons.apache.org/%{base_name}/

# The last release of this package was many years ago and in that time there
# have only been two extremely minor changes to the source code, [1] and [2].
# It seems a new release is unlikely to be forthcoming in the near future.
# 
# [1] - http://svn.apache.org/viewvc/commons/proper/launcher/trunk/src/java/org/apache/commons/launcher/ChildMain.java?r1=138801&r2=138803
# [2] - http://svn.apache.org/viewvc/commons/proper/launcher/trunk/src/java/org/apache/commons/launcher/Launcher.java?r1=138801&r2=138802
# 
# During that time however, support for the maven 2 build system has been
# added. So in order to make my life easier as a maintainer, with regard to
# supporting OSGi manifests and installing poms, etc, I have elected to package
# a maven2 supporting snapshot instead of maintaining patches in our SRPM. As
# an added bonus, the snapshot also has more accurate javadocs.
# 
# How to generate source tarball from source control:
#  $ svn export -r 936225 http://svn.apache.org/repos/asf/commons/proper/launcher/trunk/ commons-launcher-1.1-src
#  $ tar -zcf commons-launcher-1.1-src.tar.gz commons-launcher-1.1-src
Source0:       %{short_name}-%{version}-src.tar.gz

# remove unnecessary build dependency on ant-optional (ant no longer ships this jar)
Patch0:        %{short_name}-pom.patch

BuildArch:     noarch

BuildRequires: jpackage-utils
BuildRequires: maven-antrun-plugin
BuildRequires: maven-assembly-plugin
BuildRequires: maven-compiler-plugin
BuildRequires: maven-idea-plugin
BuildRequires: maven-install-plugin
BuildRequires: maven-jar-plugin
BuildRequires: maven-javadoc-plugin
BuildRequires: maven-resources-plugin
BuildRequires: maven-doxia-sitetools
BuildRequires: maven-plugin-bundle
BuildRequires: maven-surefire-maven-plugin
BuildRequires: maven-surefire-provider-junit
Requires:      jpackage-utils
Source44: import.info

%description
Commons-launcher eliminates the need for a batch or shell script to launch a 
Java class. Some situations where elimination of a batch or shell script may 
be desirable are:

* You want to avoid having to determining where certain application paths are
e.g. your application's home directory, etc. Determining this dynamically in 
a Windows batch scripts is very tricky on some versions of Windows or when 
soft links are used on Unix platforms.

* You want to avoid having to handle native file and path separators or native
path quoting issues.

* You need to enforce certain system properties.

* You want to allow users to pass in custom JVM arguments or system properties
without having to parse and reorder arguments in your script. This can be 
tricky and/or messy in batch and shell scripts.

* You want to bootstrap system properties from a configuration file instead 
hard-coding them in your batch and shell scripts.

* You want to provide localized error messages which is very tricky to do in
batch and shell scripts.

%package javadoc
Summary:       API documentation for %{name}
Group:         Development/Java
Requires:      jpackage-utils
BuildArch: noarch

%description javadoc
%{summary}.

%prep
%setup -q -n %{short_name}-%{version}-src

# apply patches
%patch0 -p0 -b .orig

sed -i 's/\r//' README.txt LICENSE.txt NOTICE.txt
sed -i "s|\<groupId\>ant\<\/groupId\>|<groupId>org.apache.ant</groupId>|g" build.xml

%build
mvn-rpmbuild -Dmaven.compile.source=1.5 -Dmaven.compile.target=1.5 -Dmaven.javadoc.source=1.5  install javadoc:aggregate

%install
# jars
install -d -m 755 %{buildroot}%{_javadir}
install -p -m 644 target/%{short_name}-%{version}.jar \
  %{buildroot}%{_javadir}/%{name}.jar
(cd %{buildroot}%{_javadir} && ln -sf %{name}.jar %{short_name}.jar)

# javadocs
install -d -m 755 %{buildroot}%{_javadocdir}/%{name}
cp -pr target/site/apidocs/* %{buildroot}%{_javadocdir}/%{name}

# pom
install -pD -T -m 644 pom.xml %{buildroot}%{_mavenpomdir}/JPP-%{short_name}.pom
%add_to_maven_depmap org.apache.commons %{short_name} %{version} JPP %{short_name}

# following line is only for backwards compatibility. New packages
# should use proper groupid org.apache.commons
%add_to_maven_depmap %{short_name} %{short_name} %{version} JPP %{short_name}

%files
%doc LICENSE.txt NOTICE.txt README.txt
%{_mavendepmapfragdir}/*
%{_mavenpomdir}/*
%{_javadir}/*

%files javadoc
%doc LICENSE.txt
%{_javadocdir}/%{name}

%changelog
