Epoch: 0
AutoReq: yes,noosgi
BuildRequires: rpm-build-java-osgi
BuildRequires: /proc
BuildRequires: jpackage-compat

%global base_name  logging
%global short_name commons-%{base_name}

Name:           apache-%{short_name}
Version:        1.1.1
Release:        alt5_20jpp7
Summary:        Apache Commons Logging
License:        ASL 2.0
Group:          Development/Java
URL:            http://commons.apache.org/%{base_name}
Source0:        http://www.apache.org/dist/commons/%{base_name}/source/%{short_name}-%{version}-src.tar.gz
Source1:        %{short_name}.depmap
Source2:        http://mirrors.ibiblio.org/pub/mirrors/maven2/%{short_name}/%{short_name}-api/1.1/%{short_name}-api-1.1.pom
# Sent upstream https://issues.apache.org/jira/browse/LOGGING-143
Patch0:         %{short_name}-avalon-update.patch

Patch1:         %{short_name}-eclipse-manifest.patch
BuildArch:      noarch
BuildRequires:  maven
BuildRequires:  jpackage-utils >= 0:1.6
BuildRequires:  avalon-framework >= 4.3
BuildRequires:  avalon-logkit
BuildRequires:  apache-commons-parent
BuildRequires:  maven-plugin-build-helper
BuildRequires:  maven-release-plugin
BuildRequires:  maven-site-plugin
BuildRequires:  servlet

Requires:       jpackage-utils >= 0:1.6

# This should go away with F-17
Provides:       jakarta-%{short_name} = 0:%{version}-%{release}
Obsoletes:      jakarta-%{short_name} <= 0:1.0.4
Provides:       %{short_name} = %{epoch}:%{version}-%{release}
Source44: import.info

%def_with repolib
%define repodir %{_javadir}/repository.jboss.com/apache-%{base_name}/%{version}-brew
%define repodirlib %{repodir}/lib
%define repodirres %{repodir}/resources
%define repodirsrc %{repodir}/src

Source3:        %{name}-component-info.xml
%if_with repolib
%package repolib
Summary:        Artifacts to be uploaded to a repository library
Group:          Development/Java
Provides:       jakarta-%{short_name}-repolib = %{epoch}:%{version}-%{release}
Obsoletes:      jakarta-%{short_name}-repolib < %{epoch}:%{version}-%{release}
Provides:       %{short_name}-repolib = %{epoch}:%{version}-%{release}
Obsoletes:      %{short_name}-repolib < %{epoch}:%{version}-%{release}

%description repolib
Artifacts to be uploaded to a repository library.
This package is not meant to be installed but so its contents
can be extracted through rpm2cpio.
%endif

%if_with repolib
%files repolib
%dir %{_javadir}
%{_javadir}/repository.jboss.com
%endif

%description
The commons-logging package provides a simple, component oriented
interface (org.apache.commons.logging.Log) together with wrappers for
logging systems. The user can choose at runtime which system they want
to use. In addition, a small number of basic implementations are
provided to allow users to use the package standalone.
commons-logging was heavily influenced by Avalon's Logkit and Log4J. The
commons-logging abstraction is meant to minimize the differences between
the two, and to allow a developer to not tie himself to a particular
logging implementation.

%package        javadoc
Summary:        API documentation for %{name}
Group:          Development/Java
Requires:       jpackage-utils

Obsoletes:      jakarta-%{short_name}-javadoc <= 0:1.0.4
Provides:       jakarta-%{short_name}-javadoc = 0:%{version}-%{release}
BuildArch: noarch

%description    javadoc
%{summary}.

# -----------------------------------------------------------------------------

%prep
%setup -q -n %{short_name}-%{version}-src

%patch0 -p1
%patch1

sed -i 's/\r//' RELEASE-NOTES.txt LICENSE.txt

# -----------------------------------------------------------------------------

%build
# fails with recent surefire for some reason
rm src/test/org/apache/commons/logging/logkit/StandardTestCase.java
rm src/test/org/apache/commons/logging/servlet/BasicServletTestCase.java

# These files have names suggesting they are test cases but they are not.
# They should probably be renamed/excluded from surefire run properly
rm src/test/org/apache/commons/logging/log4j/log4j12/*StandardTestCase.java

mvn-rpmbuild -Dmaven.local.depmap.file="%{SOURCE1}" \
    install javadoc:aggregate

# -----------------------------------------------------------------------------

%install
# jars
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}
install -p -m 644 target/%{short_name}-%{version}.jar $RPM_BUILD_ROOT%{_javadir}/%{name}.jar
install -p -m 644 target/%{short_name}-api-%{version}.jar $RPM_BUILD_ROOT%{_javadir}/%{name}-api.jar
install -p -m 644 target/%{short_name}-adapters-%{version}.jar $RPM_BUILD_ROOT%{_javadir}/%{name}-adapters.jar

pushd $RPM_BUILD_ROOT%{_javadir}
for jar in %{name}*; do
    ln -sf ${jar} `echo $jar| sed "s|apache-||g"`
    ln -sf ${jar} jakarta-`echo $jar| sed "s|apache-||g"`
done
popd

# pom
install -d -m 755 $RPM_BUILD_ROOT%{_mavenpomdir}
install -pm 644 pom.xml $RPM_BUILD_ROOT/%{_mavenpomdir}/JPP-%{short_name}.pom
install -pm 644 %{SOURCE2} $RPM_BUILD_ROOT/%{_mavenpomdir}/JPP-%{short_name}-api.pom

%add_to_maven_depmap org.apache.commons %{short_name} %{version} JPP %{short_name}
%add_to_maven_depmap org.apache.commons %{short_name}-api %{version} JPP %{short_name}-api
%add_to_maven_depmap org.apache.commons %{short_name}-adapters %{version} JPP %{short_name}-adapters

# following lines are only for backwards compatibility. New packages
# should use proper groupid org.apache.commons and also artifactid
%add_to_maven_depmap %{short_name} %{short_name} %{version} JPP %{short_name}
%add_to_maven_depmap %{short_name} %{short_name}-api %{version} JPP %{short_name}-api
%add_to_maven_depmap %{short_name} %{short_name}-adapters %{version} JPP %{short_name}-adapters


# javadoc
install -d -m 755 $RPM_BUILD_ROOT%{_javadocdir}/%{name}
cp -pr target/site/apidocs/* $RPM_BUILD_ROOT%{_javadocdir}/%{name}
ln -s %{name} %buildroot%{_javadocdir}/jakarta-%{short_name}

%if_with repolib
%{__install} -d -m 0755 %{buildroot}%{repodir}
%{__install} -d -m 0755 %{buildroot}%{repodirlib}
%{__install} -p -m 0644 %{SOURCE3} %{buildroot}%{repodir}/component-info.xml
tag=`/bin/echo %{name}-%{version}-%{release} | %{__sed} 's|\.|_|g'`
%{__sed} -i "s/@TAG@/$tag/g" %{buildroot}%{repodir}/component-info.xml

%{__sed} -i 's/project name=""/project name="%{name}"/g' %{buildroot}%{repodir}/component-info.xml
%{__sed} -i "s/@VERSION@/%{version}-brew/g" %{buildroot}%{repodir}/component-info.xml
%{__install} -d -m 0755 %{buildroot}%{repodirsrc}
%{__install} -p -m 0644 %{SOURCE0} %{buildroot}%{repodirsrc}
%{__install} -p -m 0644 %{SOURCE1} %{buildroot}%{repodirsrc}
%{__install} -p -m 0644 %{SOURCE2} %{buildroot}%{repodirsrc}
%{__cp} -p %{buildroot}%{_javadir}/%{short_name}.jar %{buildroot}%{repodirlib}/%{short_name}.jar
%endif

%files
%doc PROPOSAL.html STATUS.html LICENSE.txt RELEASE-NOTES.txt
%{_javadir}/*
%{_mavenpomdir}/JPP-%{short_name}.pom
%{_mavenpomdir}/JPP-%{short_name}-api.pom
%{_mavendepmapfragdir}/*
%exclude %{_javadir}/repository.jboss.com

%files javadoc
%doc LICENSE.txt
%{_javadocdir}/%{name}
%{_javadocdir}/jakarta-%{short_name}

# -----------------------------------------------------------------------------

%changelog
