%define php5_sapi apache2-mod_php
%define so_file  mod_php5.so

Name: apache2-mod_php5
Version: %php5_version
Release: %php5_release

Summary: The PHP5 HTML-embedded scripting language for use with Apache2
Group: System/Servers
License: PHP
Url: http://www.php.net/

Prereq: php5 = %php5_version
Prereq: php5 >= %php5_version-%php5_release
Prereq: apache2-httpd-prefork-like
Requires(post): apache2-httpd-prefork-like
Requires(post): apache2-base

Conflicts: apache2-mod_php
Provides: php-engine = %php5_version-%php5_release

Source0: %{name}-control.tar
Source3: php.ini
Source4: %name-browscap.ini

Patch0: apache2-mod_php5-5.3.3.20100722.patch
Patch1: php-alt-namespace.patch

BuildRequires(pre): rpm-build-php5 apache2-devel
# Automatically added by buildreq on Wed Mar 23 2011
BuildRequires: apache2-devel apache2-httpd-worker libmm-devel libxml2-devel php5-devel zlib-devel
BuildRequires: php5-devel = %php5_version

%description
PHP is an HTML-embedded scripting language. PHP attempts to make it
easy for developers to write dynamically generated web pages. PHP
also offers built-in database integration for several commercial
and non-commercial database management systems, so writing a
database-enabled web page with PHP is fairly simple. The most
common use of PHP coding is probably as a replacement for CGI
scripts. The mod_php module enables the Apache web server to
understand and process the embedded PHP language in web pages.

This package contains PHP version 5. You'll also need to install the
Apache2 web server.

%package control
Summary: Control facility and profiles for %name
Group: System/Servers
Requires: %name = %version-%release
Requires: php-base >= 2.6

%description control
Control facility and profiles for %name to easily switch
between predefined php.ini profiles

%prep
%setup -c
%php5_sapi_prepare apache2handler
%patch0 -p1 -b .fix
%patch1 -p1 -b .fix1

%build
rm -f internal_functions.c

%apache2_apxs \
  $(php-config --includes) \
  $(php-config --ldflags) %php5_optflags \
  $(php-config --libs) \
  -I. -I./include -I/usr/include/apache -Iext/date/lib -I/usr/include/libxml2 \
  -DUSE_TRANSFER_TABLES=1 \
  -lphp-%_php5_version \
  -o %so_file -c *.c

%install
mkdir -p \
	%buildroot/%apache2_mods_available \
	%buildroot/%apache2_mods_start \
	%buildroot/%apache2_moduledir \
	%buildroot/%php5_sysconfdir/%php5_sapi/php.d \
	%buildroot/%php5_sysconfdir/%php5_sapi/control.d \
	%buildroot/%_sysconfdir/control.d/facilities \
	%buildroot/%_rpmlibdir

cp .libs/%so_file %buildroot/%apache2_moduledir

cat > %buildroot/%apache2_mods_available/mod_php5.load <<EOF
LoadModule php5_module %apache2_moduledir/mod_php5.so
EOF

cat > %buildroot/%apache2_mods_available/mod_php5.conf <<EOF
<IfModule mod_php5.c>
    AddType    application/x-httpd-php5-source   .phps
    AddType    application/x-httpd-php5          .php .php5 .php4 .php3 .phtml
    AddHandler application/x-httpd-php5          .php .php5 .php4 .php3 .phtml
</IfModule>
EOF

cat > %buildroot/%apache2_mods_start/mod_php5.conf << EOF
mod_php5=yes
EOF

cat > %buildroot/%_rpmlibdir/%name.filetrigger << EOF
#!/bin/sh
LC_ALL=C sed 's|^%php5_sysconfdir/%php5_sapi/control.d||' |
	egrep -qs '^%php5_sysconfdir/%php5_sapi|^%php5_extdir' || exit 0
%apache2_sbindir/a2chkconfig >/dev/null
%post_apache2conf
EOF
chmod 755 %buildroot/%_rpmlibdir/%name.filetrigger

install -m 644 %SOURCE3 %buildroot/%php5_sysconfdir/%php5_sapi/php.ini
install -m 644 %SOURCE4 %buildroot/%php5_sysconfdir/%php5_sapi/browscap.ini
install -m 755 php.control %buildroot/%_sysconfdir/control.d/facilities/%name
install -m 644 modes/* %buildroot/%php5_sysconfdir/%php5_sapi/control.d/

for f in \
	%buildroot/%php5_sysconfdir/%php5_sapi/php.ini \
	%buildroot/%_sysconfdir/control.d/facilities/%name
do
  subst 's,@SAPI@,%php5_sapi,g' "$f"
  subst 's,@PHP_VERSION@,%_php5_version,g' "$f"
  subst 's,@PHP_MAJOR@,%_php5_major,g' "$f"
  subst 's,@PHP_LIBDIR@,%_libdir/php,g' "$f"
  subst 's,@HTDOCSDIR@,%apache2_htdocsdir,g' "$f"
  subst 's,@PHP_BROWSCAP@,%php5_sysconfdir/%php5_sapi/browscap.ini,g' "$f"
  subst 's,@PHP_UPLOADDIR@,%apache2_spooldir/uploads,g' "$f"
  subst 's,@PHP_SESSIONDIR@,%apache2_spooldir/sessions,g' "$f"
done

%post
%php5_sapi_postin

%preun
%php5_sapi_preun

%postun
if [ $1 = 0 ]; then
	%apache2_sbindir/a2chkconfig >/dev/null
	%post_apache2conf
fi

%files
%config(noreplace) %apache2_mods_available/*
%config(noreplace) %apache2_mods_start/*
%dir %php5_sysconfdir/%php5_sapi
%dir %php5_sysconfdir/%php5_sapi/php.d
%config(noreplace) %php5_sysconfdir/%php5_sapi/php.ini
%config(noreplace) %php5_sysconfdir/%php5_sapi/browscap.ini
%apache2_moduledir/%so_file
%_rpmlibdir/%name.filetrigger
%doc CREDITS

%files control
%config %_sysconfdir/control.d/facilities/*
%dir %php5_sysconfdir/%php5_sapi/control.d/
%config(noreplace) %php5_sysconfdir/%php5_sapi/control.d/*

%changelog
