%setup_python_subpackage apache2_mod_python
%define modname mod_python
%define module_name python

%ifarch %ix86
%define parch i686
%else
%define parch %_arch
%endif

%define a2_version 2.2.9-alt10

%define python_bindir %apache2_htdocsdir/%module_name
Name: apache2-mod_python%__python_package_version
Version: 3.3.1
Release: alt2.5.2.1.1

Summary: Python module for Apache2
Group: System/Servers
License: Free
Url: http://www.modpython.org
Packager: Alexey Morsov <swi@altlinux.ru>

Source: %modname-%version.tgz
Source1: python.load
Source2: python.conf
Source3: python.start

BuildPreReq: rpm-build-apache2 >= %a2_version
BuildRequires: flex python-dev python-modules-encodings
BuildRequires: apache2-devel >= %a2_version
BuildRequires: rpm-build-python >= 0.21-alt1
BuildRequires: python-base >= 2.4.4

Requires: python = %__python_version
Requires: apache2 >= %a2_version

Conflicts: mod_python
Provides: mod_python%__python_version

%add_python_req_skip _apache
%add_python_req_skip _psp


%description
mod_python is an Apache2 module that embeds the Python interpreter within the server.
With mod_python you can write web-based applications in Python that will run many
times faster than traditional CGI and will have access to advanced features such as
ability to retain database connections and other data between hits and access to
Apache internals.

%prep
%setup -q -n %modname-%version
sed -i "s/!(b == APR_BRIGADE_SENTINEL(b) ||/!(b == APR_BRIGADE_SENTINEL(bb) ||/g" src/connobject.c

%build
%configure --with-apxs=%apache2_apxs --prefix=%prefix --with-python-bin=%__python
%make OPT="-fPIC $RPM_OPT_FLAGS -DEAPI" dso

%install
install -d -m 755 -- $RPM_BUILD_ROOT%apache2_mods_available
install -d -m 755 -- $RPM_BUILD_ROOT%apache2_mods_start
install -d -m 755 -- $RPM_BUILD_ROOT%apache2_libexecdir
install -d -m 755 -- $RPM_BUILD_ROOT%apache2_htdocsaddondir/%modname

install -p -m 644 -- %SOURCE1 $RPM_BUILD_ROOT%apache2_mods_available/%module_name.load
install -p -m 644 -- %SOURCE2 $RPM_BUILD_ROOT%apache2_mods_available/%module_name.conf
subst 's,@a_libexecdir@,%apache2_libexecdir,g' $RPM_BUILD_ROOT%apache2_mods_available/%module_name.load
subst 's,@python_bindir@,%python_bindir,g' $RPM_BUILD_ROOT%apache2_mods_available/%module_name.conf
install -p -m 644 -- %SOURCE3 $RPM_BUILD_ROOT%apache2_mods_start/100-%module_name.conf

mkdir -p %buildroot{%python_sitelibdir/%modname,%_docdir/%modname-%version/icons,%python_bindir,\
%apache2_cgibindir}

install -c src/%modname.so %buildroot%apache2_libexecdir
install -c dist/build/lib.%{_os}-%{parch}-%{__python_version}/%modname/*.so %buildroot%python_sitelibdir/%modname

for i in `ls lib/python/%modname/*.py`; do
  install -m 0644 $i %buildroot%python_sitelibdir/%modname;
done

# docs
for i in `ls doc-html/*.html doc-html/*.css`; do
  install -m 0644 $i %buildroot%_docdir/%modname-%version;
done
for i in `ls doc-html/icons/*.gif`; do
  install -m 0644 $i %buildroot%_docdir/%modname-%version/icons;
done

ln -s %_docdir/%modname-%version %buildroot%apache2_htdocsaddondir/%modname

### Creating mptest.py
%__cat <<EOF >mptest.py
from mod_python import apache

def handler(req):
    req.send_http_header()
    req.write("Hello World!")
    return apache.OK
EOF

install -m 0644 mptest.py %buildroot%python_bindir/

%post
# Reconfigure Apache2:
%apache2_sbindir/a2chkconfig ||:

if [ -e %apache2_mods_enabled/%module_name.load ]; then
    CONF_OK=0
    %apache2_sbindir/apachectl2 configtest && CONF_OK=1 ||:
    if [ "$CONF_OK" = "1" ]; then
        service %apache2_dname condrestart ||:
    else
        echo "Some errors detected in Apache2 configuration!"
        echo "To use %modname check configuration and start %apache2_dname service."
    echo
    fi
else
    echo "Apache2 %modname module had been installed, but does't enabled."
    echo "Check %apache2_mods_start directory for files with '%module_name=no' lines."
    echo
fi

%preun
if [ "$1" = "0" ] ; then # last uninstall
    [ -e %apache2_mods_enabled/%module_name.load ] && %apache2_sbindir/a2dismod %module_name 2>&1 >/dev/null ||:
fi



%postun
# Reconfigure Apache2:
%apache2_sbindir/a2chkconfig ||:
if [ "$1" = "0" ] ; then # last uninstall
    CONF_OK=0
    %apache2_sbindir/apachectl2 configtest && CONF_OK=1 ||:
    if [ "$CONF_OK" = "1" ]; then
	service %apache2_dname condrestart ||:
    else
        echo "Some errors detected in Apache2 configuration!"
	echo "To complete %module_name uninstalling check configuration and restart %apache2_dname service."
	echo
    fi
fi



%files
%python_sitelibdir/%modname/*
%apache2_libexecdir/%modname.so
%dir %attr(0775,root,%apache2_webmaster) %python_bindir
%attr(0664,root,%apache2_webmaster) %python_bindir/mptest.py*
%config(noreplace) %apache2_mods_available/%module_name.conf
%config            %apache2_mods_available/%module_name.load
%config            %apache2_mods_start/100-%module_name.conf
%apache2_htdocsaddondir/*
%_docdir/%modname-%version

%changelog
