Name: app-defaults
Version: 0.2.8.5
Release: alt1

Summary: Localized X11 Resources
License: GPL
Group: System/Internationalization
BuildArch: noarch
Packager: Etcskel Development Team <etcskel@packages.altlinux.org>

Source: %name-%version.tar

%define old_list uk uk-cp1251 ru-koi8r ru-cp1251
%define old_provides %(for i in %old_list;do echo -n "%name-$i = %version ";done)
%define old_obsoletes %(for i in %old_list;do echo -n "%name-$i ";done)

%define locales ru_RU.KOI8-R ru_RU.CP1251 uk_UA.CP1251 uk_UA.KOI8-U be_BY.CP1251

Provides: %old_provides
Obsoletes: %old_obsoletes

# Localized font settings for Emacs were removed in 0.2.4.
# This is supported in emacs-21.2-alt14:
Conflicts: emacs-common < 21.2-alt14

# Due to %%_x11x11dir.
BuildPreReq: rpm-build >= 4.0.4-alt42

%description
Localized X11 Resources.

%prep
%setup -q

%install
%makeinstall X11X11DIR=%buildroot%_x11x11dir

:>%name.locales
for l in %locales; do \
    cat >> %name.locales <<EOF
%%lang(${l%%.*}) %%dir %_x11x11dir/$l
%%lang(${l%%.*}) %%dir %_x11x11dir/$l/app-defaults
%%lang(${l%%.*}) %%config(noreplace) %_x11x11dir/$l/app-defaults/*
%%lang(${l%%.*}) %%config(noreplace) %_sysconfdir/X11/Xresources.$l
%%lang(${l%%.*}) %%config(noreplace) %_sysconfdir/X11/Xresources-site.$l

EOF
done

%triggerpostun -- xinitrc < 2.4.5-alt3
[ $2 -gt 0 ] || exit 0
cd %_sysconfdir/X11 || exit 0
if [ ! -f Xresources ]; then
	if [ -f Xresources.rpmsave ]; then
		cp -pf Xresources.rpmsave Xresources
	elif [ -f Xresources.rpmnew ]; then
		cp -pf Xresources.rpmnew Xresources
	fi
fi

%files -f %name.locales
%config(noreplace) %_sysconfdir/X11/Xresources
%config(noreplace) %_sysconfdir/X11/Xresources-site

%changelog
