Name: apt
Version: 0.5.15lorg2
Release: alt42.M70P.2

Summary: Debian's Advanced Packaging Tool with RPM support
Summary(ru_RU.UTF-8): Debian APT - Усовершенствованное средство управления пакетами с поддержкой RPM
License: GPL
Group: System/Configuration/Packaging
URL: http://apt-rpm.org

Source0: %name-%version.tar
Source1: apt.conf
Source2: genbasedir
Source3: README.rsync
Source4: apt.ru.po
Source5: apt.be.po
Source6: ChangeLog-rpm.old

Patch9: apt-0.5.15lorg2-alt-buildlib.patch
Patch10: apt-0.5.15lorg2-alt-rpmSystem-DistroVer.patch
Patch11: apt-0.5.15lorg2-alt-fixes.patch
Patch12: apt-0.5.15cnc5-alt-libtool.patch
Patch13: apt-0.5.15lorg2-alt-readline.patch
Patch14: apt-0.5.15cnc5-alt-rpm-build.patch
Patch15: apt-0.5.15cnc5-alt-distro.patch
Patch16: apt-0.5.15cnc5-alt-debsystem.patch
Patch17: apt-0.5.15cnc6-alt-defaults.patch
Patch18: apt-0.5.5cnc5-alt-rsync.patch
Patch19: apt-0.5.15cnc5-alt-getsrc.patch
Patch20: apt-0.5.15cnc6-alt-parseargs.patch
Patch21: apt-0.5.15cnc5-alt-execrpm-cmd.patch
Patch22: apt-0.5.15cnc6-alt-rpm-fancypercent.patch
Patch23: apt-0.5.15cnc5-alt-gpg-homedir.patch
Patch24: apt-0.5.15cnc5-alt-md5hash-debug.patch
Patch25: apt-0.5.15cnc5-alt-packagemanager-CheckRConflicts.patch
Patch26: apt-0.5.5cnc4.1-alt-PrioComp.patch
Patch27: apt-0.5.4cnc9-alt-pkgorderlist-score.patch
Patch28: apt-0.5.15cnc6-alt-virtual-scores.patch
Patch29: apt-0.5.15cnc5-alt-gettext.patch
Patch30: apt-0.5.15lorg2-alt-lua51.patch
Patch31: apt-0.5.15cnc6-alt-rpm-order.patch
Patch32: apt-0.5.15cnc6-alt-pkgcachegen.patch
Patch33: apt-0.5.15cnc6-alt-apt-shell.patch
Patch34: apt-0.5.15cnc6-alt-umount.patch
Patch35: apt-0.5.15cnc6-alt-apt-get-TryToInstall.patch
Patch36: apt-0.5.15cnc6-alt-lsgroup.patch
Patch37: apt-0.5.15cnc6-alt-apt-shell-dl.patch
Patch38: apt-0.5.15cnc6-alt-dash-cmd.patch
Patch39: apt-0.5.15cnc6-alt-quiet-update.patch
Patch40: apt-0.5.15cnc6-alt-vendor.patch
Patch41: apt-0.5.15cnc6-alt-apt-pipe.patch
Patch42: apt-0.5.15cnc6-alt-PrintLocalFile.patch
Patch43: apt-0.5.15cnc6-apt-utils-locale.patch
Patch44: apt-0.5.15lorg2-alt-apt-shell-resetconfig.patch
Patch45: apt-0.5.15lorg2-alt-pkgInitConfig-cpu.patch
Patch46: apt-0.5.15lorg2-alt-pkgCache-PrvIterator.patch
Patch47: apt-0.5.15lorg2-alt-realloc.patch
Patch48: apt-0.5.15lorg2-alt-apt-get-TryToInstall-PrvPkgCandVer.patch
Patch49: apt-0.5.15lorg2-alt-apt-get-simple-output.patch
Patch50: apt-0.5.15lorg2-alt-versionmatch-TryToChangeVer.patch
Patch51: apt-0.5.15lorg2-alt-exit-status.patch
Patch52: apt-0.5.15lorg2-alt-i18n-apt-shell-typo.patch
Patch53: apt-0.5.15lorg2-alt-src-apt-shell-wrong_message_fix.patch
Patch54: apt-0.5.15lorg2-alt-genpkglist-reqfiles.patch
Patch55: apt-0.5.15lorg2-alt-manifest.patch
Patch56: apt-0.5.15lorg2-lorg-pkgcachegen-selfprov.patch
Patch57: apt-0.5.15lorg2-alt-genpkglist-no-fileflags.patch
Patch58: apt-0.5.15lorg2-lorg-cache-limit.patch
Patch59: apt-0.5.15lorg2-alt-gcc4.3.patch
Patch60: apt-0.5.15lorg2-alt-apt-shell-list_completion.patch
Patch61: apt-0.5.15lorg2-alt-apt-shell-quit_by_eof.patch
Patch62: apt-0.5.15lorg2-alt-rpmdbopen.patch
Patch63: apt-0.5.15lorg2-apt-cdrom-to-media.patch

Patch99: apt-%version-%release.patch
Patch100: apt-0.5.15lorg2-alt-lfs.patch

# Normally not applied, but useful.
Patch101: apt-0.5.4cnc9-alt-getsrc-debug.patch

Requires: libapt = %version-%release
Requires: rpm >= 4.0.4-alt28, /etc/apt/pkgpriorities, apt-conf
# for methods.
Requires: gzip, bzip2, xz
Requires: gnupg, alt-gpgkeys

# for autopoint.
BuildPreReq: cvs

# for apt-pipe.
BuildPreReq: setproctitle-devel

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

# Automatically added by buildreq on Sun Mar 30 2008
BuildRequires: bzlib-devel cvs docbook-utils gcc-c++ liblua5-devel libreadline-devel librpm-devel setproctitle-devel zlib-devel

%package -n libapt
Summary: APT's core libraries
Group: System/Libraries
PreReq: librpm >= 4.0.4-alt28

%package -n libapt-devel
Summary: Development files and documentation for APT's core libs
Summary(ru_RU.UTF-8): Файлы и документация для разработчиков, использующих библиотеки APT
Group: Development/C
Requires: libapt = %version-%release, librpm-devel >= 4.0.4-alt28

%package -n libapt-devel-static
Summary: Development static library for APT's libs
Summary(ru_RU.UTF-8): Статическая библиотека APT для разработчиков, использующих библиотеки APT
Group: Development/C
Requires: libapt-devel = %version-%release, librpm-devel-static >= 4.0.4-alt28

%package utils
Summary: Utilities to create APT repositories (the indices)
Summary(ru_RU.UTF-8): Утилиты для построения APT-репозиториев (индексов)
Group: Development/Other
Requires: %name = %version-%release, mktemp >= 1:1.3.1, getopt
Requires: gnupg, sed

%package rsync
Summary: rsync method support for APT
Summary(ru_RU.UTF-8): Поддержка метода rsync для APT
Group: Development/Other
Requires: %name = %version-%release, rsync >= 2.5.5-alt3

# {{{ descriptions 
%define risk_usage_en This package is still under development.

%description
A port of Debian's APT tools for RPM based distributions,
or at least for Conectiva. It provides the apt-get utility that
provides a simpler, safer way to install and upgrade packages.
APT features complete installation ordering, multiple source
capability and several other unique features.

%risk_usage_en

%define risk_usage Данный пакет пока еще находится в стадии разработки.

%description -l ru_RU.UTF-8
Перенесенные из Debian средства управления пакетами APT, включающие
в себя поддержку RPM, выполненную компанией Conectiva (Бразилия).
Этот пакет содержит утилиту apt-get для простой и надежной установки
и обновления пакетов. APT умеет автоматически разрешать зависимости
при установке, обеспечивает установку из нескольких источников и
целый ряд других уникальных возможностей.

%risk_usage

%description -n libapt
This package contains APT's package manipulation library,
modified for RPM.

%risk_usage_en

%description -n libapt-devel
This package contains the header files and libraries for developing with
APT's package manipulation library, modified for RPM.

%risk_usage_en

%description -n libapt-devel-static
This package contains static libraries for developing with APT's
package manipulation library, modified for RPM.

%risk_usage_en

%description utils
This package contains the utility programs that can prepare a repository of
RPMS binary and source packages for future access by APT (by generating
the indices): genbasedir, genpkglist, gensrclist.

It relates to 'apt' package analoguously to how 'rpm' relates to 'rpm-build' package.

%risk_usage_en

%description rsync
This package contains method 'rsync' for APT.

%risk_usage_en

%description -n libapt -l ru_RU.UTF-8
В этом пакете находится библиотеки управления пакетами
из комплекта APT. В отличие от оригинальной версии для Debian, этот
пакет содержит поддержку для формата RPM.

%risk_usage

%description -n libapt-devel -l ru_RU.UTF-8
В этом пакете находятся заголовочные файлы и библиотеки для разработки
программ, использующих библиотеки управления пакетами
из комплекта APT. В отличие от оригинальной версии для Debian, этот
пакет содержит поддержку для формата RPM.

%risk_usage

%description -n libapt-devel-static -l ru_RU.UTF-8
В этом пакете находятся статические библиотеки для разработки программ,
использующих библиотеки управления пакетами из
комплекта APT. В отличие от оригинальной версии для Debian, этот пакет
содержит поддержку для формата RPM.

%risk_usage

%description utils -l ru_RU.UTF-8
В этом пакете находятся программы-утилиты, которые могут репозиторий
бинарных и исходных пакетов RPM приготовить для доступа с помощью APT
(сгенерировать индексы): genbasedir, genpkglist, gensrclist.

Он относится к пакету 'apt' аналогично тому, как 'rpm'к 'rpm-build'.

%risk_usage

%description rsync -l ru_RU.UTF-8
В этом пакете находится метод 'rsync' для APT

%risk_usage

# }}}

%prep
%setup
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p2
%patch27 -p1
%patch28 -p1
%patch29 -p1
%patch30 -p1
%patch31 -p1
%patch32 -p1
%patch33 -p1
%patch34 -p1
%patch35 -p1
%patch36 -p1
%patch37 -p1
%patch38 -p1
%patch39 -p1
%patch40 -p1
%patch41 -p1
%patch42 -p1
%patch43 -p1
%patch44 -p1
%patch45 -p1
%patch46 -p1
%patch47 -p1
%patch48 -p1
%patch49 -p1
%patch50 -p1
%patch51 -p1
%patch52 -p1
%patch53 -p1
%patch54 -p1
%patch55 -p1
%patch56 -p1
%patch57 -p1
%patch58 -p1
%patch59 -p1
%patch60 -p1
%patch61 -p1
%patch62 -p1
%patch63 -p2
%patch99 -p1
%patch100 -p1

find -type f -name \*.orig -delete

# Ensure system-wide lua5 in use.
rm -rf lua

# Turn it on only if you want to see the debugging messages:
#%patch101 -p1 -b .getsrc-debug

install -pm644 %SOURCE3 %SOURCE6 .
install -pm644 %SOURCE4 po/ru.po
install -pm644 %SOURCE5 po/be.po
sed -i 's|^\(.\+\)$|\1 be|' po/LINGUAS

# Drop obsolete m4/*.m4 files.
rm m4/*.m4

%build
# Fix url.
sed -i 's,/usr/share/common-licenses/GPL,/usr/share/license/GPL,' COPYING

# Unhide potential cc/c++ errors.
sed -i 's, > /dev/null 2>&1,,' buildlib/tools.m4

%autoreconf

%configure --includedir=%_includedir/apt-pkg %{subst_enable static}

# Probably this obsolete now?
find -type f -print0 |
	xargs -r0 grep -EZl '/var(/lib)?/state/apt' -- |
	xargs -r0 %__subst -p 's,/var\(/lib\)\?/state/apt,%_localstatedir/%name,g' --
%make_build

%install
mkdir -p %buildroot%_sysconfdir/%name/{%name.conf,sources.list,vendors.list}.d
mkdir -p %buildroot%_libdir/%name/scripts
mkdir -p %buildroot%_localstatedir/%name/{lists/partial,prefetch}
mkdir -p %buildroot%_cachedir/%name/{archives/partial,gen{pkg,src}list}

%makeinstall includedir=%buildroot%_includedir/apt-pkg

install -pm755 %SOURCE2 %buildroot%_bindir/
install -pm644 %SOURCE1 %buildroot%_sysconfdir/%name/

# This is still needed.
ln -sf rsh %buildroot%_libdir/%name/methods/ssh
ln -sf gzip %buildroot%_libdir/%name/methods/bzip2
ln -sf gzip %buildroot%_libdir/%name/methods/xz

# Cleanup
find %buildroot%_includedir -type f -name rpmshowprogress.h -delete -print
rm %buildroot%_libdir/*.la

bzip2 -9fk ChangeLog-rpm.old

find %buildroot%_includedir -type f -name '*.h' |while read f; do
	cat >>"$f" <<EOF

#include <stdint.h>
#if __WORDSIZE == 32 && !defined(__USE_FILE_OFFSET64)
# error "<${f#%buildroot%_includedir/}> cannot be used without -D_FILE_OFFSET_BITS==64"
#endif
EOF
done

%find_lang %name

unset RPM_PYTHON

%files -f %name.lang
%_bindir/apt-*
%_libdir/%name
%exclude %_libdir/%name/methods/rsync
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%dir %_sysconfdir/%name/*.d
%_mandir/man?/*
%doc README* TODO COPYING AUTHORS* ChangeLog-rpm.old.bz2 doc/examples contrib

%defattr(2770,root,rpm,2770)
%_cachedir/%name/archives

%files -n libapt
%_libdir/*.so.*
%_localstatedir/%name

%defattr(2770,root,rpm,2770)
%dir %_cachedir/%name

%files -n libapt-devel
%_libdir/*.so
%_includedir/*

%if_enabled static
%files -n libapt-devel-static
%_libdir/*.a
%endif

%files rsync
%dir %_libdir/%name
%dir %_libdir/%name/methods
%_libdir/%name/methods/rsync
# Probably %%doc with README.rsync?

%changelog
