%set_verify_elf_method unresolved=relaxed

%define name2 ardour3

Name:    ardour
Version: 3.2
Release: alt2

Summary: Professional multi-track audio recording application
License: GPLv2+
Group:   Sound
Url:     http://ardour.org

Packager: Alex Karpov <karpov@altlinux.ru>

Source:  %name-%version.tar
Source1: ardour3.desktop
Source2: ardour3-3.2-ru.po

BuildRequires: boost-devel
BuildRequires: cppunit-devel >= 1.12.0
BuildRequires: doxygen
BuildRequires: gcc-c++
BuildRequires: graphviz
BuildRequires: libalsa-devel
BuildRequires: libaubio-devel >= 0.3.2
BuildRequires: libcurl-devel >= 7.0.0
BuildRequires: libcwiid-devel
BuildRequires: libfftw3-devel
BuildRequires: libflac-devel >= 1.2.1
BuildRequires: libgnomecanvasmm-devel
BuildRequires: libgtk+2-devel
BuildRequires: libjack-devel
BuildRequires: liblilv-devel >= 0.14
BuildRequires: liblo-devel >= 0.26
BuildRequires: liblrdf-devel >= 0.4.0
# FIXME BuildRequires: libltc-devel >= 1.1.0
BuildRequires: libogg-devel >= 1.1.2
BuildRequires: libredland-devel
BuildRequires: librubberband-devel
BuildRequires: libsamplerate-devel
BuildRequires: libserd-devel >= 0.14.0
BuildRequires: libsndfile-devel >= 1.0.18
BuildRequires: libsord-devel >= 0.8.0
BuildRequires: libsratom-devel >= 0.4.0
BuildRequires: libsuil-devel >= 0.6.0
BuildRequires: libsqlite3-devel
BuildRequires: libuuid-devel
BuildRequires: libusb-devel
BuildRequires: libvamp-devel
BuildRequires: libxml2-devel
BuildRequires: libxslt-devel
BuildRequires: lv2-devel >= 1.0.15
BuildRequires: /proc
BuildRequires: python-devel
BuildRequires: raptor2-devel

# FIXME
#Requires:      jackit
#Requires:      gtk-engines2
# For video import
#Requires:      harvid
#Requires:      xjadeo

Requires:       jack-audio-connection-kit

%description
Ardour is a digital audio workstation. You can use it to record, edit
and mix multi-track audio. You can produce your own CDs, mix video sound
tracks, or just experiment with new ideas about music and sound.

Ardour capabilities include: multi channel recording, non-destructive
editing with unlimited undo/redo, full automation support, a powerful
mixer, unlimited tracks/busses/plugins, time-code synchronization, and
hardware control from surfaces like the Mackie Control Universal.

You must have jackd running and an ALSA sound driver to use Ardour.
If you are new to jackd, try qjackctl.

See the online user manual at http://en.flossmanuals.net/ardour/index/

%prep
%setup -q
cp %SOURCE2 gtk2_ardour/po/ru.po

# Generate revision number
echo '#include "ardour/revision.h"' > libs/ardour/revision.cc
echo 'namespace ARDOUR { const char* revision = "%version"; }' >> libs/ardour/revision.cc

%build
./waf configure \
    --prefix=%_prefix \
    --libdir=%_libdir \
    --configdir=%_sysconfdir \
    --program-name=Ardour \
    --nls \
    --docs

./waf build \
    --nls \
    --docs

./waf i18n_mo

%install
./waf install --destdir=%buildroot

install -d -m 0755 %buildroot%_desktopdir
install -m 644 %SOURCE1 %buildroot%_desktopdir/

install -d -m 0755 %buildroot%_iconsdir
cp -f %buildroot%_datadir/%name2/icons/application-x-ardour_48px.png %buildroot%_iconsdir/ardour3.png

%add_findprov_lib_path %_libdir/%name2
%find_lang --output=%name.lang %name2 gtk2_ardour3 gtkmm2ext3

%files -f %name.lang
%doc README
%_bindir/*
%dir %_datadir/%name2
%_libdir/%name2/*.so
%_libdir/%name2/sanityCheck
%_libdir/%name2/ardour-%{version}
%_libdir/%name2/*.so.*
%_libdir/%name2/panners/*.so
%_libdir/%name2/panners/*.so.*
%_libdir/%name2/surfaces/*.so
%_libdir/%name2/surfaces/*.so.*
%_libdir/%name2/engines/*.so
%_libdir/%name2/vamp/*.so
%_libdir/%name2/vamp/*.so.*
%_datadir/%name2
%_desktopdir/*.desktop
%dir %_sysconfdir/%name2
%config(noreplace) %_sysconfdir/%name2/%{name2}_ui_default.conf
%config(noreplace) %_sysconfdir/%name2/%{name2}_ui_light.rc
%config(noreplace) %_sysconfdir/%name2/%{name2}_ui_dark.rc
%config(noreplace) %_sysconfdir/%name2/ardour.menus
%config(noreplace) %_sysconfdir/%name2/ardour_system.rc
%config(noreplace) %_sysconfdir/%name2/step_editing.bindings
%config(noreplace) %_sysconfdir/%name2/mnemonic-us.bindings
%config(noreplace) %_sysconfdir/%name2/mixer.bindings
%dir %_sysconfdir/%name2/export
%config(noreplace) %_sysconfdir/%name2/export/CD.format
%_iconsdir/ardour3.png

%changelog
